/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.idea;

import dmg.security.cipher.BlockCipher;
import java.util.Date;
import java.util.Random;

public class Jidea
implements BlockCipher {
    private int[] _k = new int[54];
    private int[] _dk = new int[54];
    private byte[] _vec = new byte[8];
    private int _num = 0;
    private byte[] _key = new byte[16];
    private final int DECRYPT = 0;
    private final int ENCRYPT = 1;

    public Jidea() {
        byte[] key = new byte[this._key.length];
        Random r = new Random(new Date().getTime());
        r.nextBytes(key);
        this._Jdea(key);
    }

    public Jidea(byte[] key) {
        this._Jdea(key);
    }

    private void _Jdea(byte[] key) {
        System.arraycopy(key, 0, this._key, 0, this._key.length);
        for (int i = 0; i < this._key.length / 2; ++i) {
            this._vec[i] = (byte)(this._key[i] ^ this._key[i + this._vec.length]);
        }
        this.createEnKey(this._key);
        this.createDeKey();
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    public byte[] getKeyBytes() {
        byte[] out = new byte[this._key.length];
        System.arraycopy(this._key, 0, out, 0, this._key.length);
        return out;
    }

    public void setStartValue(byte[] vec) {
        System.arraycopy(vec, 0, this._vec, 0, vec.length > this._vec.length ? this._vec.length : vec.length);
        this._num = 0;
    }

    public byte[] getStartValue() {
        byte[] vec = new byte[this._vec.length];
        System.arraycopy(this._vec, 0, vec, 0, this._vec.length);
        return vec;
    }

    public void encryptECB(byte[] in, int inOff, byte[] out, int outOff) {
        this.xcrypt(in, inOff, out, outOff, this._k);
    }

    @Override
    public void encrypt(byte[] in, int inOff, byte[] out, int outOff) {
        this.xcrypt(in, inOff, out, outOff, this._k);
    }

    public void decryptECB(byte[] in, int inOff, byte[] out, int outOff) {
        this.xcrypt(in, inOff, out, outOff, this._dk);
    }

    @Override
    public void decrypt(byte[] in, int inOff, byte[] out, int outOff) {
        this.xcrypt(in, inOff, out, outOff, this._dk);
    }

    private void createEnKey(byte[] key) {
        int i;
        int[] k = new int[16];
        for (i = 0; i < 16; ++i) {
            k[i] = key[i] < 0 ? 256 + key[i] : key[i];
        }
        for (i = 0; i < 8; ++i) {
            this._k[i] = k[2 * i] << 8 | k[2 * i + 1];
        }
        int kt = 0;
        int kf = 0;
        kt += 8;
        for (int i2 = 0; i2 < 6; ++i2) {
            int r2 = this._k[kf + 1];
            int r1 = this._k[kf + 2];
            this._k[kt++] = (r2 << 9 | r1 >>> 7) & 0xFFFF;
            int r0 = this._k[kf + 3];
            this._k[kt++] = (r1 << 9 | r0 >>> 7) & 0xFFFF;
            r1 = this._k[kf + 4];
            this._k[kt++] = (r0 << 9 | r1 >>> 7) & 0xFFFF;
            r0 = this._k[kf + 5];
            this._k[kt++] = (r1 << 9 | r0 >>> 7) & 0xFFFF;
            r1 = this._k[kf + 6];
            this._k[kt++] = (r0 << 9 | r1 >>> 7) & 0xFFFF;
            r0 = this._k[kf + 7];
            this._k[kt++] = (r1 << 9 | r0 >>> 7) & 0xFFFF;
            r1 = this._k[kf + 0];
            if (i2 >= 5) break;
            this._k[kt++] = (r0 << 9 | r1 >>> 7) & 0xFFFF;
            this._k[kt++] = (r1 << 9 | r2 >>> 7) & 0xFFFF;
            kf += 8;
        }
    }

    private void createDeKey() {
        int tp = 0;
        int fp = 48;
        for (int r = 0; r < 9; ++r) {
            this._dk[tp++] = this.inverse(this._k[fp + 0]);
            this._dk[tp++] = (int)(65536L - (long)this._k[fp + 2]) & 0xFFFF;
            this._dk[tp++] = (int)(65536L - (long)this._k[fp + 1]) & 0xFFFF;
            this._dk[tp++] = this.inverse(this._k[fp + 3]);
            if (r == 8) break;
            this._dk[tp++] = this._k[(fp -= 6) + 4];
            this._dk[tp++] = this._k[fp + 5];
        }
        int t = this._dk[1];
        this._dk[1] = this._dk[2];
        this._dk[2] = t;
        t = this._dk[49];
        this._dk[49] = this._dk[50];
        this._dk[50] = t;
    }

    private int inverse(int xin) {
        int b2;
        if (xin == 0) {
            b2 = 0;
        } else {
            int r;
            int n1 = 65537;
            int n2 = xin;
            b2 = 1;
            int b1 = 0;
            do {
                r = n1 % n2;
                int q = (n1 - r) / n2;
                if (r == 0) {
                    if (b2 >= 0) continue;
                    b2 = 65537 + b2;
                    continue;
                }
                n1 = n2;
                n2 = r;
                int t = b2;
                b2 = b1 - q * b2;
                b1 = t;
            } while (r != 0);
        }
        return b2;
    }

    private int mul(int a, int b) {
        long r;
        long ul = (long)a * (long)b;
        if (ul != 0L) {
            r = (ul & 0xFFFFL) - (ul >> 16);
            r -= r >> 16;
        } else {
            r = -((long)a) - (long)b + 1L;
        }
        return (int)(r & 0xFFFFL);
    }

    private void xcrypt(byte[] in, int inOff, byte[] out, int outOff, int[] key) {
        int[] d = new int[]{(in[inOff + 0] & 0xFF) << 24 | (in[inOff + 1] & 0xFF) << 16 | (in[inOff + 2] & 0xFF) << 8 | (in[inOff + 3] & 0xFF) << 0, (in[inOff + 4] & 0xFF) << 24 | (in[inOff + 5] & 0xFF) << 16 | (in[inOff + 6] & 0xFF) << 8 | (in[inOff + 7] & 0xFF) << 0};
        this.xcrypt(d, key);
        out[outOff + 0] = (byte)(d[0] >>> 24 & 0xFF);
        out[outOff + 1] = (byte)(d[0] >>> 16 & 0xFF);
        out[outOff + 2] = (byte)(d[0] >>> 8 & 0xFF);
        out[outOff + 3] = (byte)(d[0] >>> 0 & 0xFF);
        out[outOff + 4] = (byte)(d[1] >>> 24 & 0xFF);
        out[outOff + 5] = (byte)(d[1] >>> 16 & 0xFF);
        out[outOff + 6] = (byte)(d[1] >>> 8 & 0xFF);
        out[outOff + 7] = (byte)(d[1] >>> 0 & 0xFF);
    }

    private void xcrypt(int[] d, int[] key) {
        int t1;
        int t0;
        int x2 = d[0];
        int x1 = x2 >>> 16;
        int x4 = d[1];
        int x3 = x4 >>> 16;
        x2 &= 0xFFFF;
        x1 &= 0xFFFF;
        x3 &= 0xFFFF;
        x4 &= 0xFFFF;
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            x1 &= 0xFFFF;
            x1 = this.mul(x1, key[p++]);
            x2 += key[p++];
            int n = p++;
            x4 &= 0xFFFF;
            x4 = this.mul(x4, key[p++]);
            t0 = (x1 ^ (x3 += key[n])) & 0xFFFF;
            t0 = this.mul(t0, key[p++]);
            t1 = t0 + (x2 ^ x4) & 0xFFFF;
            t1 = this.mul(t1, key[p++]);
            x1 ^= t1;
            x4 ^= (t0 += t1);
            int ul = x2 ^ t0;
            x2 = x3 ^ t1;
            x3 = ul;
        }
        x1 &= 0xFFFF;
        x1 = this.mul(x1, key[p++]);
        t0 = x3 + key[p++];
        t1 = x2 + key[p++];
        x4 &= 0xFFFF;
        x4 = this.mul(x4, key[p]);
        d[0] = t0 & 0xFFFF | (x1 & 0xFFFF) << 16;
        d[1] = x4 & 0xFFFF | (t1 & 0xFFFF) << 16;
    }
}

