/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher;

import dmg.security.cipher.BlockCipher;
import dmg.security.cipher.StreamFromBlockCipher;
import dmg.security.cipher.blowfish.Jblowfish;
import dmg.security.cipher.des.Jdes;
import dmg.security.cipher.idea.Jidea;
import java.util.Date;
import java.util.Random;

public class StreamTest {
    private static byte[] __key = new byte[]{10, 33, -10, -49, 112, -8, 7, -109, 55, -9, -101, -4, -112, -46, 94, -124};
    private static String __usage = "USAGE : StreamTest idea|des|blowfish ecb|cfb|cbc [blocks]";

    public static void main(String[] args) {
        int i;
        BlockCipher cipher = null;
        if (args.length < 3) {
            System.err.println(__usage);
            System.exit(3);
        }
        String cipherType = args[0];
        String cipherMode = args[1];
        int blocks = new Integer(args[2]);
        Random r = new Random(new Date().getTime());
        byte[] key = new byte[16];
        r.nextBytes(key);
        if (cipherType.equals("idea")) {
            cipher = new Jidea(key);
        } else if (cipherType.equals("des")) {
            cipher = new Jdes(key);
        } else if (cipherType.equals("blowfish")) {
            cipher = new Jblowfish(key);
        } else {
            System.err.println(__usage);
            System.exit(4);
        }
        int block = cipher.getBlockLength() / 8;
        byte[] vector = new byte[block];
        StreamFromBlockCipher encrypt = new StreamFromBlockCipher(cipher, vector);
        StreamFromBlockCipher decrypt = new StreamFromBlockCipher(cipher, vector);
        byte[] in = new byte[block * blocks];
        byte[] out = new byte[block * blocks];
        byte[] chk = new byte[block * blocks];
        r.nextBytes(in);
        long start = 0L;
        long en = 0L;
        long de = 0L;
        if (cipherMode.equals("ecb")) {
            start = new Date().getTime();
            for (i = 0; i < blocks; ++i) {
                encrypt.encryptECB(in, i * block, out, i * block);
            }
            en = new Date().getTime();
            for (i = 0; i < blocks; ++i) {
                decrypt.decryptECB(out, i * block, chk, i * block);
            }
            de = new Date().getTime();
        } else if (cipherMode.equals("cfb")) {
            start = new Date().getTime();
            encrypt.encryptCFB(in, 0, out, 0, block * blocks);
            en = new Date().getTime();
            decrypt.decryptCFB(out, 0, chk, 0, block * blocks);
            de = new Date().getTime();
        } else if (cipherMode.equals("cbc")) {
            start = new Date().getTime();
            encrypt.encryptCBC(in, 0, out, 0, block * blocks);
            en = new Date().getTime();
            decrypt.decryptCBC(out, 0, chk, 0, block * blocks);
            de = new Date().getTime();
        } else {
            System.err.println(__usage);
            System.exit(5);
        }
        StreamTest.say(" Cipher Type       : " + cipherType);
        StreamTest.say(" Cipher Mode       : " + cipherMode);
        StreamTest.say(" Cipher Block size : " + block);
        StreamTest.say(" Encryption Key    : " + StreamTest.byteToHexString(key));
        StreamTest.say(" Encryption Time   : " + (en - start));
        StreamTest.say(" Decryption Time   : " + (de - en));
        if (blocks < 5) {
            StreamTest.say(" Original Data     : " + StreamTest.byteToHexString(in));
            StreamTest.say(" Encrypted Data    : " + StreamTest.byteToHexString(out));
            StreamTest.say(" Decrypted Data    : " + StreamTest.byteToHexString(chk));
        }
        for (i = 0; i < in.length && in[i] == chk[i]; ++i) {
        }
        if (i < in.length) {
            System.exit(3);
        }
        System.exit(0);
    }

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length + 1);
        for (int i = 0; i < b.length; ++i) {
            sb.append(StreamTest.byteToHexString(b[i])).append(" ");
        }
        return sb.toString();
    }

    private static void say(String str) {
        System.out.println(str);
    }
}

