/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher;

import dmg.security.cipher.StreamFromBlockCipher;
import dmg.security.cipher.blowfish.Jblowfish;

public class BlockTest {
    private static byte[] __key = new byte[]{10, 33, -10, -49, 112, -8, 7, -109, 55, -9, -101, -4, -112, -46, 94, -124};
    private static byte[] __in = new byte[]{77, 6, 120, 113, 3, 5, 90, 55, 39, 54, 62, 101, 49, 32, 93, 44, 77, 6, 120, 113, 3, 5, 90, 55, 39, 54, 62, 101, 49, 32, 93, 44};
    private static byte[] __dataIn = new byte[]{-1, 2, -2, 4, -3, 6, -4, 8};

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length + 1);
        for (int i = 0; i < b.length; ++i) {
            sb.append(BlockTest.byteToHexString(b[i])).append(" ");
        }
        return sb.toString();
    }

    private static void say(String str) {
        System.out.println(str);
    }

    public static byte parseByte(String str) {
        int i = Integer.parseInt(str, 16);
        return (byte)i;
    }

    public static void main2(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            byte b = BlockTest.parseByte(args[i]);
            System.out.println(args[i] + " : " + b + " " + BlockTest.byteToHexString(b));
        }
        Jblowfish cipher = new Jblowfish(__key);
        byte[] outBlock = new byte[__dataIn.length];
        byte[] revBlock = new byte[__dataIn.length];
        cipher.encrypt(__dataIn, 0, outBlock, 0);
        cipher.decrypt(outBlock, 0, revBlock, 0);
        BlockTest.say(" Data : " + BlockTest.byteToHexString(__dataIn));
        BlockTest.say(" En   : " + BlockTest.byteToHexString(outBlock));
        BlockTest.say(" De   : " + BlockTest.byteToHexString(revBlock));
    }

    public static void main(String[] args) {
        if (args.length < 34) {
            System.err.println(" ... <cipher> e|d <key=xx xx xx ...> <values=vv vv vv>");
            System.exit(3);
        }
        byte[] vector = new byte[8];
        byte[] key = new byte[32];
        String mode = args[1];
        for (int i = 0; i < key.length; ++i) {
            key[i] = BlockTest.parseByte(args[i + 2]);
        }
        byte[] in = new byte[args.length - 2 - key.length];
        for (int i = 0; i < in.length; ++i) {
            in[i] = BlockTest.parseByte(args[i + 2 + key.length]);
        }
        BlockTest.say(" Key               : " + BlockTest.byteToHexString(key));
        BlockTest.say(" Mode              : " + mode);
        BlockTest.say(" Original Data     : " + BlockTest.byteToHexString(in));
        Jblowfish cipher = new Jblowfish(key);
        StreamFromBlockCipher encrypt = new StreamFromBlockCipher(cipher, vector, "cbc");
        byte[] out = new byte[in.length];
        if (mode.equals("e")) {
            encrypt.encryptCBC(in, 0, out, 0, in.length);
            BlockTest.say(" Encrypted Data    : " + BlockTest.byteToHexString(out));
        } else {
            encrypt.decryptCBC(in, 0, out, 0, in.length);
            BlockTest.say(" Decrypted Data    : " + BlockTest.byteToHexString(out));
        }
    }
}

