/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.telnet;

import java.io.IOException;
import java.io.InputStream;

public class TelnetInputStream
extends InputStream {
    private static final byte telnetSE = -16;
    private static final byte telnetNOP = -15;
    private static final byte telnetDM = -14;
    private static final byte telnetBRK = -13;
    private static final byte telnetIP = -12;
    private static final byte telnetAO = -11;
    private static final byte telnetAYT = -10;
    private static final byte telnetEC = -9;
    private static final byte telnetEL = -8;
    private static final byte telnetGA = -7;
    private static final byte telnetSB = -6;
    private static final byte telnetWILL = -5;
    private static final byte telnetWONT = -4;
    private static final byte telnetDO = -3;
    private static final byte telnetDONT = -2;
    private static final byte telnetIAC = -1;
    private static final byte telnetCR = 13;
    private static final byte telnetLF = 10;
    private static final byte telnetNUL = 0;
    private static final byte telnetOptionEcho = 1;
    private static final int telnetStateControl = 0;
    private static final int telnetStateIntro = 1;
    private static final int telnetStateAuthUser = 2;
    private static final int telnetStateAuthPasswd = 3;
    private static final int telnetStateMOTD = 4;
    private static final int telnetStateData = 5;
    private static final int telnetStateNoAccess = 6;
    private static final int cctData = 1;
    private static final int cctCR = 2;
    private static final int cctCR2 = 3;
    private static final int cctCT1 = 4;
    private static final int cctCT2 = 5;
    private static final int cctSUB = 6;
    private static final int cctESC = 7;
    int _engineState;
    int _controlDataPos;
    byte[] _controlData;
    InputStream _inputStream;

    public TelnetInputStream(InputStream in) {
        this._inputStream = in;
        this._engineState = 0;
        this._controlData = null;
        this._controlDataPos = 0;
    }

    private void _engineControlAdd(byte c) {
        if (this._controlDataPos >= this._controlData.length) {
            this._controlDataPos = 0;
        }
        this._controlData[this._controlDataPos++] = c;
    }

    private void _engineControlClear() {
        if (this._controlData == null) {
            this._controlData = new byte[32];
        }
        this._controlDataPos = 0;
    }

    private byte[] _engineControlGet() {
        if (this._controlDataPos == 0) {
            return null;
        }
        byte[] rc = new byte[this._controlDataPos];
        System.arraycopy(this._controlData, 0, rc, 0, this._controlDataPos);
        this._engineControlClear();
        return rc;
    }

    public Object readNext() throws IOException {
        int rc;
        Object obj;
        do {
            if ((rc = this._inputStream.read()) >= 0) continue;
            return null;
        } while ((obj = this._next((byte)rc)) == null);
        return obj;
    }

    @Override
    public int read() throws IOException {
        Object obj;
        while ((obj = this.readNext()) != null) {
            if (obj instanceof Byte) {
                return ((Byte)obj).intValue();
            }
            System.out.println("Got telnet control : " + obj.toString());
        }
        return -1;
    }

    private Object _next(byte c) {
        if (this._engineState == 0) {
            this._engineControlClear();
            this._engineState = 1;
        }
        switch (this._engineState) {
            case 1: {
                if (c == -1) {
                    this._engineState = 4;
                    break;
                }
                if (c == 13) {
                    this._engineState = 2;
                    break;
                }
                return this._charOfByte(c);
            }
            case 4: {
                if (c == -1) {
                    this._engineState = 1;
                    return this._charOfByte(c);
                }
                if (c == -6) {
                    this._engineState = 6;
                    this._engineControlAdd((byte)-1);
                    this._engineControlAdd(c);
                    break;
                }
                this._engineState = 5;
                this._engineControlAdd((byte)-1);
                this._engineControlAdd(c);
                break;
            }
            case 5: {
                this._engineState = 1;
                this._engineControlAdd(c);
                return this._engineControlGet();
            }
            case 6: {
                if (c == -1) {
                    this._engineState = 7;
                    break;
                }
                this._engineControlAdd(c);
                break;
            }
            case 7: {
                if (c == -16) {
                    this._engineState = 1;
                    this._engineControlAdd((byte)-1);
                    this._engineControlAdd(c);
                    return this._engineControlGet();
                }
                this._engineState = 6;
                this._engineControlAdd((byte)-1);
                this._engineControlAdd(c);
                break;
            }
            case 2: {
                this._engineState = 3;
                return Character.valueOf('\n');
            }
            case 3: {
                if (c == -1) {
                    this._engineState = 4;
                    break;
                }
                if (c == 13) {
                    this._engineState = 2;
                    break;
                }
                this._engineState = 1;
                return this._charOfByte(c);
            }
        }
        return null;
    }

    private Character _charOfByte(byte c) {
        byte[] rc = new byte[]{c};
        return Character.valueOf(new String(rc).charAt(0));
    }
}

