/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshRsaKey;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class SshRsaKeyContainer
extends Hashtable {
    public SshRsaKeyContainer(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            try {
                SshRsaKey key = new SshRsaKey(line);
                this.put(key.getModulus(), key);
            }
            catch (Exception ee) {
                System.err.println(" Problem : " + ee);
            }
        }
    }

    public SshRsaKey findByModulus(SshRsaKey searchKey) {
        return (SshRsaKey)this.get(searchKey.getModulus());
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println(" USAGE : SshRsaKeyContainer <publicKeyFile>");
            System.exit(3);
        }
        try {
            SshRsaKeyContainer container = new SshRsaKeyContainer(new FileInputStream(args[0]));
            System.out.println(" Container holds " + container.size() + " keys");
            Enumeration e = container.elements();
            while (e.hasMoreElements()) {
                SshRsaKey key = (SshRsaKey)e.nextElement();
                System.out.println("\n" + key);
            }
        }
        catch (Exception e) {
            System.err.println(" problem : " + e);
            System.exit(3);
        }
    }
}

