/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshCmsgAuthPassword;
import dmg.protocols.ssh.SshCmsgAuthRhostsRsa;
import dmg.protocols.ssh.SshCmsgAuthRsa;
import dmg.protocols.ssh.SshCmsgAuthRsaResponse;
import dmg.protocols.ssh.SshCmsgExecShell;
import dmg.protocols.ssh.SshCmsgExitConfirmation;
import dmg.protocols.ssh.SshCmsgSessionKey;
import dmg.protocols.ssh.SshCmsgStdinData;
import dmg.protocols.ssh.SshCmsgUser;
import dmg.protocols.ssh.SshMsgDebug;
import dmg.protocols.ssh.SshSmsgAuthRsaChallenge;
import dmg.protocols.ssh.SshSmsgExitStatus;
import dmg.protocols.ssh.SshSmsgFailure;
import dmg.protocols.ssh.SshSmsgPublicKey;
import dmg.protocols.ssh.SshSmsgStderrData;
import dmg.protocols.ssh.SshSmsgStdoutData;
import dmg.protocols.ssh.SshSmsgSuccess;
import dmg.security.cipher.StreamCipher;
import dmg.security.digest.Crc32;
import dmg.security.digest.MsgDigest;
import java.util.Date;
import java.util.Random;

public class SshPacket {
    StreamCipher _cipher;
    MsgDigest _digest = new Crc32();
    byte[] _payload;
    int _type;
    public static final int SSH_MSG_NONE = 0;
    public static final int SSH_MSG_DISCONNECT = 1;
    public static final int SSH_SMSG_PUBLIC_KEY = 2;
    public static final int SSH_CMSG_SESSION_KEY = 3;
    public static final int SSH_CMSG_USER = 4;
    public static final int SSH_CMSG_AUTH_RSA_RHOSTS = 5;
    public static final int SSH_CMSG_AUTH_RSA = 6;
    public static final int SSH_SMSG_AUTH_RSA_CHALLENGE = 7;
    public static final int SSH_CMSG_AUTH_RSA_RESPONSE = 8;
    public static final int SSH_CMSG_AUTH_PASSWORD = 9;
    public static final int SSH_CMSG_REQUEST_PTY = 10;
    public static final int SSH_CMSG_WINDOW_SIZE = 11;
    public static final int SSH_CMSG_EXEC_SHELL = 12;
    public static final int SSH_CMSG_EXEC_CMD = 13;
    public static final int SSH_SMSG_SUCCESS = 14;
    public static final int SSH_SMSG_FAILURE = 15;
    public static final int SSH_CMSG_STDIN_DATA = 16;
    public static final int SSH_SMSG_STDOUT_DATA = 17;
    public static final int SSH_SMSG_STDERR_DATA = 18;
    public static final int SSH_CMSG_EOF = 19;
    public static final int SSH_SMSG_EXITSTATUS = 20;
    public static final int SSH_CMSG_KEX_DH_GEX_REQUEST_OLD = 30;
    public static final int SSH_CMSG_EXIT_CONFORMATION = 33;
    public static final int SSH_CMSG_X11_REQUEST_FORWARDING = 34;
    public static final int SSH_CMSG_AUTH_RHOSTS_RSA = 35;
    public static final int SSH_MSG_DEBUG = 36;

    public SshPacket(StreamCipher cipher) {
        this._cipher = cipher;
        this.detectType();
    }

    public SshPacket() {
        this._cipher = null;
        this.detectType();
    }

    public SshPacket(StreamCipher cipher, byte[] data, int leng) {
        int i;
        this._cipher = cipher;
        int padding = 8 - leng % 8;
        if (this._cipher != null) {
            this._cipher.decrypt(data, 0, data, 0, leng + padding);
        }
        this._digest.update(data, 0, data.length - 4);
        byte[] dig = this._digest.digest();
        int pos = padding;
        this._type = data[pos++];
        int payloadLength = leng - 5;
        this._payload = new byte[payloadLength];
        System.arraycopy(data, pos, this._payload, 0, payloadLength);
        pos += payloadLength;
        for (i = 0; i < 4 && dig[i] == data[pos + i]; ++i) {
        }
        if (i < 4) {
            System.out.println(" Got : " + SshPacket.byteToHexString(data));
            throw new IllegalArgumentException("Wrong crc");
        }
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public int getType() {
        return this._type;
    }

    protected int detectType() {
        this._type = 0;
        if (this instanceof SshSmsgSuccess) {
            this._type = 14;
        } else if (this instanceof SshSmsgFailure) {
            this._type = 15;
        } else if (this instanceof SshSmsgPublicKey) {
            this._type = 2;
        } else if (this instanceof SshCmsgSessionKey) {
            this._type = 3;
        } else if (this instanceof SshCmsgUser) {
            this._type = 4;
        } else if (this instanceof SshCmsgStdinData) {
            this._type = 16;
        } else if (this instanceof SshSmsgStdoutData) {
            this._type = 17;
        } else if (this instanceof SshSmsgStderrData) {
            this._type = 18;
        } else if (this instanceof SshSmsgExitStatus) {
            this._type = 20;
        } else if (this instanceof SshCmsgExitConfirmation) {
            this._type = 33;
        } else if (this instanceof SshCmsgAuthRsa) {
            this._type = 6;
        } else if (this instanceof SshCmsgAuthRhostsRsa) {
            this._type = 35;
        } else if (this instanceof SshCmsgAuthPassword) {
            this._type = 9;
        } else if (this instanceof SshSmsgAuthRsaChallenge) {
            this._type = 7;
        } else if (this instanceof SshCmsgAuthRsaResponse) {
            this._type = 8;
        } else if (this instanceof SshCmsgExecShell) {
            this._type = 12;
        } else if (this instanceof SshMsgDebug) {
            this._type = 36;
        }
        return this._type;
    }

    public byte[] toByteArray() {
        return null;
    }

    public byte[] toByteArray(StreamCipher cipher) {
        throw new IllegalArgumentException("toByteArray not overloaded");
    }

    public byte[] makePacket(byte[] payload) {
        return this.makePacket(this._cipher, this._type, payload);
    }

    public byte[] makePacket(StreamCipher cipher, byte[] payload) {
        return this.makePacket(cipher, this._type, payload);
    }

    private byte[] makePacket(StreamCipher cipher, int type, byte[] payload) {
        int length = payload.length + 5;
        int padding = 8 - length % 8;
        int total = length + padding + 4;
        byte[] out = new byte[total];
        byte[] paddingBytes = new byte[padding];
        if (cipher != null) {
            Random r = new Random(new Date().getTime());
            r.nextBytes(paddingBytes);
        }
        int pos = 0;
        this.punchInt(out, pos, length);
        int encStart = pos += 4;
        int crcStart = pos;
        System.arraycopy(paddingBytes, 0, out, pos, paddingBytes.length);
        out[pos += paddingBytes.length] = (byte)type;
        System.arraycopy(payload, 0, out, ++pos, payload.length);
        this._digest.reset();
        this._digest.update(out, crcStart, (pos += payload.length) - crcStart);
        byte[] digest = this._digest.digest();
        System.arraycopy(digest, 0, out, pos, digest.length);
        pos += digest.length;
        if (cipher != null) {
            cipher.encrypt(out, encStart, out, encStart, pos - encStart);
        }
        return out;
    }

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length + 1);
        for (int i = 0; i < b.length; ++i) {
            sb.append(SshPacket.byteToHexString(b[i])).append(" ");
        }
        return sb.toString();
    }

    protected int intFromBytes(byte[] b, int off) {
        return (b[off + 0] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    protected void punchInt(byte[] a, int off, int value) {
        a[off + 0] = (byte)(value >>> 24 & 0xFF);
        a[off + 1] = (byte)(value >>> 16 & 0xFF);
        a[off + 2] = (byte)(value >>> 8 & 0xFF);
        a[off + 3] = (byte)(value >>> 0 & 0xFF);
    }

    protected void punchShort(byte[] a, int off, int value) {
        a[off + 0] = (byte)(value >>> 8 & 0xFF);
        a[off + 1] = (byte)(value >>> 0 & 0xFF);
    }
}

