/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshStreamEngine;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshOutputStream
extends OutputStream {
    private static final Logger _log = LoggerFactory.getLogger(SshOutputStream.class);
    private SshStreamEngine _core = null;
    private int _mode;

    public SshOutputStream(SshStreamEngine core) {
        this._core = core;
        this._mode = this._core.getMode();
    }

    @Override
    public void write(int out) throws IOException {
        _log.debug("write( int {} )", (Object)out);
        byte[] x = new byte[]{(byte)out};
        this.write(x, 0, 1);
    }

    @Override
    public void write(byte[] a, int off, int len) throws IOException {
        if (!this._core.isActive()) {
            throw new IOException("Stream not Active");
        }
        if (this._mode == 1) {
            _log.debug("server-mode: write(byte [] a, int off, int {})", (Object)len);
            this._core.sendStdout(a, off, len);
        } else {
            _log.debug("client-mode: write(byte [] a, int off, int {})", (Object)len);
            this._core.sendStdin(a, off, len);
        }
    }

    @Override
    public void write(byte[] a) throws IOException {
        _log.debug("write( byte [] a )");
        this.write(a, 0, a.length);
    }

    @Override
    public void close() throws IOException {
        this._core.close();
    }
}

