/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpObjectHeader;
import java.util.Vector;

public class SnmpSequence
extends SnmpObject {
    private Vector _vector = new Vector();

    SnmpSequence(SnmpObjectHeader head, byte[] b, int offIn, int maxLen) {
        int len;
        int off = offIn + head.getCodedLength();
        int rest = len = head.getLength();
        while (rest > 0) {
            SnmpObject snmp = SnmpObject.generate(b, off, rest);
            this._vector.addElement(snmp);
            int cl = snmp.getCodedLength();
            rest -= cl;
            off += cl;
        }
        this.setCodedLength(head.getCodedLength() + len);
    }

    public SnmpSequence() {
    }

    public SnmpSequence(SnmpSequence snmp) {
        this._vector = snmp._vector;
    }

    public void removeAllObjects() {
        this._vector.removeAllElements();
    }

    public void addObject(SnmpObject snmp) {
        this._vector.addElement(snmp);
    }

    public SnmpObject objectAt(int i) {
        return (SnmpObject)this._vector.elementAt(i);
    }

    public int size() {
        return this._vector.size();
    }

    public String toString() {
        return this.toString("Sequence");
    }

    public String toString(String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(type + "\n");
        for (int i = 0; i < this._vector.size(); ++i) {
            SnmpObject snmp = (SnmpObject)this._vector.elementAt(i);
            sb.append("Class : " + snmp.getClass().getName());
            if (snmp instanceof SnmpSequence) {
                sb.append("Value : \n" + snmp.toString() + "\n");
                continue;
            }
            sb.append("Value : " + snmp.toString() + "\n");
        }
        return sb.toString();
    }

    @Override
    public byte[] getSnmpBytes() {
        return this.getSnmpBytes(48);
    }

    protected byte[] getSnmpBytes(int type) {
        int s = this._vector.size();
        byte[][] v = new byte[s][];
        int total = 0;
        for (int i = 0; i < s; ++i) {
            v[i] = ((SnmpObject)this._vector.elementAt(i)).getSnmpBytes();
            total += v[i].length;
        }
        SnmpObjectHeader head = new SnmpObjectHeader(type, total);
        int headLen = head.getCodedLength();
        byte[] out = new byte[headLen + total];
        System.arraycopy(head.getSnmpBytes(), 0, out, 0, headLen);
        int pos = headLen;
        for (int i = 0; i < s; ++i) {
            System.arraycopy(v[i], 0, out, pos, v[i].length);
            pos += v[i].length;
        }
        return out;
    }
}

