/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

class SnmpObjectHeader {
    static final int INTEGER = 2;
    static final int OCTET_STRING = 4;
    static final int NULL = 5;
    static final int OBJECT_IDENTIFIER = 6;
    static final int SEQUENCE = 48;
    static final int IpAddress = 64;
    static final int Counter = 65;
    static final int Gauge = 66;
    static final int TimeTicks = 67;
    static final int Opaque = 68;
    static final int GetRequest = 160;
    static final int GetNextRequest = 161;
    static final int GetResponse = 162;
    static final int SetRequest = 163;
    static final int Trap = 164;
    private int _length = 0;
    private int _code = 0;
    private int _codedLength = 0;
    private byte[] _byteStream = new byte[16];

    SnmpObjectHeader(byte[] b, int off, int len) throws NumberFormatException {
        this._streamToInternal(b, off, len);
    }

    SnmpObjectHeader(int code, int length) {
        this._code = code;
        this._length = length;
        byte[] b = new byte[16];
        this._internalToStream(b, 0, b.length);
        this._byteStream = new byte[this._codedLength];
        System.arraycopy(b, 0, this._byteStream, 0, this._codedLength);
    }

    public String toString() {
        return "Code=" + SnmpObjectHeader.snmpCodeToString(this._code) + ";Length=" + this._length + ";codedLength=" + this._codedLength;
    }

    int getLength() {
        return this._length;
    }

    int getType() {
        return this._code;
    }

    int getCodedLength() {
        return this._codedLength;
    }

    byte[] getSnmpBytes() {
        byte[] out = new byte[this._codedLength];
        System.arraycopy(this._byteStream, 0, out, 0, this._codedLength);
        return out;
    }

    void copySnmpBytes(byte[] b, int offIn, int len) throws NumberFormatException {
        if (this._codedLength > len) {
            throw new NumberFormatException("Not long enought");
        }
        System.arraycopy(this._byteStream, 0, b, offIn, this._codedLength);
    }

    private void _streamToInternal(byte[] b, int offIn, int len) throws NumberFormatException {
        int off = offIn;
        this._code = b[off++];
        this._code = this._code < 0 ? this._code + 256 : this._code;
        int lenCode = b[off++];
        this._length = 0;
        if (lenCode < 0) {
            lenCode += 128;
            for (int i = 0; i < lenCode; ++i) {
                int x;
                x = (x = b[off++]) < 0 ? x + 256 : x;
                this._length <<= 8;
                this._length |= x;
            }
        } else {
            this._length = lenCode;
        }
        this._codedLength = off - offIn;
        this._byteStream = new byte[this._codedLength];
        System.arraycopy(b, offIn, this._byteStream, 0, this._codedLength);
    }

    private int _internalToStream(byte[] b, int offIn, int len) throws NumberFormatException {
        int off = offIn;
        int x = this._code;
        b[off++] = (byte)(x > 127 ? x - 256 : x);
        if (this._length > 127) {
            int y;
            boolean started = false;
            int counter = 0;
            int counterPosition = off++;
            for (int i = 3; i >= 0; --i) {
                y = this._length >> i * 8 & 0xFF;
                if (!started && y == 0) continue;
                started = true;
                b[off++] = (byte)(y > 127 ? y - 256 : y);
                ++counter;
            }
            y = counter | 0x80;
            b[counterPosition] = (byte)(y > 127 ? y - 256 : y);
        } else {
            b[off++] = (byte)this._length;
        }
        this._codedLength = off - offIn;
        return this._codedLength;
    }

    public static String snmpCodeToString(int code) {
        String s;
        switch (code) {
            case 2: {
                s = "Integer";
                break;
            }
            case 4: {
                s = "OctetString";
                break;
            }
            case 5: {
                s = "Null";
                break;
            }
            case 6: {
                s = "ObjectIdentifier";
                break;
            }
            case 48: {
                s = "Sequence";
                break;
            }
            case 64: {
                s = "IpAddress";
                break;
            }
            case 65: {
                s = "Counter";
                break;
            }
            case 66: {
                s = "Gauge";
                break;
            }
            case 67: {
                s = "TimeTicks";
                break;
            }
            case 68: {
                s = "Opaque";
                break;
            }
            case 160: {
                s = "GetRequest";
                break;
            }
            case 161: {
                s = "GetNextRequest";
                break;
            }
            case 162: {
                s = "GetResponse";
                break;
            }
            case 163: {
                s = "SetRequest";
                break;
            }
            case 164: {
                s = "Trap";
                break;
            }
            default: {
                s = "Unknown";
            }
        }
        return s;
    }

    public static String _print(byte[] b, int off, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int x;
            x = (x = b[off++]) < 0 ? x + 256 : x;
            sb.append(Integer.toHexString(x) + " ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.exit(4);
        }
        byte[] b = new byte[args.length];
        for (int i = 0; i < args.length; ++i) {
            int x = Integer.valueOf(args[i], 16);
            x = (x &= 0xFF) > 127 ? x - 256 : x;
            b[i] = (byte)(x > 127 ? x - 256 : x);
        }
        String output = SnmpObjectHeader._print(b, 0, b.length);
        System.out.println(output);
        SnmpObjectHeader header = new SnmpObjectHeader(b, 0, b.length);
        System.out.println("SnnpObjectHeader : " + header);
        SnmpObjectHeader header2 = new SnmpObjectHeader(header.getType(), header.getLength());
        System.out.println("SnnpObjectHeader : " + header2);
        b = header2.getSnmpBytes();
        output = SnmpObjectHeader._print(b, 0, b.length);
        System.out.println(output);
    }
}

