/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ber;

import dmg.protocols.ber.BerBitString;
import dmg.protocols.ber.BerContainer;
import dmg.protocols.ber.BerFrame;
import dmg.protocols.ber.BerGeneralString;
import dmg.protocols.ber.BerInteger;
import dmg.protocols.ber.BerObjectIdentifier;
import dmg.protocols.ber.BerOctectString;
import dmg.protocols.ber.BerTokenId;
import dmg.protocols.ber.KerberosTime;
import dmg.protocols.kerberos.Base64;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;

public class BerObject
implements Serializable {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 1;
    public static final int CONTEXT = 2;
    public static final int PRIVATE = 3;
    private static String[] __classes = new String[]{"U", "A", "C", "P"};
    private int _klass = 0;
    private boolean _primitive = true;
    private int _tag = 0;
    private int _type = 0;
    private byte[] _data = null;

    public BerObject(int berClass, boolean isPrimitive, int tag, byte[] data, int offset, int size) {
        this(berClass, isPrimitive, tag);
        this._data = new byte[size];
        System.arraycopy(data, offset, this._data, 0, size);
    }

    public BerObject(int berClass, boolean isPrimitive, int tag) {
        this._klass = berClass;
        this._primitive = isPrimitive;
        this._tag = tag;
        this._type = this._klass << 6 | this._tag | (this._primitive ? 0 : 32);
    }

    public byte[] getEncodedData(byte[] data) {
        byte[] type = this.getEncodedType();
        byte[] len = BerObject.getEncodedLength(data.length);
        byte[] result = new byte[data.length + type.length + len.length];
        int p = 0;
        System.arraycopy(type, 0, result, p, type.length);
        System.arraycopy(len, 0, result, p += type.length, len.length);
        System.arraycopy(data, 0, result, p += len.length, data.length);
        return result;
    }

    public static void displayHex(byte[] data) {
        Base64.displayHex(data);
    }

    public static byte[] getEncodedLength(int len) {
        byte[] x = null;
        if (len < 128) {
            x = new byte[]{(byte)len};
        } else {
            x = new byte[3];
            int tmp = 130;
            tmp = tmp > 128 ? tmp - 256 : tmp;
            x[0] = (byte)tmp;
            tmp = len & 0xFF;
            tmp = tmp > 128 ? tmp - 256 : tmp;
            x[2] = (byte)tmp;
            tmp = len >>> 8 & 0xFF;
            tmp = tmp > 128 ? tmp - 256 : tmp;
            x[1] = (byte)tmp;
        }
        return x;
    }

    public byte[] getEncodedType() {
        byte[] x = new byte[]{(byte)(this._type > 128 ? this._type - 256 : this._type)};
        return x;
    }

    public boolean isPrimitive() {
        return this._primitive;
    }

    public int getTag() {
        return this._tag;
    }

    public int getBerClass() {
        return this._klass;
    }

    public int getType() {
        return this._type;
    }

    public byte[] getData() {
        return this._data;
    }

    public byte[] getEncodedData() {
        if (this._data == null) {
            throw new IllegalArgumentException("BerObject.getEncodedData now overwritten");
        }
        return this.getEncodedData(this._data);
    }

    public static BerFrame decode(byte[] data, int off, int maxSize) {
        int type = data[off++];
        int meta = 0;
        type = type < 0 ? type + 256 : type;
        int klass = type >> 6 & 3;
        boolean isPrimitive = (type >> 5 & 1) == 0;
        int tag = type & 0x1F;
        ++meta;
        int highSize = data[off++];
        ++meta;
        highSize = highSize < 0 ? highSize + 256 : highSize;
        int size = 0;
        if ((highSize & 0x80) != 0) {
            int octects = highSize & 0x7F;
            for (int i = 0; i < octects; ++i) {
                int d = data[off++];
                ++meta;
                d = d < 0 ? d + 256 : d;
                size <<= 8;
                size += d;
            }
        } else {
            size = highSize & 0x7F;
        }
        BerObject ber = null;
        ber = isPrimitive ? (tag == 27 ? new BerGeneralString(data, off, size) : (tag == 1 ? new BerTokenId(1) : (tag == 2 ? new BerInteger(data, off, size) : (tag == 3 ? new BerBitString(data, off, size) : (tag == 4 ? new BerOctectString(data, off, size) : (tag == 6 ? new BerObjectIdentifier(data, off, size) : (tag == 24 ? new KerberosTime(data, off, size) : new BerObject(klass, isPrimitive, tag, data, off, size)))))))) : new BerContainer(klass, tag, data, off, size);
        return new BerFrame(ber, meta, size);
    }

    public String getTypeCode() {
        String s = Integer.toHexString(this._type);
        return s.length() == 1 ? "0" + s : s;
    }

    public String getTypeString() {
        return "T" + this.getTypeCode() + "-(" + __classes[this._klass] + (this._primitive ? "P" : "C") + this._tag + ")";
    }

    public static void scanBER(byte[] data) {
        BerObject.scanBER(new PrintWriter(new OutputStreamWriter(System.out)), 0, data, 0);
    }

    public void printNice() {
        this.printNice(0);
    }

    public void printNice(int level) {
        for (int i = 0; i < level * 3; ++i) {
            System.out.print(" ");
        }
        System.out.print(this.getTypeString() + " ");
        System.out.println(this.toString());
    }

    public String toString() {
        if (this._data == null) {
            return " (noInfo) ";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._data.length; ++i) {
            sb.append(Base64.byteToHex(this._data[i])).append(" ");
        }
        return sb.toString();
    }

    public static int scanBER(PrintWriter pw, int level, byte[] data, int off) {
        int i;
        int type = data[off++];
        int meta = 0;
        type = type < 0 ? type + 256 : type;
        int klass = type >> 6 & 3;
        boolean isPrimitive = (type >> 5 & 1) == 0;
        int tag = type & 0x1F;
        ++meta;
        int highSize = data[off++];
        ++meta;
        highSize = highSize < 0 ? highSize + 256 : highSize;
        int size = 0;
        if ((highSize & 0x80) != 0) {
            int octects = highSize & 0x7F;
            for (i = 0; i < octects; ++i) {
                int d = data[off++];
                ++meta;
                d = d < 0 ? d + 256 : d;
                size <<= 8;
                size += d;
            }
        } else {
            size = highSize & 0x7F;
        }
        String mode = "Class(" + Integer.toHexString(type) + ")=" + __classes[klass] + ";" + (isPrimitive ? "P" : "C") + ";" + "T=" + tag;
        for (i = 0; i < level * 3; ++i) {
            System.out.print(" ");
        }
        System.out.print("" + off + ":" + mode);
        System.out.print(";size=" + size);
        if (isPrimitive) {
            System.out.print(" : ");
            if (tag == 27) {
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < size; ++i2) {
                    sb.append((char)data[off + i2]);
                }
                System.out.print(sb.toString());
            } else if (tag == 2) {
                long l = 0L;
                for (int i3 = 0; i3 < size; ++i3) {
                    l <<= 8;
                    int b = data[off + i3];
                    l += (long)(b < 0 ? b + 256 : b);
                }
                System.out.print(" Integer=" + l);
            } else if (tag == 2) {
                System.out.print(" BitString= ");
                for (i = 0; i < size; ++i) {
                    System.out.print(Base64.byteToHex(data[off + i]) + " ");
                }
            } else if (tag == 6) {
                int a = data[off];
                a = a < 0 ? a + 256 : a;
                int x = a / 40;
                int y = a % 40;
                System.out.print(" OID=" + x + "." + y + ".");
                long l = 0L;
                for (int i4 = 1; i4 < size; ++i4) {
                    a = data[off + i4];
                    a = a < 0 ? a + 256 : a;
                    l <<= 7;
                    l += (long)(a & 0x7F);
                    if ((a & 0x80) != 0) continue;
                    System.out.print("" + l + ".");
                    l = 0L;
                }
            } else {
                for (i = 0; i < size; ++i) {
                    System.out.print(Base64.byteToHex(data[off + i]) + " ");
                }
            }
            System.out.println("");
        } else {
            int c;
            System.out.println("");
            for (int sum = 0; sum < size; sum += c) {
                c = BerObject.scanBER(pw, level + 1, data, off + sum);
            }
        }
        return size + meta;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage : ... <b0> <b1> ...");
            System.exit(4);
        }
        byte[] data = new byte[args.length];
        for (int i = 0; i < data.length; ++i) {
            int n = Integer.parseInt(args[i], 16);
            data[i] = (byte)(n > 128 ? n - 256 : n);
        }
        BerObject.decode(data, 0, data.length).getObject().printNice();
        System.exit(0);
    }
}

