/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ber;

import dmg.protocols.ber.BerObject;

public class BerBitString
extends BerObject {
    private byte[] _d = this.getData();

    public BerBitString(byte[] data, int off, int size) {
        super(0, true, 2, data, off, size);
    }

    public boolean isSet(int p) {
        if (p >= 8 * this._d.length) {
            throw new IllegalArgumentException("Not in range");
        }
        int value = this._d[p / 8];
        value = value < 0 ? 256 + value : value;
        int mask = 1 << p % 8;
        return (value & mask) > 0;
    }

    public int getBits() {
        return 8 * this._d.length;
    }

    @Override
    public String getTypeString() {
        return super.getTypeString() + " BitString";
    }

    @Override
    public byte[] getEncodedData() {
        return this.getEncodedData(this._d);
    }

    public static void main(String[] args) {
        byte[] a = new byte[]{1, 2, 3, 4};
        BerBitString ber = new BerBitString(a, 0, a.length);
        ber.printNice();
        byte[] r = ((BerObject)ber).getEncodedData();
        BerObject.displayHex(r);
    }
}

