/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.multicaster;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.multicaster.BroadcastCommandMessage;
import dmg.cells.services.multicaster.BroadcastEventCommandMessage;
import dmg.cells.services.multicaster.BroadcastRegisterMessage;
import dmg.cells.services.multicaster.BroadcastUnregisterMessage;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(BroadcastCell.class);
    private CellNucleus _nucleus = null;
    private Args _args = null;
    private HashMap _eventClassMap = new HashMap();
    private HashMap _destinationMap = new HashMap();
    private boolean _debug = false;
    private String _debugMode = null;
    private long _received = 0L;
    private long _forwarded = 0L;
    private long _sent = 0L;
    private Debugging _debugging = new Debugging();
    public String hh_ls = "";
    public String hh_register = "<classEvent> <cellPath> [-send] [-expires=<seconds>] [-cancelonfailure=[on|off]]";
    public String hh_modify = "<classEvent> <cellPath> [-expires=<seconds>] [-cancelonfailure=[on|off]]";
    public String hh_unregister = "<classEvent> <cellPath> [-send]";
    public String hh_send = "[<class>]";
    public String hh_d_reg = "<eventClass> [<destination>] [-cancelonfailure] [-expires=<time>]";
    public String hh_d_unreg = "<eventClass> [<destination>]";
    public String hh_d_send = "<javaClass> [-destination=<cellName>] [-wait]";

    public BroadcastCell(String name, String args) {
        super(name, args, false);
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        this._debugMode = this._args.getOpt("debug");
        if (this._debugMode != null) {
            this._debug = true;
            this.addCommandListener(this._debugging);
        }
        this.export();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_ls(Args args) {
        BroadcastCell broadcastCell = this;
        synchronized (broadcastCell) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : this._eventClassMap.entrySet()) {
                String key = (String)entry.getKey();
                sb.append(key).append("\n");
                Map map = (Map)entry.getValue();
                for (Map.Entry me : map.entrySet()) {
                    CellAddressCore path = (CellAddressCore)me.getKey();
                    Entry e = (Entry)me.getValue();
                    sb.append("   ").append(path.toString()).append("   ").append(e.toString()).append("\n");
                }
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_register_$_2(Args args) throws Exception {
        try {
            OptionClass options = new OptionClass(args);
            BroadcastCell broadcastCell = this;
            synchronized (broadcastCell) {
                Entry entry = this.register(new CellPath(options.destination), options.eventClass);
                entry.setCancelOnFailure(options.failures);
                if (options.expires > 0L) {
                    entry.setExpires(options.expires);
                }
            }
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            throw ee;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_modify_$_2(Args args) {
        OptionClass options = new OptionClass(args);
        Entry entry = null;
        BroadcastCell broadcastCell = this;
        synchronized (broadcastCell) {
            entry = this.get(new CellPath(options.destination), options.eventClass);
            if (entry == null) {
                throw new IllegalArgumentException("Entry not found");
            }
            entry.setCancelOnFailure(options.failures);
            if (options.expires > 0L) {
                entry.setExpires(options.expires);
            }
        }
        return entry.toString();
    }

    public String ac_unregister_$_2(Args args) throws Exception {
        OptionClass options = new OptionClass(args);
        Entry e = this.unregister(new CellPath(options.destination), options.eventClass);
        return "";
    }

    private synchronized Entry get(CellPath destination, String eventClass) {
        CellAddressCore core = destination.getDestinationAddress();
        Map map = (Map)this._eventClassMap.get(eventClass);
        if (map == null) {
            return null;
        }
        return (Entry)map.get(core);
    }

    private synchronized Entry register(CellPath destination, String eventClass) {
        CellAddressCore core = destination.getDestinationAddress();
        Entry e = new Entry(destination, eventClass);
        Map<String, Entry> map = (HashMap<CellAddressCore, Entry>)this._eventClassMap.get(eventClass);
        if (map == null) {
            map = new HashMap<CellAddressCore, Entry>();
            this._eventClassMap.put(eventClass, map);
        } else if (map.get(core) != null) {
            throw new IllegalArgumentException("Duplicated entry : " + e);
        }
        map.put((String)((Object)core), e);
        map = (Map)this._destinationMap.get(core);
        if (map == null) {
            map = new HashMap();
            this._destinationMap.put(core, map);
        }
        map.put(eventClass, e);
        return e;
    }

    private synchronized Entry unregister(CellPath destination, String eventClass) {
        CellAddressCore core = destination.getDestinationAddress();
        Map map = (Map)this._eventClassMap.get(eventClass);
        if (map == null) {
            throw new NoSuchElementException("Not an entry " + core + "/" + eventClass);
        }
        Entry e = (Entry)map.remove(core);
        if (e == null) {
            throw new NoSuchElementException("Not an entry " + core + "/" + eventClass);
        }
        if (map.size() == 0) {
            this._eventClassMap.remove(eventClass);
        }
        if ((map = (Map)this._destinationMap.get(core)) == null) {
            throw new NoSuchElementException("PANIC : inconsitent db : " + core + "/" + eventClass);
        }
        e = (Entry)map.remove(eventClass);
        if (map.size() == 0) {
            this._destinationMap.remove(core);
        }
        return e;
    }

    public String ac_send_$_0_1(Args args) throws Exception {
        ArrayList<Object> obj = null;
        if (args.argc() == 0) {
            obj = new ArrayList();
        } else {
            Class<?> c = Class.forName(args.argv(0));
            obj = c.newInstance();
        }
        CellMessage msg = new CellMessage(new CellPath("broadcast"), obj);
        this.sendMessage(msg);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBroadcastCommandMessage(CellMessage msg, BroadcastCommandMessage command) {
        block14: {
            if (!(command instanceof BroadcastEventCommandMessage)) {
                return;
            }
            BroadcastEventCommandMessage event = (BroadcastEventCommandMessage)command;
            try {
                String eventClass = event.getEventClass();
                CellPath target = event.getTarget();
                if (target == null) {
                    target = (CellPath)msg.getSourcePath().clone();
                    target.revert();
                }
                if (event instanceof BroadcastRegisterMessage) {
                    BroadcastRegisterMessage reg = (BroadcastRegisterMessage)event;
                    _log.info("Message register : " + reg);
                    BroadcastCell broadcastCell = this;
                    synchronized (broadcastCell) {
                        long expires;
                        Entry entry = this.get(target, eventClass);
                        if (entry == null) {
                            entry = this.register(target, eventClass);
                        }
                        if (reg.isCancelOnFailure()) {
                            entry.setCancelOnFailure(true);
                        }
                        if ((expires = reg.getExpires()) > 0L) {
                            entry.setExpires(expires);
                        }
                        break block14;
                    }
                }
                if (event instanceof BroadcastUnregisterMessage) {
                    BroadcastUnregisterMessage unreg = (BroadcastUnregisterMessage)event;
                    _log.info("Message unregister : " + unreg);
                    this.unregister(target, eventClass);
                    break block14;
                }
                throw new IllegalArgumentException("Not a valid Broadcast command " + event.getClass());
            }
            catch (Exception ee) {
                _log.warn("Problem with {" + command + "}" + ee, (Throwable)ee);
                event.setReturnValues(1, ee);
            }
        }
        msg.revertDirection();
        try {
            this.sendMessage(msg);
        }
        catch (Exception ee) {
            _log.warn("Couldn't reply : " + ee);
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("        CellName : " + this.getCellName());
        pw.println("       CellClass : " + this.getClass().getName());
        pw.println("         Version : $Id: BroadcastCell.java,v 1.8 2006-12-15 11:09:37 tigran Exp $");
        pw.println("     Destinations : " + this._destinationMap.size());
        pw.println("    Event Classes : " + this._eventClassMap.size());
        pw.println(" Packets received : " + this._received);
        pw.println("     Packets sent : " + this._sent);
        pw.println("Packets forwarded : " + this._forwarded);
    }

    @Override
    public void messageArrived(CellMessage message) {
        _log.info("messageArrived : " + message);
        ++this._received;
        if (this._debug) {
            this._debugging.messageArrived(message);
            return;
        }
        Object obj = message.getMessageObject();
        if (obj instanceof BroadcastCommandMessage) {
            this.handleBroadcastCommandMessage(message, (BroadcastCommandMessage)obj);
            return;
        }
        if (obj instanceof NoRouteToCellException) {
            NoRouteToCellException nrtc = (NoRouteToCellException)obj;
            this.handleNoRouteException(nrtc);
            return;
        }
        ArrayList<String> classList = new ArrayList<String>();
        for (Class<?> o = obj.getClass(); o != null; o = o.getSuperclass()) {
            classList.add(o.getName());
            Class<?>[] il = o.getInterfaces();
            for (int i = 0; i < il.length; ++i) {
                classList.add(il[i].getName());
            }
        }
        _log.info("Message arrived " + obj.getClass().getName());
        Iterator i = classList.iterator();
        while (i.hasNext()) {
            String eventClass = i.next().toString();
            this.forwardMessage(message, eventClass);
        }
    }

    @Override
    public void messageToForward(CellMessage message) {
        _log.info("FORWARD: " + message);
        ++this._forwarded;
        Object obj = message.getMessageObject();
        if (obj != null && obj instanceof NoRouteToCellException) {
            NoRouteToCellException nrtc = (NoRouteToCellException)obj;
            this.handleNoRouteException(nrtc);
            return;
        }
        super.messageToForward(message);
    }

    private synchronized void forwardMessage(CellMessage message, String classEvent) {
        Map map = (Map)this._eventClassMap.get(classEvent);
        if (map == null) {
            return;
        }
        ArrayList<Entry> list = new ArrayList<Entry>();
        CellPath dest = message.getDestinationPath();
        for (Map.Entry mapentry : map.entrySet()) {
            CellPath origin = (CellPath)dest.clone();
            Entry entry = (Entry)mapentry.getValue();
            if (!entry.isValid()) {
                list.add(entry);
                continue;
            }
            entry._used++;
            origin.add(entry.getPath());
            origin.next();
            CellMessage msg = new CellMessage(origin, message.getMessageObject());
            msg.setUOID(message.getUOID());
            msg.getSourcePath().add(message.getSourcePath());
            try {
                _log.info("forwardMessage : " + classEvent + " forwarding to " + origin);
                this.sendMessage(msg);
                ++this._sent;
            }
            catch (Exception ee) {
                _log.warn("forwardMessage : FAILED " + classEvent + " forwarding to " + origin + " " + ee);
                if (entry.isCancelOnFailure()) {
                    list.add(entry);
                }
                entry._failed++;
            }
        }
        this.unregister(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNoRouteException(NoRouteToCellException nrtc) {
        CellPath destination = nrtc.getDestinationPath();
        _log.warn("NoRouteToCell : " + nrtc);
        ArrayList<Entry> list = new ArrayList<Entry>();
        BroadcastCell broadcastCell = this;
        synchronized (broadcastCell) {
            Map map = (Map)this._destinationMap.get(destination.getDestinationAddress());
            if (map == null) {
                _log.warn("Exception path not found in map : " + destination);
                return;
            }
            for (Entry e : map.values()) {
                if (!e.isCancelOnFailure()) continue;
                _log.info("Scheduling for cancelation : " + e);
                list.add(e);
            }
            this.unregister(list);
        }
    }

    private void unregister(List list) {
        for (Entry e : list) {
            try {
                this.unregister(e.getPath(), e.getTrigger());
            }
            catch (NoSuchElementException nse) {
                _log.warn("PANIC : Couldn't unregister " + e);
            }
        }
    }

    public String ac_d_reg_$_1_2(Args args) throws Exception {
        OptionClass options = new OptionClass(args);
        CellPath path = options.destination == null ? null : new CellPath(options.destination);
        BroadcastRegisterMessage cmd = new BroadcastRegisterMessage(options.eventClass, path);
        cmd.setCancelOnFailure(options.failures);
        cmd.setExpires(options.expires);
        CellMessage msg = new CellMessage(new CellPath("broadcast"), cmd);
        this.sendMessage(msg);
        return "";
    }

    public String ac_d_unreg_$_1_2(Args args) throws Exception {
        OptionClass options = new OptionClass(args);
        CellPath path = options.destination == null ? null : new CellPath(options.destination);
        BroadcastUnregisterMessage cmd = new BroadcastUnregisterMessage(options.eventClass, path);
        CellMessage msg = new CellMessage(new CellPath("broadcast"), cmd);
        this.sendMessage(msg);
        return "";
    }

    public String ac_d_send_$_0_1(Args args) throws Exception {
        ArrayList obj = args.argc() == 0 ? new ArrayList() : Class.forName(args.argv(0)).newInstance();
        String dest = args.getOpt("destination");
        CellMessage msg = new CellMessage(new CellPath(dest == null ? "broadcast" : dest), obj);
        this.sendMessage(msg);
        return "";
    }

    private class Debugging {
        private Debugging() {
        }

        private void messageArrived(CellMessage message) {
            Object obj = message.getMessageObject();
            if (BroadcastCell.this._debugMode.equals("source")) {
                _log.info("MessageObject : " + obj);
            } else if (BroadcastCell.this._debugMode.equals("destination")) {
                if (obj instanceof BroadcastCommandMessage) {
                    _log.info("Broadcast Message answer : " + obj);
                    return;
                }
                _log.info("Replying MessageObject : " + obj);
                message.revertDirection();
                try {
                    BroadcastCell.this.sendMessage(message);
                }
                catch (Exception ee) {
                    _log.warn("Problems sending : " + message + "(" + ee + ")");
                }
            }
        }
    }

    private class OptionClass {
        private long expires = -1L;
        private boolean failures = false;
        private String eventClass = null;
        private String destination = null;

        private OptionClass(Args args) {
            this.eventClass = args.argv(0);
            this.destination = args.argc() > 1 ? args.argv(1) : null;
            String tmp = args.getOpt("expires");
            if (tmp != null) {
                this.expires = Long.parseLong(tmp) * 1000L + System.currentTimeMillis();
            }
            if ((tmp = args.getOpt("cancelonfailure")) != null) {
                if (tmp.equals("")) {
                    this.failures = true;
                } else if (tmp.equals("on")) {
                    this.failures = true;
                } else if (tmp.equals("off")) {
                    this.failures = false;
                } else {
                    throw new IllegalArgumentException("-cancelonfailure=[on|off]");
                }
            }
        }
    }

    private class Entry {
        private static final int STATIC = 1;
        private static final int CANCEL_ON_FAILURE = 2;
        private static final int EXPIRES = 4;
        private CellPath _destination = null;
        private String _trigger = null;
        private int _mode = 1;
        private long _created = System.currentTimeMillis();
        private long _expires = 0L;
        private long _used = 0L;
        private long _failed = 0L;

        private Entry(CellPath destination, String trigger) {
            this._destination = destination;
            this._trigger = trigger;
        }

        private void setCancelOnFailure(boolean cancel) {
            if (cancel) {
                this._mode |= 2;
                this._mode &= 0xFFFFFFFE;
            } else {
                this._mode &= 0xFFFFFFFD;
                if ((this._mode & 4) == 0) {
                    this._mode |= 1;
                }
            }
        }

        private void setExpires(long expires) {
            if (expires <= 0L) {
                this._expires = 0L;
                this._mode &= 0xFFFFFFFB;
                if ((this._mode & 2) == 0) {
                    this._mode |= 1;
                }
            } else {
                this._expires = expires;
                this._mode |= 4;
                this._mode &= 0xFFFFFFFE;
            }
        }

        private String getTrigger() {
            return this._trigger;
        }

        private CellPath getPath() {
            return this._destination;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[").append(this._trigger).append(";").append(this._destination.toString());
            sb.append(";(" + this._used + "," + this._failed + ")");
            sb.append(";mode=");
            sb.append(this.isValid() ? "V" : "X");
            if ((this._mode & 1) != 0) {
                sb.append("S");
            }
            if ((this._mode & 2) != 0) {
                sb.append("C");
            }
            if ((this._mode & 4) != 0) {
                long rest = this._expires - System.currentTimeMillis();
                rest = rest <= 0L ? 0L : rest / 1000L;
                sb.append("E;ex=").append(rest);
            } else {
                sb.append(";");
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean isValid() {
            if ((this._mode & 1) != 0) {
                return true;
            }
            return (this._mode & 4) == 0 || this._expires >= System.currentTimeMillis();
        }

        public boolean isCancelOnFailure() {
            return (this._mode & 2) != 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return other._destination.equals(this._destination) && other._trigger.equals(this._trigger);
        }

        public int hashCode() {
            return (this._destination.toString() + this._trigger).hashCode();
        }
    }
}

