/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.DatabaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserRelationDb {
    private File _dbDir = null;
    private Hashtable<String, ElementItem> _elements = null;

    public UserRelationDb(File dbDir) throws DatabaseException {
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            throw new DatabaseException(11, "Not a directory : " + dbDir);
        }
        this._dbDir = dbDir;
        this._loadElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> loadAcl(File aclFile) {
        Hashtable<String, Boolean> acl = new Hashtable<String, Boolean>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(aclFile));
            String line = null;
            StringTokenizer st = null;
            String name = null;
            String value = null;
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, "=");
                try {
                    name = st.nextToken();
                    value = st.nextToken();
                    acl.put(name, value.equals("allowed"));
                }
                catch (Exception ee) {}
            }
        }
        catch (IOException ie) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ee) {}
            }
        }
        return acl;
    }

    public void display() {
        Enumeration<String> all = this._elements.keys();
        while (all.hasMoreElements()) {
            String name = all.nextElement();
            ElementItem item = this._elements.get(name);
            System.out.println(name);
            Enumeration e = item.parents();
            while (e.hasMoreElements()) {
                System.out.println("   p:" + (String)e.nextElement());
            }
            e = item.children();
            while (e.hasMoreElements()) {
                System.out.println("   c:" + (String)e.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadElements() throws DatabaseException {
        String[] elements = this._dbDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        Hashtable<String, ElementItem> hash = new Hashtable<String, ElementItem>();
        for (int i = 0; i < elements.length; ++i) {
            File file = new File(this._dbDir, elements[i]);
            BufferedReader br = null;
            ElementItem item = null;
            ElementItem x = null;
            item = (ElementItem)hash.get(elements[i]);
            if (item == null) {
                item = new ElementItem();
                hash.put(elements[i], item);
            }
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    String name = line.trim();
                    if (name.length() == 0 || name.charAt(0) == '#') continue;
                    item.addChild(name);
                    x = (ElementItem)hash.get(name);
                    if (x == null) {
                        x = new ElementItem();
                        hash.put(name, x);
                    }
                    x.addParent(elements[i]);
                }
                continue;
            }
            catch (IOException ie) {
                continue;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ee) {}
                }
            }
        }
        this._elements = hash;
    }

    public boolean check(String user, Map<String, Boolean> acl) {
        Boolean ok = null;
        ok = acl.get(user);
        if (ok != null) {
            return ok;
        }
        Vector<String> v = new Vector<String>();
        String p = null;
        ElementItem item = null;
        Boolean x = null;
        v.addElement(user);
        for (int i = 0; i < v.size(); ++i) {
            p = (String)v.elementAt(i);
            x = acl.get(p);
            if (x != null) {
                if (!x.booleanValue()) continue;
                return true;
            }
            item = this._elements.get(p);
            if (item == null) continue;
            Enumeration e = item.parents();
            while (e.hasMoreElements()) {
                v.addElement((String)e.nextElement());
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : ... <dbDirectory> [<acl> <user>]");
            System.exit(4);
        }
        File dbDir = new File(args[0]);
        UserRelationDb db = new UserRelationDb(dbDir);
        if (args.length < 3) {
            db.display();
        } else {
            File aclFile = new File(args[1]);
            String user = args[2];
            Map<String, Boolean> acl = UserRelationDb.loadAcl(aclFile);
            boolean rc = db.check(user, acl);
            System.out.println("user=" + user + ";acl=" + aclFile + ";allowed=" + rc);
        }
    }

    private class ElementItem {
        private Hashtable<String, String> _parents = null;
        private Hashtable<String, String> _childs = null;

        private ElementItem() {
        }

        private void addParent(String parent) {
            if (this._parents == null) {
                this._parents = new Hashtable();
            }
            this._parents.put(parent, parent);
        }

        private void addChild(String child) {
            if (this._childs == null) {
                this._childs = new Hashtable();
            }
            this._childs.put(child, child);
        }

        private Enumeration<String> parents() {
            return this._parents == null ? new DEnumeration() : this._parents.keys();
        }

        private Enumeration<String> children() {
            return this._childs == null ? new DEnumeration() : this._childs.keys();
        }
    }

    private class DEnumeration<T>
    implements Enumeration<T> {
        private DEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            return null;
        }
    }
}

