/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.DatabaseException;
import dmg.cells.services.login.user.TopDownUserRelationable;
import dmg.cells.services.login.user.UserRelationable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class InMemoryUserRelation
implements UserRelationable {
    private TopDownUserRelationable _db = null;
    private Hashtable _elements = null;

    public InMemoryUserRelation(TopDownUserRelationable db) throws DatabaseException {
        this._db = db;
        this._loadElements();
    }

    @Override
    public synchronized Enumeration getContainers() {
        return new Enumeration(){
            private Enumeration _ee = null;
            {
                Enumeration xx = InMemoryUserRelation.this._elements.keys();
                Vector<String> v = new Vector<String>();
                while (xx.hasMoreElements()) {
                    String name = (String)xx.nextElement();
                    ElementItem ee = (ElementItem)InMemoryUserRelation.this._elements.get(name);
                    if (ee == null || !ee.hasChildren()) continue;
                    v.addElement(name);
                }
                this._ee = v.elements();
            }

            @Override
            public boolean hasMoreElements() {
                return this._ee.hasMoreElements();
            }

            public Object nextElement() {
                return this._ee.nextElement();
            }
        };
    }

    @Override
    public synchronized Enumeration getParentsOf(String element) throws NoSuchElementException {
        ElementItem item = (ElementItem)this._elements.get(element);
        if (item == null) {
            throw new NoSuchElementException(element);
        }
        return item.parents();
    }

    @Override
    public boolean isParentOf(String element, String container) throws NoSuchElementException {
        ElementItem item = (ElementItem)this._elements.get(element);
        if (item == null) {
            throw new NoSuchElementException(element);
        }
        return item.isParent(container);
    }

    @Override
    public void createContainer(String container) throws DatabaseException {
        this._db.createContainer(container);
        this._elements.put(container, new ElementItem());
    }

    @Override
    public Enumeration getElementsOf(String container) throws NoSuchElementException {
        ElementItem item = (ElementItem)this._elements.get(container);
        if (item == null) {
            throw new NoSuchElementException(container);
        }
        return item.children();
    }

    @Override
    public boolean isElementOf(String container, String element) throws NoSuchElementException {
        ElementItem item = (ElementItem)this._elements.get(container);
        if (item == null) {
            throw new NoSuchElementException(container);
        }
        return item.isChild(element);
    }

    @Override
    public void addElement(String container, String element) throws NoSuchElementException {
        this._db.addElement(container, element);
        ElementItem item = (ElementItem)this._elements.get(container);
        if (item == null) {
            throw new NoSuchElementException(container);
        }
        item.addChild(element);
        item = (ElementItem)this._elements.get(element);
        if (item == null) {
            item = new ElementItem();
            this._elements.put(element, item);
        }
        item.addParent(container);
    }

    @Override
    public void removeElement(String container, String element) throws NoSuchElementException {
        this._db.removeElement(container, element);
        ElementItem item = (ElementItem)this._elements.get(container);
        if (item == null) {
            throw new NoSuchElementException(container);
        }
        item.removeChild(element);
        item = (ElementItem)this._elements.get(element);
        if (item == null) {
            return;
        }
        item.removeParent(container);
    }

    @Override
    public void removeContainer(String container) throws NoSuchElementException, DatabaseException {
        this._db.removeContainer(container);
        this._elements.remove(container);
    }

    private void _loadElements() throws DatabaseException {
        Hashtable<String, ElementItem> hash = new Hashtable<String, ElementItem>();
        Enumeration e = this._db.getContainers();
        while (e.hasMoreElements()) {
            String container = (String)e.nextElement();
            ElementItem item = null;
            ElementItem x = null;
            item = (ElementItem)hash.get(container);
            if (item == null) {
                item = new ElementItem();
                hash.put(container, item);
            }
            try {
                Enumeration f = this._db.getElementsOf(container);
                while (f.hasMoreElements()) {
                    String name = (String)f.nextElement();
                    item.addChild(name);
                    x = (ElementItem)hash.get(name);
                    if (x == null) {
                        x = new ElementItem();
                        hash.put(name, x);
                    }
                    x.addParent(container);
                }
            }
            catch (Exception ie) {
            }
        }
        this._elements = hash;
    }

    private class ElementItem {
        private Hashtable _parents = null;
        private Hashtable _childs = null;

        private ElementItem() {
        }

        private void addParent(String parent) {
            if (this._parents == null) {
                this._parents = new Hashtable();
            }
            this._parents.put(parent, parent);
        }

        private void addChild(String child) {
            if (this._childs == null) {
                this._childs = new Hashtable();
            }
            this._childs.put(child, child);
        }

        private Enumeration parents() {
            return this._parents == null ? new DEnumeration() : this._parents.keys();
        }

        private Enumeration children() {
            return this._childs == null ? new DEnumeration() : this._childs.keys();
        }

        private boolean hasChildren() {
            return this._childs != null && this._childs.size() > 0;
        }

        private boolean isParent(String parent) {
            return this._parents != null && this._parents.get(parent) != null;
        }

        private boolean isChild(String child) {
            return this._childs != null && this._childs.get(child) != null;
        }

        private void removeChild(String child) {
            if (this._childs == null) {
                return;
            }
            this._childs.remove(child);
        }

        private void removeParent(String parent) {
            if (this._parents == null) {
                return;
            }
            this._parents.remove(parent);
        }
    }

    private class DEnumeration
    implements Enumeration {
        private DEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

