/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.DatabaseException;
import dmg.cells.services.login.user.TopDownUserRelationable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class FileUserRelation
implements TopDownUserRelationable {
    private File _dbDir = null;

    public FileUserRelation(File dbDir) {
        if (!dbDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory : " + dbDir);
        }
        this._dbDir = dbDir;
    }

    @Override
    public synchronized void createContainer(String container) throws DatabaseException {
        File c = new File(this._dbDir, container);
        if (c.exists()) {
            throw new DatabaseException(3, "Container exists " + c);
        }
        try {
            new FileOutputStream(c).close();
        }
        catch (IOException ee) {
            throw new DatabaseException(4, "Creation denied : " + ee.getMessage());
        }
    }

    @Override
    public void removeContainer(String container) throws NoSuchElementException, DatabaseException {
        File c = new File(this._dbDir, container);
        if (!c.exists()) {
            throw new NoSuchElementException(container);
        }
        Hashtable hash = this.loadFile(c);
        if (hash.size() > 0) {
            throw new DatabaseException(5, "Not empty");
        }
        c.delete();
    }

    @Override
    public Enumeration getContainers() {
        return new ListEnumeration(this._dbDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        }));
    }

    @Override
    public synchronized Enumeration getElementsOf(String container) throws NoSuchElementException {
        return this.loadFile(new File(this._dbDir, container)).keys();
    }

    @Override
    public synchronized boolean isElementOf(String container, String element) throws NoSuchElementException {
        return this.loadFile(new File(this._dbDir, container)).get(element) != null;
    }

    @Override
    public synchronized void addElement(String container, String element) throws NoSuchElementException {
        File c = new File(this._dbDir, container);
        Hashtable hash = this.loadFile(c);
        if (hash.get(element) != null) {
            return;
        }
        hash.put(element, element);
        this.storeFile(c, hash);
    }

    @Override
    public synchronized void removeElement(String container, String element) throws NoSuchElementException {
        File c = new File(this._dbDir, container);
        Hashtable hash = this.loadFile(c);
        if (hash.remove(element) == null) {
            return;
        }
        this.storeFile(c, hash);
    }

    private void storeFile(File file, Hashtable hash) throws NoSuchElementException {
        PrintWriter pw = null;
        File tmpFile = new File(file.getParent(), "." + file.getName());
        try {
            pw = new PrintWriter(new FileWriter(tmpFile));
        }
        catch (IOException e) {
            throw new NoSuchElementException("Open error on " + file);
        }
        Enumeration e = hash.keys();
        while (e.hasMoreElements()) {
            pw.println(e.nextElement().toString());
        }
        pw.close();
        tmpFile.renameTo(file);
    }

    private Hashtable loadFile(File file) throws NoSuchElementException {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            throw new NoSuchElementException("No found " + file);
        }
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                String name = line.trim();
                hash.put(name, name);
            }
        }
        catch (IOException ioe) {
            throw new NoSuchElementException("IOError on " + file);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        return hash;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : ... <dbDir>");
            System.exit(4);
        }
        FileUserRelation db = new FileUserRelation(new File(args[0]));
        try {
            if (args.length > 1) {
                if (args[1].equals("addcontainer")) {
                    if (args.length < 3) {
                        System.err.println("Usage : ... <db> addcontainer <container>");
                        System.exit(5);
                    }
                    db.createContainer(args[2]);
                } else if (args[1].equals("rmcontainer")) {
                    if (args.length < 3) {
                        System.err.println("Usage : ... <db> rmcontainer <container>");
                        System.exit(5);
                    }
                    db.removeContainer(args[2]);
                } else if (args[1].equals("add")) {
                    if (args.length < 4) {
                        System.err.println("Usage : ... <db> add <container> <element>");
                        System.exit(5);
                    }
                    db.addElement(args[2], args[3]);
                } else if (args[1].equals("remove")) {
                    if (args.length < 4) {
                        System.err.println("Usage : ... <db> remove <container> <element>");
                        System.exit(5);
                    }
                    db.removeElement(args[2], args[3]);
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(4);
        }
        Enumeration e = db.getContainers();
        while (e.hasMoreElements()) {
            String container = e.nextElement().toString();
            System.out.println(container);
            Enumeration f = db.getElementsOf(container);
            while (f.hasMoreElements()) {
                String element = f.nextElement().toString();
                System.out.println("    " + element);
            }
        }
        System.exit(0);
    }

    private class ListEnumeration
    implements Enumeration {
        private Object[] _list;
        private int _position = 0;

        private ListEnumeration(Object[] list) {
            this._list = list;
        }

        @Override
        public boolean hasMoreElements() {
            return this._position < this._list.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("no more elments");
            }
            return this._list[this._position++];
        }
    }
}

