/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.util.Formats;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UserPrivileges {
    private Hashtable _allowed = new Hashtable();
    private Hashtable _denied = new Hashtable();
    private String _userName = "unknown";
    private boolean _faked = false;

    UserPrivileges() {
    }

    UserPrivileges(String userName) {
        this._userName = userName;
        this._faked = true;
    }

    UserPrivileges(String userName, String[] allowedList, String[] deniedList) {
        int i;
        this._userName = userName;
        for (i = 0; i < allowedList.length; ++i) {
            this._allowed.put(allowedList[i], allowedList[i]);
        }
        for (i = 0; i < deniedList.length; ++i) {
            this._denied.put(deniedList[i], deniedList[i]);
            this._allowed.remove(deniedList[i]);
        }
    }

    public String getUserName() {
        return this._userName;
    }

    void mergeHorizontal(UserPrivileges right) {
        String attr = null;
        Enumeration e = right._denied.keys();
        while (e.hasMoreElements()) {
            attr = (String)e.nextElement();
            this._denied.put(attr, attr);
        }
        e = right._allowed.keys();
        while (e.hasMoreElements()) {
            attr = (String)e.nextElement();
            this._allowed.put(attr, attr);
            this._denied.remove(attr);
        }
    }

    void mergeVertical(UserPrivileges upper) {
        String attr = null;
        Enumeration e = upper._allowed.keys();
        while (e.hasMoreElements()) {
            attr = (String)e.nextElement();
            if (this._denied.get(attr) != null) continue;
            this._allowed.put(attr, attr);
        }
        e = upper._denied.keys();
        while (e.hasMoreElements()) {
            attr = (String)e.nextElement();
            if (this._allowed.get(attr) != null) continue;
            this._denied.put(attr, attr);
        }
    }

    public boolean isAllowed(String check) {
        if (this._faked) {
            return false;
        }
        if (this._userName.equals("root")) {
            return true;
        }
        try {
            int i;
            if (this._denied.get(check) != null) {
                return false;
            }
            if (this._allowed.get(check) != null) {
                return true;
            }
            String base = null;
            int last = check.lastIndexOf(58);
            if (last < 0) {
                base = "";
            } else {
                base = check.substring(0, last) + ":";
                check = check.substring(last + 1);
            }
            if (check.length() < 1) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(check, ".");
            String[] tokens = new String[st.countTokens()];
            for (i = 0; i < tokens.length; ++i) {
                tokens[i] = st.nextToken();
            }
            for (i = tokens.length; i > 0; --i) {
                StringBuffer sb = new StringBuffer();
                sb.append(base);
                for (int j = 0; j < i - 1; ++j) {
                    sb.append(tokens[j]).append(".");
                }
                sb.append("*");
                String x = sb.toString();
                if (this._denied.get(x) != null) {
                    return false;
                }
                if (this._allowed.get(x) == null) continue;
                return true;
            }
            return false;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    public String toString() {
        if (this._faked) {
            return "UserPrivileges for " + this._userName + " faked";
        }
        StringBuffer sb = new StringBuffer();
        String x = "         ";
        int dx = 20;
        int m = Math.min(this._allowed.size(), this._denied.size());
        Enumeration a = this._allowed.keys();
        Enumeration d = this._denied.keys();
        for (int i = 0; i < m; ++i) {
            sb.append(x).append(Formats.field((String)a.nextElement(), dx)).append(Formats.field((String)d.nextElement(), dx)).append("\n");
        }
        if (this._allowed.size() > m) {
            while (a.hasMoreElements()) {
                sb.append(x).append(Formats.field((String)a.nextElement(), dx)).append(Formats.field("", 20)).append("\n");
            }
        }
        if (this._denied.size() > m) {
            while (d.hasMoreElements()) {
                sb.append(x).append(Formats.field("", 20)).append(Formats.field((String)d.nextElement(), dx)).append("\n");
            }
        }
        return sb.toString();
    }
}

