/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.security.digest.Crypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UnixPassword {
    private Hashtable _hash = null;
    private Crypt _crypt = new Crypt();
    private long _timeStamp = 0L;
    private File _file = null;

    public UnixPassword(String pswFile) throws IOException {
        this._file = new File(pswFile);
        if (!this._file.canRead()) {
            throw new IOException("File Not Found : " + pswFile);
        }
        this._update();
    }

    public synchronized void update() {
        long ts = this._file.lastModified();
        try {
            if (ts > this._timeStamp) {
                this._update();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _update() throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this._file));
        String line = null;
        StringTokenizer st = null;
        this._hash = new Hashtable();
        try {
            while ((line = br.readLine()) != null) {
                try {
                    st = new StringTokenizer(line, ":");
                    this._hash.put(st.nextToken(), st.nextToken());
                }
                catch (Exception ee) {}
            }
        }
        finally {
            br.close();
        }
    }

    public synchronized boolean checkPassword(String user, String password) {
        this.update();
        String cipher = (String)this._hash.get(user);
        if (cipher == null) {
            return false;
        }
        String result = this._crypt.crypt(cipher, password);
        return this._crypt.crypt(cipher, password).equals(cipher);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage : ... <file> <user> <passwd>");
            System.exit(4);
        }
        UnixPassword p = new UnixPassword(args[0]);
        System.out.println("Result : " + p.checkPassword(args[1], args[2]));
    }
}

