/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.util.Args;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginBroker
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(LoginBroker.class);
    private int _delay = 3;
    private Map<String, LoginEntry> _hash = new HashMap<String, LoginEntry>();
    private Set<String> _disabled = new HashSet<String>();
    public String hh_ls = "[-binary] [-protocol=<protocol_1,...,protocol_n>] [-time] [-all]";
    public String hh_disable = "<door> ...";
    public String hh_enable = "<door> ...";

    public LoginBroker(String name, String argString) throws Exception {
        super(name, argString, false);
        this.getNucleus().newThread(this, "Cleaner").start();
        this.start();
    }

    @Override
    public CellVersion getCellVersion() {
        return new CellVersion(super.getCellVersion().getRelease(), "$Revision: 1.6 $");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_ls(Args args) {
        boolean binary = args.hasOption("binary");
        String protocols = args.getOpt("protocol");
        ArrayList<LoginBrokerInfo> list = new ArrayList<LoginBrokerInfo>();
        StringBuffer sb = new StringBuffer();
        boolean showTime = args.hasOption("l");
        boolean showAll = args.hasOption("all");
        HashSet<String> protocolSet = null;
        if (protocols != null) {
            protocolSet = new HashSet<String>();
            for (String protocol : protocols.split(",")) {
                protocolSet.add(protocol);
            }
        }
        LoginBroker loginBroker = this;
        synchronized (loginBroker) {
            for (LoginEntry entry : this._hash.values()) {
                boolean disabled;
                LoginBrokerInfo info = entry.getInfo();
                boolean bl = disabled = this._disabled.contains(info.getIdentifier()) || this._disabled.contains(info.getCellName());
                if (protocols != null && !protocolSet.contains(info.getProtocolFamily())) continue;
                if (binary) {
                    if (!showAll && disabled) continue;
                    list.add(info);
                    continue;
                }
                sb.append(showTime ? entry.toString() : info.toString());
                if (disabled) {
                    sb.append("disabled;");
                }
                sb.append("\n");
            }
        }
        if (binary) {
            return list.toArray(new LoginBrokerInfo[list.size()]);
        }
        return sb.toString();
    }

    public synchronized String ac_disable_$_1_99(Args args) {
        for (int i = 0; i < args.argc(); ++i) {
            this._disabled.add(args.argv(i));
        }
        return "";
    }

    public synchronized String ac_enable_$_1_99(Args args) {
        for (int i = 0; i < args.argc(); ++i) {
            this._disabled.remove(args.argv(i));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                LoginBroker loginBroker = this;
                synchronized (loginBroker) {
                    HashMap<String, LoginEntry> set = new HashMap<String, LoginEntry>();
                    for (LoginEntry entry : this._hash.values()) {
                        if (!entry.isValid()) continue;
                        set.put(entry.getIdentifier(), entry);
                    }
                    this._hash = set;
                }
                Thread.sleep(60000L);
            }
        }
        catch (Exception ee) {
            _log.info("Worker interrupted due to : " + ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(CellMessage msg) {
        Object obj = msg.getMessageObject();
        if (obj instanceof LoginBrokerInfo) {
            LoginBroker loginBroker = this;
            synchronized (loginBroker) {
                LoginEntry entry = new LoginEntry((LoginBrokerInfo)obj);
                this._hash.put(entry.getIdentifier(), entry);
            }
        }
    }

    private class LoginEntry {
        private long _time = System.currentTimeMillis();
        private LoginBrokerInfo _info;

        private LoginEntry(LoginBrokerInfo info) {
            this._info = info;
        }

        private boolean isValid() {
            return System.currentTimeMillis() < this._time + (long)LoginBroker.this._delay * this._info.getUpdateTime();
        }

        public LoginBrokerInfo getInfo() {
            return this._info;
        }

        public boolean equals(Object obj) {
            return obj instanceof LoginEntry && this._info.equals(((LoginEntry)obj).getInfo());
        }

        public int hashCode() {
            return this._info.hashCode();
        }

        public String toString() {
            return this._info.toString() + (this._time + this._info.getUpdateTime() - System.currentTimeMillis()) + ";" + (this.isValid() ? "VALID" : "INVALID") + ";";
        }

        public String getIdentifier() {
            return this._info.getIdentifier();
        }
    }
}

