/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui.realm;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.services.gui.realm.CellDomainTree;
import dmg.cells.services.gui.realm.JCellPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class JRealm
extends JPanel {
    private DomainConnection _connection = null;
    private JCellPanel _cellPanel = null;

    public JRealm(DomainConnection connection) {
        this._connection = connection;
        BorderLayout l = new BorderLayout();
        l.setVgap(10);
        l.setHgap(10);
        this.setLayout(l);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), BorderFactory.createLineBorder(Color.black)), "Realm Controller"));
        JScrollPane sp = new JScrollPane();
        sp.setPreferredSize(new Dimension(300, 300));
        CellDomainTree tree = new CellDomainTree(this._connection);
        tree.addTreeSelectionListener(new CellSelection());
        sp.getViewport().add(tree);
        this.add("West", sp);
        this._cellPanel = new JCellPanel(this._connection);
        this.add("Center", this._cellPanel);
    }

    private class CellSelection
    implements TreeSelectionListener {
        private CellSelection() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            Object obj = event.getPath().getLastPathComponent();
            System.out.println("Selection : " + obj.getClass().getName());
            if (!(obj instanceof CellDomainTree.CellNode)) {
                return;
            }
            CellDomainTree.CellNode cellNode = (CellDomainTree.CellNode)obj;
            JRealm.this._cellPanel.setCell(cellNode.getAddress(), cellNode.getCellInfo());
        }
    }

    private class PrivateInfoPanel
    extends JPanel {
        @Override
        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }

        private PrivateInfoPanel() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createLineBorder(Color.black)), "JPanel"));
        }
    }
}

