/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.Document;

public class LmSetupHelp
extends JFrame {
    private static final String _theHelpText = "<html><head><title>LocationManager help</title></head><body bgcolor=yellow>\n<center><h1>The LocationManager Configuration Tool</h1></center><blockquote>\n<strong>Description</strong><blockquote>\nThe LocationManager Tool is intended to simplify the creation of\nthe LocationManager configuration file. It is able to read existing\nfiles and to store newly created or modified setups.\nIt supports <em>Domain</em>, <em>Connection</em>, <em>DefaultRoute</em>,\n<em>Links</em> and <em>Listen</em>\n</blockquote>\n<strong>The File Menu</strong><blockquote>The file menu allows to open existing *.lm (Open) files which are\ninterpreted and displayed, or existing drawings can be stored\nto disk (Save as). As soon as a file is assigned either through\n<em>Save as</em> or <em>Open</em> the <em>Save</em> item stores\nthe display into the assigned file.\n</blockquote><strong>The Drawing Window</strong><blockquote>\nThe Drawing is manipulated by popup menus only.\n<br><br><strong>Background Popup</strong>\n<blockquote>The background popup is actived by popup clicking the background.\nBeside color management, the background popup menu creates new\nDomain entries. The name of the new Domain is requested from the\nuser by a dialog box. The new Domain is presented by a squared\nbox. This box follows the mouse motion if its selected first.\n</blockquote><br><strong>The Domain Box Popup</strong>\n<blockquote>The selection menu poping up above a Domain Box allows to\n<ul><li>create a link to another domain box<li>removes an existing\nlink<li>deletes the box with all its links<li>declares the Domain\nas a listener</ul>\n</blockquote><br><strong>The Connection Line Popup</strong>\n<blockquote>The connection line popup is actived if the link line\nis clicked. The menu allow to <ul><li>delete the link<li>defines\nthe link to be the default route of the nearest Domain<li>\ndeletes the default route</ul>\n</blockquote></blockquote><strong>Supported Config commands</strong><blockquote>\n<pre>\ndefine &lt;DomainName&gt;\nconnect &lt;sourceDomainName&gt; &lt;destinationDomainName&gt;\ndefaultroute &lt;sourceDomainName&gt; &lt;destinationDomainName&gt;\nlisten &lt;DomainName&gt;\n# graphical commands\n# move &lt;DomainName&gt; &lt;newRelativePos X&gt; &lt;newRelativePos Y&gt;\n# color &lt;DomainName&gt;|* background|text|link|item &lt;r g b&gt;\n</pre>\n</blockquote><strong>Missing Features</strong><ul>\n<li>Overwriting existing files or exiting the application with storing\nthe current setup is not check or ack. by the user.\n<li>The tool needs to talk to the LocationManager directly</ul>\n<strong>Known Bugs</strong><ul>\n<li>The <em>Default Route Dots</em> are not calculated carefully. They sometimes\ndisappear behind the Domain Boxes.\n<li>The font size is not stored in the setup file\n</ul>\n</blockquote><hr><br><blockquote>\n<address>Author : patrick.fuhrmann@desy.de , Last Updated : $Date: 2001-04-17 07:10:21 $</address>\n</blockquote><br><br></body></html>";

    public LmSetupHelp(String title) {
        super(title);
        JEditorPane htmlDoc = new JEditorPane();
        htmlDoc.setContentType("text/html");
        Document doc = htmlDoc.getEditorKit().createDefaultDocument();
        htmlDoc.setDocument(doc);
        htmlDoc.setEditable(false);
        StringReader sr = new StringReader(_theHelpText);
        try {
            htmlDoc.read(sr, (Object)doc);
        }
        catch (Exception ee) {
            // empty catch block
        }
        this.getContentPane().add(new JScrollPane(htmlDoc));
    }

    public static void main(String[] argv) {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        LmSetupHelp f = new LmSetupHelp("LocationManager Help Tool");
        f.addWindowListener(l);
        f.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 200;
        int h = 200;
        f.setLocation(100, 100);
        f.setSize(600, 400);
        f.setVisible(true);
    }
}

