/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import dmg.cells.services.gui.LmSetupHelp;
import dmg.cells.services.gui.MovingPigs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;

public class LmSetup
extends JFrame {
    private JLabel _fileLabel = new JLabel(" Current File : ");
    private File _file = null;
    private JMenuBar _bar = new JMenuBar();
    private MovingPigs _draw = null;
    private JTextField _text = null;
    private Container _pane = null;
    private boolean _textActive = false;
    private LmSetupHelp _helpMenu = null;
    WindowListener l = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    };

    public LmSetup(String title) {
        super(title);
        this._draw = new MovingPigs();
        this._draw.setBorder(new BevelBorder(1));
        this._text = new JTextField();
        this._text.setOpaque(true);
        this._text.setBackground(new Color(2, 88, 130));
        this._text.setForeground(new Color(255, 255, 255));
        this._text.setBorder(new BevelBorder(1));
        this._text.setFont(new Font("Courier", 2, 24));
        this._text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String string = LmSetup.this._text.getText();
                LmSetup.this._draw.command(string);
                LmSetup.this._text.setText("");
            }
        });
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LmSetup.this._draw.shutdown();
            }
        };
        this.addWindowListener(l);
        this._pane = this.getContentPane();
        BorderLayout bl = new BorderLayout();
        bl.setVgap(10);
        bl.setHgap(10);
        this._pane.setLayout(bl);
        this._pane.add("Center", this._draw);
        this._fileLabel.setBorder(new BevelBorder(1));
        this._pane.add("North", this._fileLabel);
        this._bar.add(new FileActionListener());
        this._bar.add(this._draw.getEditMenu());
        JMenu menu = new JMenu("Help");
        menu.add(new HelpListener());
        menu.add(new CommandMenu());
        this._bar.add(menu);
        this.setJMenuBar(this._bar);
    }

    public static void main(String[] argv) {
        LmSetup f = new LmSetup("LocationManager Setup Tool");
        f.pack();
        f.setLocation(100, 100);
        f.setSize(600, 400);
        f.setVisible(true);
    }

    private class FileActionListener
    extends JMenu
    implements ActionListener {
        private JMenuItem _new;
        private JMenuItem _open;
        private JMenuItem _save;
        private JMenuItem _saveAs;
        private JMenuItem _revert;
        private JMenuItem _exit;
        private JFileChooser _chooser;
        private File _directory;

        private FileActionListener() {
            super("File");
            this._new = new JMenuItem("New...");
            this._open = new JMenuItem("Open ...");
            this._save = new JMenuItem("Save");
            this._saveAs = new JMenuItem("Save As ...");
            this._revert = new JMenuItem("Revert to saved");
            this._exit = new JMenuItem("Exit");
            this._chooser = new JFileChooser();
            this._directory = null;
            this._new.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
            this._open.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
            this._save.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
            this._saveAs.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
            this._revert.setAccelerator(KeyStroke.getKeyStroke(82, 2, false));
            this.add(this._new);
            this.addSeparator();
            this.add(this._open);
            this.add(this._save);
            this.add(this._saveAs);
            this.add(this._revert);
            this.addSeparator();
            this.add(this._exit);
            this._new.addActionListener(this);
            this._open.addActionListener(this);
            this._save.addActionListener(this);
            this._saveAs.addActionListener(this);
            this._revert.addActionListener(this);
            this._exit.addActionListener(this);
            this._save.setEnabled(false);
            this._revert.setEnabled(false);
            this._chooser.setFileFilter(new LMFileFilter());
            this._chooser.setCurrentDirectory(this._directory);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this._new) {
                this.newAction(event);
            } else if (event.getSource() == this._open) {
                this.openAction(event);
            } else if (event.getSource() == this._save) {
                this.saveAction(event);
            } else if (event.getSource() == this._saveAs) {
                this.saveActionAs(event);
            } else if (event.getSource() == this._revert) {
                this.revertAction(event);
            } else if (event.getSource() == this._exit) {
                LmSetup.this._draw.shutdown();
            }
        }

        private void setProcessing() {
            LmSetup.this._fileLabel.setForeground(Color.red);
            LmSetup.this._fileLabel.setText(" Processing File : " + LmSetup.this._file.getName());
        }

        private void setOk() {
            LmSetup.this._fileLabel.setForeground(Color.blue);
            LmSetup.this._fileLabel.setText(" Current File : " + (LmSetup.this._file == null ? "<none>" : LmSetup.this._file.getName()));
            this._save.setEnabled(true);
            this._revert.setEnabled(true);
        }

        private void setProblem(String problem) {
            LmSetup.this._fileLabel.setForeground(Color.red);
            LmSetup.this._fileLabel.setText(" " + problem + " : " + LmSetup.this._file == null ? "" : LmSetup.this._file.getName());
        }

        private void newAction(ActionEvent event) {
            LmSetup.this._draw.clear();
            LmSetup.this._file = null;
            this.setOk();
            this._save.setEnabled(false);
            this._revert.setEnabled(false);
        }

        private void saveActionAs(ActionEvent event) {
            if ((LmSetup.this._file = this.getFile()) == null) {
                return;
            }
            this.saveAction(event);
            this.setOk();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveAction(ActionEvent event) {
            if (LmSetup.this._file == null) {
                return;
            }
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(LmSetup.this._file));
                try {
                    LmSetup.this._draw.writeSetup(pw);
                }
                finally {
                    pw.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void openAction(ActionEvent event) {
            if ((LmSetup.this._file = this.getFile()) == null) {
                return;
            }
            this.setProcessing();
            LmSetup.this._bar.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (FileActionListener.this.runInterpreter(LmSetup.this._file) != 0) {
                        FileActionListener.this.setProblem("Illegal File Format");
                    } else {
                        FileActionListener.this.setOk();
                    }
                    LmSetup.this._bar.setEnabled(true);
                }
            }).start();
        }

        private void revertAction(ActionEvent event) {
            if (LmSetup.this._file == null) {
                return;
            }
            this.setProcessing();
            LmSetup.this._bar.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (FileActionListener.this.runInterpreter(LmSetup.this._file) != 0) {
                        FileActionListener.this.setProblem("Illegal File Format");
                    } else {
                        FileActionListener.this.setOk();
                    }
                    LmSetup.this._bar.setEnabled(true);
                }
            }).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runInterpreter(File file) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(file));
                LmSetup.this._draw.clear();
                try {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        LmSetup.this._draw.command(line);
                        Thread.sleep(200L);
                    }
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ee) {
                return -1;
            }
            catch (InterruptedException ee) {
                return -1;
            }
            return 0;
        }

        private File getFile() {
            this._chooser.setCurrentDirectory(this._directory);
            int result = this._chooser.showOpenDialog(LmSetup.this);
            if (result == 0) {
                File file = this._chooser.getSelectedFile();
                this._directory = this._chooser.getCurrentDirectory();
                return file;
            }
            return null;
        }
    }

    private class HelpListener
    extends JMenuItem
    implements ActionListener {
        private HelpListener() {
            super("Help");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (LmSetup.this._helpMenu == null) {
                LmSetup.this._helpMenu = new LmSetupHelp("LocationManager Help");
                LmSetup.this._helpMenu.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                LmSetup.this._helpMenu.setLocation(200, 200);
                LmSetup.this._helpMenu.setSize(600, 400);
                LmSetup.this._helpMenu.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        LmSetup.this._helpMenu.setVisible(false);
                    }
                });
            }
            LmSetup.this._helpMenu.setVisible(true);
        }
    }

    private class CommandMenu
    extends JMenuItem
    implements ActionListener {
        private CommandMenu() {
            super("Commander");
            this.addActionListener(this);
            this.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (LmSetup.this._textActive) {
                LmSetup.this._pane.remove(LmSetup.this._text);
                LmSetup.this._textActive = false;
            } else {
                LmSetup.this._textActive = true;
                LmSetup.this._pane.add("South", LmSetup.this._text);
            }
            LmSetup.this._pane.doLayout();
        }
    }

    private class LMFileFilter
    extends FileFilter {
        private LMFileFilter() {
        }

        @Override
        public String getDescription() {
            return "LocationManager (*.lm)";
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".lm");
        }
    }
}

