/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class JLoginPanel
extends JPanel {
    private Object AntiAlias = RenderingHints.VALUE_ANTIALIAS_ON;
    private JLabel _logoString = new JLabel("Cell Login", 0);
    private Font _bigFont = new Font("Times", 3, 26);
    private boolean _isLogin = true;
    private JButton _setupButton = new JButton("Setup");
    private JButton _loginButton = new JButton("Login");
    private String _password = "";
    private UserPasswordPanel _loginPanel = new UserPasswordPanel();
    private SetupPanel _setupPanel = new SetupPanel();
    private MessagePanel _messagePanel = new MessagePanel();
    private CardLayout _cards = new CardLayout();
    private JPanel _cardPanel = new JPanel();
    private JPanel _currentPanel = this._loginPanel;
    private ActionListener _actionListener = null;

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void setMessage(String message) {
        this.displayMessagePanel(message);
    }

    public void setErrorMessage(String message) {
        if (message.length() > 45) {
            message = message.substring(0, 34);
        }
        this._loginPanel._statusLabel.setText(message);
    }

    public void displayMessagePanel(String message) {
        this._setupButton.setEnabled(false);
        this._loginButton.setEnabled(false);
        if (message != null && !message.equals("")) {
            this._messagePanel.setText(message);
        }
        this._cards.show(this._cardPanel, "message");
    }

    public void displayLoginPanel() {
        this._setupButton.setEnabled(true);
        this._loginButton.setEnabled(true);
        this._setupButton.setText("Setup");
        this._cards.show(this._cardPanel, "login");
    }

    public void displaySetupPanel() {
        this._setupButton.setEnabled(true);
        this._loginButton.setEnabled(false);
        this._setupButton.setText("Back");
        this._cards.show(this._cardPanel, "setup");
    }

    @Override
    public void paintComponent(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        super.paintComponent(g);
    }

    public JLoginPanel() {
        BorderLayout bl = new BorderLayout();
        bl.setVgap(10);
        bl.setHgap(10);
        this.setLayout(bl);
        this.setBorder(new BevelBorder(1));
        this._logoString.setFont(this._bigFont);
        this.add((Component)this._logoString, "North");
        this._cardPanel.setLayout(this._cards);
        this._cardPanel.add((Component)this._loginPanel, "login");
        this._cardPanel.add((Component)this._setupPanel, "setup");
        this._cardPanel.add((Component)this._messagePanel, "message");
        this.add((Component)this._cardPanel, "Center");
        URL imageUrl = this.getClass().getResource("/images/cells-logo.jpg");
        Icon icon = imageUrl == null ? new CellIcon(80, 80) : new ImageIcon(imageUrl);
        IconDisplayPanel c = new IconDisplayPanel(icon);
        this.add((Component)c, "West");
        JPanel b = new JPanel(new BorderLayout());
        b.add((Component)this._setupButton, "West");
        b.add((Component)this._loginButton, "East");
        this.add("South", b);
        this._setupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (JLoginPanel.this._isLogin) {
                    JLoginPanel.this.displaySetupPanel();
                } else {
                    JLoginPanel.this.displayLoginPanel();
                }
                JLoginPanel.this._isLogin = !JLoginPanel.this._isLogin;
            }
        });
        this._loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLoginPanel.this._password = new String(JLoginPanel.this._loginPanel._passwd.getPassword());
                JLoginPanel.this._loginPanel._passwd.setText("");
                JLoginPanel.this.processEvent(event);
            }
        });
        this.setLogin(System.getProperty("user.name"));
        this.setSchema("default");
        this.setPortnumber("22124");
        try {
            String thisHost = InetAddress.getLocalHost().getHostName();
            int pos = thisHost.indexOf(".");
            if (pos > -1) {
                thisHost = thisHost.substring(pos);
                this.setHostname("dcache" + thisHost);
            } else {
                this.setHostname("dcache");
            }
        }
        catch (Exception e) {
            this.setHostname("dcache");
        }
    }

    public void setLocationManager(boolean lm) {
        this._setupPanel._lm.setSelected(lm);
    }

    public void setHostname(String hostname) {
        this._setupPanel._host.setText(hostname);
    }

    public void setPortnumber(String portnumber) {
        this._setupPanel._port.setText(portnumber);
    }

    public void setSchema(String schema) {
        this._setupPanel._schema.setText(schema);
    }

    public void setLogin(String login) {
        this._loginPanel._login.setText(login);
    }

    public void setPassword(String passwd) {
        this._loginPanel._passwd.setText(passwd);
    }

    public boolean isLocationManager() {
        return this._setupPanel._lm.isSelected();
    }

    public String getHostname() {
        return this._setupPanel._host.getText();
    }

    public String getPortnumber() {
        return this._setupPanel._port.getText();
    }

    public String getSchema() {
        return this._setupPanel._schema.getText();
    }

    public String getLogin() {
        return this._loginPanel._login.getText();
    }

    public String getPassword() {
        return this._password;
    }

    public synchronized void addActionListener(ActionListener l) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, l);
    }

    public void processEvent(ActionEvent e) {
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(e);
        }
    }

    private class CellIcon
    implements Icon {
        private int _height = 0;
        private int _width = 0;

        private CellIcon(int width, int height) {
            this._height = height;
            this._width = width;
        }

        @Override
        public void paintIcon(Component c, Graphics gin, int xi, int yi) {
            Graphics2D g = (Graphics2D)gin;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, JLoginPanel.this.AntiAlias);
            g.setColor(c.getBackground());
            g.fillRect(xi, yi, this._width - 1, this._height - 1);
            int x = xi + 4;
            int y = yi + 4;
            int width = this._width - 8;
            int height = this._height - 8;
            Color col = new Color(0, 0, 255);
            while (width > 0) {
                g.setColor(col);
                g.fillOval(x, y, width /= 2, height /= 2);
                x += width;
                y += height;
                col = col.brighter();
            }
        }

        @Override
        public int getIconWidth() {
            return this._height;
        }

        @Override
        public int getIconHeight() {
            return this._width;
        }
    }

    private class IconDisplayPanel
    extends JPanel {
        private Icon _icon = null;

        public IconDisplayPanel(Icon icon) {
            this._icon = icon;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this._icon.getIconWidth(), this._icon.getIconHeight());
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            int x = (d.width - this._icon.getIconWidth()) / 2;
            int y = (d.height - this._icon.getIconHeight()) / 2;
            this._icon.paintIcon(this, g, x, y);
        }
    }

    private class UserPasswordPanel
    extends JPanel {
        private JLabel _loginLabel = new JLabel("Login Name", 4);
        private JLabel _passwordLabel = new JLabel("Password", 4);
        private JTextField _login = new JTextField(25);
        private JPasswordField _passwd = new JPasswordField(25);
        private JLabel _statusLabel = new JLabel("", 0);

        @Override
        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }

        private UserPasswordPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this._loginLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            this.add((Component)this._login, c);
            c.gridx = 0;
            c.gridy = 1;
            this.add((Component)this._passwordLabel, c);
            c.gridx = 1;
            c.gridy = 1;
            this.add((Component)this._passwd, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.fill = 2;
            this._statusLabel.setForeground(Color.red);
            this.add((Component)this._statusLabel, c);
            this._passwd.setEchoChar('*');
        }
    }

    private class SetupPanel
    extends JPanel {
        private JLabel _hostLabel = new JLabel("Hostname", 4);
        private JLabel _portLabel = new JLabel("Portnumber", 4);
        private JLabel _schemaLabel = new JLabel("Schema", 4);
        private JTextField _host = new JTextField(20);
        private JTextField _port = new JTextField(20);
        private JTextField _schema = new JTextField(10);
        private JCheckBox _lm = new JCheckBox("Use LM", false);

        @Override
        public Insets getInsets() {
            return new Insets(20, 20, 20, 20);
        }

        private SetupPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(" Cell Server Setup "));
            GridBagConstraints c = new GridBagConstraints();
            c.gridheight = 1;
            c.insets = new Insets(4, 4, 4, 4);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this._hostLabel, c);
            c.gridwidth = 2;
            c.gridx = 1;
            c.gridy = 0;
            this.add((Component)this._host, c);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            this.add((Component)this._portLabel, c);
            c.gridwidth = 2;
            c.gridx = 1;
            c.gridy = 1;
            this.add((Component)this._port, c);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 2;
            this.add((Component)this._schemaLabel, c);
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 2;
            this.add((Component)this._schema, c);
            c.gridwidth = 1;
            c.gridx = 2;
            c.gridy = 2;
            this.add((Component)this._lm, c);
            boolean selected = this._lm.isSelected();
            this._schema.setEnabled(selected);
            this._schemaLabel.setEnabled(selected);
            this._lm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean selected = SetupPanel.this._lm.isSelected();
                    SetupPanel.this._schema.setEnabled(selected);
                    SetupPanel.this._schemaLabel.setEnabled(selected);
                }
            });
        }
    }

    private class MessagePanel
    extends JPanel {
        private JLabel _message = new JLabel("", 0);

        private MessagePanel() {
            this.setLayout(new GridBagLayout());
            this._message.setForeground(Color.red);
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 2;
            this.add((Component)this._message, c);
        }

        public void setText(String message) {
            this._message.setText(message);
        }
    }
}

