/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellTunnelInfo;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class CanonicalTopology {
    private String[] _domainNames = null;
    private LinkPair2[] _linkPairs = null;

    public CanonicalTopology() {
    }

    public CanonicalTopology(CellDomainNode[] in) {
        this._domainNames = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            this._domainNames[i] = in[i].getName();
        }
        Arrays.sort(this._domainNames);
        Hashtable<String, Integer> nameHash = new Hashtable<String, Integer>();
        for (int i = 0; i < in.length; ++i) {
            nameHash.put(this._domainNames[i], i);
        }
        Hashtable<LinkPair2, LinkPair2> linkHash = new Hashtable<LinkPair2, LinkPair2>();
        for (int i = 0; i < in.length; ++i) {
            String thisDomain = in[i].getName();
            int thisPosition = (Integer)nameHash.get(thisDomain);
            CellTunnelInfo[] links = in[i].getLinks();
            if (links == null) continue;
            for (int j = 0; j < links.length; ++j) {
                CellDomainInfo info = links[j].getRemoteCellDomainInfo();
                if (info == null) continue;
                String thatDomain = info.getCellDomainName();
                int thatPosition = (Integer)nameHash.get(thatDomain);
                LinkPair2 pair = new LinkPair2(thisPosition, thatPosition);
                linkHash.put(pair, pair);
            }
        }
        this._linkPairs = new LinkPair2[linkHash.size()];
        Enumeration e = linkHash.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this._linkPairs[i] = (LinkPair2)e.nextElement();
            ++i;
        }
        Arrays.sort(this._linkPairs);
    }

    public int links() {
        return this._linkPairs.length;
    }

    public int domains() {
        return this._domainNames.length;
    }

    public String getDomain(int i) {
        return this._domainNames[i];
    }

    public LinkPair2 getLinkPair2(int i) {
        return this._linkPairs[i];
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CanonicalTopology)) {
            return false;
        }
        CanonicalTopology topo = (CanonicalTopology)other;
        return Arrays.equals(this._domainNames, topo._domainNames) && Arrays.equals(this._linkPairs, topo._linkPairs);
    }

    public int hashCode() {
        return Arrays.hashCode(this._domainNames) ^ Arrays.hashCode(this._linkPairs);
    }

    private class LinkPair2
    implements Comparable {
        int[] _pair = new int[2];

        public LinkPair2(int x, int y) {
            if (x > y) {
                this._pair[0] = y;
                this._pair[1] = x;
            } else {
                this._pair[0] = x;
                this._pair[1] = y;
            }
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof LinkPair2 && this._pair[0] == ((LinkPair2)obj)._pair[0] && this._pair[1] == ((LinkPair2)obj)._pair[1]) {
                equals = true;
            }
            return equals;
        }

        public int hashCode() {
            return this._pair[0] << 16 | this._pair[1];
        }

        public int compareTo(Object obj) {
            LinkPair2 x = (LinkPair2)obj;
            if (this._pair[0] == x._pair[0] && this._pair[1] == x._pair[1]) {
                return 0;
            }
            if (this._pair[0] < x._pair[0] || this._pair[0] == x._pair[0] && this._pair[1] < x._pair[1]) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return " [0]=" + this._pair[0] + " [1]=" + this._pair[1];
        }

        public int getBottom() {
            return this._pair[0];
        }

        public int getTop() {
            return this._pair[1];
        }
    }
}

