/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellNucleus;
import dmg.protocols.telnet.TelnetServerAuthentication;
import dmg.protocols.telnet.TelnetStreamEngine;
import dmg.util.Args;
import dmg.util.DummyStreamEngine;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetLoginManager
extends CellAdapter
implements Cell,
Runnable,
TelnetServerAuthentication {
    private static final Logger _log = LoggerFactory.getLogger(TelnetLoginManager.class);
    private String _cellName;
    private CellNucleus _nucleus;
    private int _listenPort;
    private ServerSocket _serverSocket;
    private Thread _listenThread;
    private int _connectionRequestCounter = 0;
    private int _connectionAcceptionCounter = 0;
    private Hashtable<Thread, Socket> _connectionThreads = new Hashtable();
    private Args _args;
    private String _loginCellClass = "dmg.cells.services.StreamLoginCell";
    private boolean _opt_localhost;
    private boolean _opt_dummy;
    private boolean _opt_elch;
    private boolean _opt_anyuser;
    private boolean _opt_raw;
    private static final String __usage = "<port> {loginCell] [-dummy] [-localhost] [-anyuser] [-elch]";

    public TelnetLoginManager(String name, String args) throws Exception {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        this._cellName = name;
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("USAGE : ... <port> {loginCell] [-dummy] [-localhost] [-anyuser] [-elch]");
            }
            this._listenPort = new Integer(this._args.argv(0));
            if (this._args.argc() > 1) {
                this._loginCellClass = this._args.argv(1);
            }
            this._opt_dummy = false;
            this._opt_localhost = false;
            this._opt_anyuser = false;
            this._opt_elch = true;
            this._opt_raw = false;
            for (int i = 0; i < this._args.optc(); ++i) {
                if (this._args.optv(i).equals("-dummy")) {
                    this._opt_dummy = true;
                    continue;
                }
                if (this._args.optv(i).equals("-localhost")) {
                    this._opt_localhost = true;
                    continue;
                }
                if (this._args.optv(i).equals("-elch")) {
                    this._opt_elch = true;
                    continue;
                }
                if (this._args.optv(i).equals("-anyuser")) {
                    this._opt_anyuser = true;
                    continue;
                }
                if (!this._args.optv(i).equals("-raw")) continue;
                this._opt_raw = true;
            }
            this._serverSocket = new ServerSocket(this._listenPort);
        }
        catch (Exception e) {
            this.start();
            this.kill();
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new IllegalArgumentException(e.toString());
        }
        this._listenThread = new Thread((Runnable)this, "listenThread");
        this._listenThread.start();
        this.start();
    }

    @Override
    public void cleanUp() {
        try {
            _log.info("Trying to close serverSocket");
            this._serverSocket.close();
            _log.info("Trying serverSocket close returned");
        }
        catch (Exception ee) {
            _log.warn("ignoring exception on telnetoutputstream.write {}", (Object)ee.toString());
        }
    }

    private void acceptConnections() {
        while (true) {
            Socket socket = null;
            try {
                socket = this._serverSocket.accept();
                ++this._connectionRequestCounter;
                _log.info("Connection request from " + socket.getInetAddress());
                Thread t = new Thread(this);
                this._connectionThreads.put(t, socket);
                t.start();
                continue;
            }
            catch (IOException ioe) {
                _log.warn("Got an IO Exception ( closing server ) : " + ioe);
            }
            catch (Exception ee) {
                _log.warn("Got an Exception in getting keys ( closing connection ) : " + ee);
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    public void acceptConnection(Socket socket) {
        Thread t = Thread.currentThread();
        try {
            _log.info("acceptThread (" + t + "): creating protocol engine");
            DummyStreamEngine engine = this._opt_raw ? new DummyStreamEngine(socket) : new TelnetStreamEngine(socket, this);
            String name = Subjects.getDisplayName((Subject)engine.getSubject());
            _log.info("acceptThread (" + t + "): connection created for user " + name);
            String cellName = "tn-" + name + "*";
            String[] paraNames = new String[1];
            Object[] parameter = new Object[1];
            paraNames[0] = "dmg.util.StreamEngine";
            parameter[0] = engine;
            this.createNewCell(this._loginCellClass, cellName, paraNames, parameter);
        }
        catch (Exception e) {
            _log.warn("Exception in TelnetStreamEngine : " + e);
            if (e instanceof InvocationTargetException) {
                Exception ie = (Exception)((InvocationTargetException)e).getTargetException();
                _log.warn("TargetException in TelnetStreamEngine : " + ie);
            }
            try {
                socket.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        Socket currentSocket = null;
        if (Thread.currentThread() == this._listenThread) {
            this.acceptConnections();
        } else {
            currentSocket = this._connectionThreads.remove(Thread.currentThread());
            if (currentSocket != null) {
                this.acceptConnection(currentSocket);
            }
        }
    }

    @Override
    public String toString() {
        return "P=" + this._listenPort + ";C=" + this._loginCellClass;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println(" ListenPort     : " + this._listenPort);
        pw.println(" LoginCellClass : " + this._loginCellClass);
    }

    @Override
    public boolean isHostOk(InetAddress host) {
        _log.info("Request for host " + host + " (" + host.getHostName() + ")");
        if (this._opt_dummy) {
            return true;
        }
        return this._opt_localhost && host.getHostName().equals("localhost");
    }

    @Override
    public boolean isUserOk(InetAddress host, String user) {
        _log.info("Request for host " + host + " user " + user);
        return this._opt_anyuser;
    }

    @Override
    public boolean isPasswordOk(InetAddress host, String user, String passwd) {
        _log.info("Request for host " + host + " user " + user + " password " + passwd);
        return passwd.equals("elch");
    }
}

