/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.services.MessageObjectFrame;
import dmg.util.Args;
import dmg.util.CommandException;
import dmg.util.Gate;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectLoginCell
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(ObjectLoginCell.class);
    private StreamEngine _engine;
    private ObjectInputStream _in;
    private ObjectOutputStream _out;
    private InetAddress _host;
    private Subject _subject;
    private Thread _workerThread;
    private Gate _readyGate = new Gate(false);
    private final Hashtable _hash = new Hashtable();
    private CellNucleus _nucleus;

    public ObjectLoginCell(String name, StreamEngine engine) {
        super(name, "", false);
        this._engine = engine;
        this._nucleus = this.getNucleus();
        try {
            this._out = new ObjectOutputStream(this._engine.getOutputStream());
            this._in = new ObjectInputStream(this._engine.getInputStream());
            this._subject = this._engine.getSubject();
            this._host = this._engine.getInetAddress();
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw new IllegalArgumentException("Problem : " + e.toString());
        }
        this._workerThread = this._nucleus.newThread(this);
        this._workerThread.start();
        this.useInterpreter(false);
        this.start();
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._workerThread) {
            while (true) {
                Object commandObject = null;
                try {
                    commandObject = this._in.readObject();
                    if (commandObject == null || !(commandObject instanceof MessageObjectFrame)) break;
                    if (this.execute((MessageObjectFrame)commandObject) <= 0) continue;
                    try {
                        this._out.close();
                    }
                    catch (Exception ee) {}
                }
                catch (IOException e) {
                    _log.info("EOF Exception in read line : " + e);
                    break;
                }
                catch (Exception e) {
                    _log.info("I/O Error in read line : " + e);
                    break;
                }
            }
            _log.info("EOS encountered");
            this._readyGate.open();
            this.kill();
        }
    }

    @Override
    public void cleanUp() {
        _log.info("Clean up called");
        try {
            this._out.close();
        }
        catch (Exception ee) {
            _log.warn("ignoring exception on PrintWriter.close {}", (Object)ee.toString());
        }
        this._readyGate.check();
        _log.info("finished");
    }

    public String ac_ping(Args args) throws CommandException {
        CellMessage msg = null;
        try {
            msg = new CellMessage(new CellPath("System"), "ps -a");
            this.sendMessage(msg);
            _log.info("sendMessage o.k. : " + msg);
        }
        catch (Exception e) {
            _log.warn("Exception while sending : " + e);
            return "Ok weh";
        }
        return "Done";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(MessageObjectFrame frame) {
        CellMessage msg = null;
        _log.info("Forwarding : " + frame.getCellPath() + "   " + frame.getObject().toString());
        try {
            msg = new CellMessage(frame.getCellPath(), frame.getObject());
            Hashtable hashtable = this._hash;
            synchronized (hashtable) {
                this.sendMessage(msg);
                _log.info("sendMessage o.k. : " + msg);
                _log.info("Adding to hash " + msg.getUOID());
                this._hash.put(msg.getUOID(), frame);
            }
        }
        catch (Exception e) {
            _log.warn("Exception while sending : " + e);
            frame.setObject(e);
            this.sendObject(frame);
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(CellMessage msg) {
        MessageObjectFrame frame;
        _log.info("Message arrived : " + msg);
        Hashtable hashtable = this._hash;
        synchronized (hashtable) {
            frame = (MessageObjectFrame)this._hash.remove(msg.getLastUOID());
        }
        if (frame == null) {
            _log.warn("Not found in hash : " + msg.getLastUOID());
            return;
        }
        frame.setObject(msg.getMessageObject());
        this.sendObject(frame);
    }

    private void sendObject(Object obj) {
        try {
            this._out.writeObject(obj);
            this._out.reset();
            this._out.flush();
        }
        catch (Exception e) {
            this.kill();
        }
    }
}

