/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.network.GNLCell;
import dmg.cells.network.LocationManagerConnector;
import dmg.cells.network.RetryTunnel;
import dmg.cells.network.RetryTunnel2;
import dmg.cells.network.TopoCell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.SystemCell;
import dmg.cells.services.BatchCell;
import dmg.cells.services.LocationManager;
import dmg.cells.services.RoutingManager;
import dmg.cells.services.login.LoginManager;
import dmg.cells.services.login.UserMgrCell;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Domain {
    private static final Logger _log = LoggerFactory.getLogger(Domain.class);
    private static final int IDLE = 0;
    private static final int ASSEMBLE = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            try {
                Class<CellAdapter> c = CellAdapter.class;
                Package p = Package.getPackage("dmg.cells.nucleus");
                if (p != null) {
                    String tmp = p.getSpecificationTitle();
                    System.out.println("SpecificationTitle:   " + (tmp == null ? "(Unknown)" : tmp));
                    tmp = p.getSpecificationVendor();
                    System.out.println("SpecificationVendor:  " + (tmp == null ? "(Unknown)" : tmp));
                    tmp = p.getSpecificationVersion();
                    System.out.println("SpecificationVersion: " + (tmp == null ? "(Unknown)" : tmp));
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            System.out.println("USAGE : <domainName> [options]");
            System.out.println("         -telnet  \"<telnetPort> [-acm=acm] [-localOk] [-passwd=<passwd>]\"");
            System.out.println("         -tunnel(2)  <tunnelPort>");
            System.out.println("         -connect(2) <host> <port>");
            System.out.println("         -routed");
            System.out.println("         -batch <fileName>");
            System.out.println("         -boot  <bootDomain>");
            System.out.println("         -spy   <spyListenPort>");
            System.out.println("         -ic    <interruptHandlerClass>");
            System.out.println("         -param <key>=<value> [...]");
            System.out.println("         -acm   <userDbRoot>");
            System.out.println("         -connectDomain   <domainName>");
            System.out.println("         -accept");
            System.out.println("         -lm [<hostname>] <portNumber> [options]");
            System.out.println("              Options : /noclient /noboot /strict=yes|no");
            System.out.println("         -debug [full]");
            System.out.println("         -cp <cellPrinterCellName>");
            System.exit(1);
        }
        int state = 0;
        Vector<String> columns = null;
        Vector<Object[]> rowVec = new Vector<Object[]>();
        int pos = 1;
        while (pos < args.length) {
            switch (state) {
                case 0: {
                    if (args[pos].charAt(0) == '-') {
                        columns = new Vector<String>();
                        columns.addElement(args[pos]);
                        state = 1;
                    }
                    ++pos;
                    break;
                }
                case 1: {
                    if (args[pos].charAt(0) == '-') {
                        Object[] col = new String[columns.size()];
                        columns.copyInto(col);
                        rowVec.addElement(col);
                        state = 0;
                        break;
                    }
                    columns.addElement(args[pos++]);
                }
            }
        }
        if (state == 1) {
            Object[] col = new String[columns.size()];
            columns.copyInto(col);
            rowVec.addElement(col);
        }
        Hashtable<String, String[]> argHash = new Hashtable<String, String[]>();
        for (int i = 0; i < rowVec.size(); ++i) {
            String[] el = (String[])rowVec.elementAt(i);
            argHash.put(el[0], el);
        }
        SystemCell systemCell = null;
        try {
            String a;
            StringBuffer sb;
            String[] commands;
            ArrayList<String> v;
            String[][] p;
            systemCell = new SystemCell(args[0]);
            String[] tmp = null;
            if (argHash.get("-version") != null) {
                p = Package.getPackage("dmg.cells.nucleus");
                System.out.println(p.toString());
                System.exit(0);
            }
            if ((tmp = (String[])argHash.get("-param")) != null && tmp.length > 1) {
                p = Domain.getParameter(tmp);
                Map<String, Object> dict = systemCell.getDomainContext();
                for (int i = 0; i < p.length; ++i) {
                    dict.put(p[i][0], p[i][1]);
                }
            }
            if ((tmp = (String[])argHash.get("-debug")) != null) {
                _log.info("Starting DebugSequence");
                v = new ArrayList<String>();
                if (tmp.length > 1 && tmp[1].equals("full")) {
                    v.add("set printout CellGlue all");
                    v.add("set printout default all");
                } else {
                    v.add("set printout default 3");
                }
                commands = new String[v.size()];
                new BatchCell("debug", v.toArray(commands));
            }
            if ((tmp = (String[])argHash.get("-cp")) != null) {
                sb = new StringBuffer();
                for (int i = 1; i < tmp.length; ++i) {
                    sb.append(" ");
                    if (tmp[i].startsWith("/")) {
                        sb.append("-").append(tmp[i].substring(1));
                        continue;
                    }
                    sb.append(tmp[i]);
                }
                a = sb.toString();
                _log.info("Loading new CellPrinter " + a);
                ArrayList<String> v2 = new ArrayList<String>();
                v2.add("load cellprinter " + a);
                String[] commands2 = new String[v2.size()];
                new BatchCell("cellprinter", v2.toArray(commands2));
            }
            if (argHash.get("-routed") != null) {
                _log.info("Starting Routing Manager");
                new RoutingManager("RoutingMgr", "up0");
            }
            if ((tmp = (String[])argHash.get("-lm")) != null && tmp.length > 1) {
                sb = new StringBuffer();
                for (int i = 1; i < tmp.length; ++i) {
                    sb.append(" ");
                    if (tmp[i].startsWith("/")) {
                        sb.append("-").append(tmp[i].substring(1));
                        continue;
                    }
                    sb.append(tmp[i]);
                }
                a = sb.toString();
                _log.info("Installing LocationManager '" + a + "'");
                new LocationManager("lm", a);
                new RoutingManager("RoutingMgr", "");
            }
            if (argHash.get("-silent") != null) {
                _log.info("Starting Silent Sequence");
                v = new ArrayList();
                v.add("set printout CellGlue none");
                v.add("set printout default none");
                commands = new String[v.size()];
                new BatchCell("silent", v.toArray(commands));
            }
            if ((tmp = (String[])argHash.get("-telnet")) != null && tmp.length > 1) {
                sb = new StringBuffer();
                sb.append(tmp[1]).append(" dmg.cells.services.StreamLoginCell").append(" -prot=telnet ");
                for (int i = 3; i < tmp.length; ++i) {
                    sb.append(" -").append(tmp[i]);
                }
                _log.info("Starting LoginManager (telnet) on " + sb.toString());
                new LoginManager("tlm", sb.toString());
            }
            if ((tmp = (String[])argHash.get("-tunnel2")) != null && tmp.length > 1) {
                sb = new StringBuffer();
                sb.append(tmp[1]).append(" dmg.cells.network.RetryTunnel2").append(" -prot=raw ");
                for (int i = 3; i < tmp.length; ++i) {
                    sb.append(" -").append(tmp[i]);
                }
                _log.info("Starting RetryTunnel2 (raw) on " + sb.toString());
                new LoginManager("down", sb.toString());
            }
            if ((tmp = (String[])argHash.get("-connect")) != null && tmp.length > 2) {
                _log.info("Starting RetryTunnel on " + tmp[1] + " " + tmp[2]);
                new RetryTunnel("up0", tmp[1] + " " + tmp[2]);
            }
            if ((tmp = (String[])argHash.get("-connect2")) != null && tmp.length > 2) {
                _log.info("Starting RetryTunnel2 on " + tmp[1] + " " + tmp[2]);
                new RetryTunnel2("up0", tmp[1] + " " + tmp[2]);
            }
            if ((tmp = (String[])argHash.get("-connectDomain")) != null && tmp.length > 1) {
                _log.info("Starting LocationMgrTunnel on " + tmp[1]);
                new LocationManagerConnector("upD", "-lm=lm -domain=" + tmp[1]);
            }
            if ((tmp = (String[])argHash.get("-acm")) != null && tmp.length > 1) {
                _log.info("Starting UserMgrCell on " + tmp[1]);
                new UserMgrCell("acm", tmp[1]);
            }
            if ((tmp = (String[])argHash.get("-tunnel")) != null && tmp.length > 1) {
                _log.info("Starting RetryTunnel on " + tmp[1]);
                new GNLCell("down", "dmg.cells.network.RetryTunnel " + tmp[1]);
            }
            if ((tmp = (String[])argHash.get("-accept")) != null && tmp.length > 0) {
                _log.info("Starting LocationMgrTunnel(listen)");
                new LoginManager("downD", "0 dmg.cells.network.LocationMgrTunnel -prot=raw -lm=lm");
            }
            if ((tmp = (String[])argHash.get("-boot")) != null && tmp.length > 1) {
                _log.info("Starting BootSequence for Domain " + tmp[1]);
                v = new ArrayList();
                v.add("onerror shutdown");
                v.add("set context bootDomain " + tmp[1]);
                v.add("waitfor context Ready ${bootDomain}");
                v.add("copy context://${bootDomain}/${thisDomain}Setup context:bootStrap");
                v.add("exec context bootStrap");
                v.add("# exit");
                String[] commands3 = new String[v.size()];
                new BatchCell("boot", v.toArray(commands3));
            }
            if ((tmp = (String[])argHash.get("-spy")) != null && tmp.length > 1) {
                _log.info("Starting TopologyManager ");
                new TopoCell("topo", "");
                _log.info("Starting Spy Listener on " + tmp[1]);
                new LoginManager("Spy", tmp[1] + " dmg.cells.services.ObjectLoginCell" + " -prot=raw");
            }
            if ((tmp = (String[])argHash.get("-batch")) != null && tmp.length > 1) {
                _log.info("Starting BatchCell on " + tmp[1]);
                new BatchCell("batch", tmp[1]);
            }
            if ((tmp = (String[])argHash.get("-ic")) != null && tmp.length > 1) {
                _log.info("Installing interruptHandlerClass " + tmp[1]);
                systemCell.enableInterrupts(tmp[1]);
            }
        }
        catch (Exception e) {
            _log.error(e.toString(), (Throwable)e);
        }
    }

    private static String[][] getParameter(String[] args) {
        String[][] param = new String[args.length - 1][];
        for (int i = 0; i < args.length - 1; ++i) {
            String p = args[i + 1];
            param[i] = new String[2];
            int pos = p.indexOf(61);
            if (pos < 0) {
                param[i][0] = p;
                param[i][1] = "";
                continue;
            }
            param[i][0] = p.substring(0, pos);
            param[i][1] = p.length() == pos + 1 ? "" : p.substring(pos + 1);
        }
        return param;
    }
}

