/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.network.RetryTunnel;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.Gate;
import dmg.util.StateEngine;
import dmg.util.StateThread;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBootstrap
implements Cell,
CellEventListener,
StateEngine {
    private static final Logger _log = LoggerFactory.getLogger(ClientBootstrap.class);
    private InetAddress _address;
    private int _port;
    private Gate _finalGate = new Gate(false);
    private Gate _routeGate = new Gate(false);
    private CellNucleus _nucleus;
    private boolean _routeAdded = false;
    private StateThread _engine;
    private String[] _commands;
    private static final int RST_CREATE_TUNNEL = 1;
    private static final int RST_TUNNEL_READY = 2;
    private static final int RST_TUNNEL_FAILED = 3;
    private static final int RST_ROUTE_READY = 4;
    private static final int RST_MSG_RECV = 5;
    private static final int RST_MSG_SENT_FAILED = 6;
    private static final int RST_WAITING = 7;
    private static final String[] __rst_state_names = new String[]{"<init>", "<creatingTunnel>", "<addRoute>", "<tunnelFailed>", "<sendingRequest>", "<runningCommands>", "<msgSentFailed>", "<waiting>"};

    public ClientBootstrap(String cellName, String arguments) throws Exception {
        Args args = new Args(arguments);
        if (args.argc() < 2) {
            throw new IllegalArgumentException("USAGE : ... <host> <port>");
        }
        InetAddress address = InetAddress.getByName(args.argv(0));
        int port = new Integer(args.argv(1));
        this._ClientBootstrap(cellName, address, port);
    }

    public void _ClientBootstrap(String cellName, InetAddress address, int port) throws Exception {
        this._address = address;
        this._port = port;
        this._nucleus = new CellNucleus(this, cellName);
        this._nucleus.addCellEventListener(this);
        this._engine = new StateThread(this);
        this._engine.start();
    }

    private String getRunState() {
        int state = this._engine.getState();
        if (state < 0) {
            return "<finished>";
        }
        if (state >= __rst_state_names.length) {
            return "<Panic>";
        }
        return __rst_state_names[state];
    }

    @Override
    public int runState(int state) {
        _log.info("runState : in state <" + this.getRunState() + ">");
        switch (state) {
            case 0: {
                return 1;
            }
            case 1: {
                new RetryTunnel("tunnel*", this._address, this._port);
                return 2;
            }
            case 3: 
            case 6: {
                return -1;
            }
            case 2: {
                this._routeGate.check();
                return 4;
            }
            case 4: {
                try {
                    CellPath path = new CellPath("config");
                    CellMessage msg = new CellMessage(path, "config " + this._nucleus.getCellDomainName());
                    msg = this._nucleus.sendAndWait(msg, 20000L);
                    if (msg == null) {
                        _log.info("runState : sendAndWait timed out");
                        return 6;
                    }
                    Object answer = msg.getMessageObject();
                    if (answer == null) {
                        _log.info("runState : null object received");
                        return 6;
                    }
                    if (!(answer instanceof String[])) {
                        _log.info("runState : answer is " + answer);
                        this._engine.setState(7);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ee) {
                            // empty catch block
                        }
                        return 4;
                    }
                    this._commands = (String[])answer;
                    return 5;
                }
                catch (NoRouteToCellException sme) {
                    return 6;
                }
                catch (InterruptedException sme) {
                    return 6;
                }
            }
            case 5: {
                CellShell shell = new CellShell(this._nucleus);
                for (int i = 0; i < this._commands.length; ++i) {
                    _log.info("runState : command : " + this._commands[i]);
                    try {
                        String answer = shell.command(this._commands[i]);
                        _log.info("runState : answer  : " + answer);
                        continue;
                    }
                    catch (Exception eee) {
                        // empty catch block
                    }
                }
                _log.info("runState : Command execution finished");
                return -1;
            }
        }
        return 0;
    }

    public String toString() {
        return this._nucleus.getCellDomainName() + " Run State : " + this.getRunState();
    }

    @Override
    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Run State : " + this.getRunState() + "\n");
        return sb.toString();
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof LastMessageEvent) {
            this._finalGate.open();
        } else {
            CellMessage msg = me.getMessage();
            if (msg.isFinalDestination()) {
                String command;
                Object obj = msg.getMessageObject();
                _log.info("Msg arrived (f) : " + msg);
                if (obj instanceof String && (command = (String)obj).length() < 1) {
                    return;
                }
            }
        }
    }

    @Override
    public void prepareRemoval(KillEvent ce) {
        this._finalGate.check();
    }

    @Override
    public synchronized void routeAdded(CellEvent ce) {
        _log.info("routeAdded : Got routing info");
        if (!this._routeAdded) {
            CellRoute route = (CellRoute)ce.getSource();
            if (route.getRouteType() != 3) {
                return;
            }
            Args args = new Args("-default *@" + route.getDomainName());
            CellRoute defRoute = new CellRoute(args);
            _log.info("routeAdded : adding default : " + defRoute);
            this._nucleus.routeAdd(defRoute);
            this._routeAdded = true;
            this._routeGate.open();
        }
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
    }

    @Override
    public void cellCreated(CellEvent ce) {
    }

    @Override
    public void cellDied(CellEvent ce) {
    }

    @Override
    public void cellExported(CellEvent ce) {
    }

    @Override
    public void routeDeleted(CellEvent ce) {
    }
}

