/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellShell;
import dmg.util.Args;
import dmg.util.CommandExitException;
import dmg.util.Exceptions;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCell
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(BatchCell.class);
    private final Reader _in;
    private final String _source;
    private CellShell _shell;

    public BatchCell(String name, String[] argStrings) throws Exception {
        super(name, "", true);
        try {
            this.useInterpreter(false);
            StringBuilder input = new StringBuilder();
            for (String s : argStrings) {
                input.append(s).append('\n');
            }
            this._in = new StringReader(input.toString());
            this._source = name;
            Thread worker = new Thread(this);
            worker.start();
        }
        catch (Exception e) {
            this.kill();
            throw e;
        }
    }

    public BatchCell(String name, String argString) throws Exception {
        super(name, argString, true);
        try {
            Args args = this.getArgs();
            if (args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <batchFilename>");
            }
            this._source = args.argv(0);
            if (args.hasOption("jar")) {
                InputStream input = ClassLoader.getSystemResourceAsStream(this._source);
                if (input == null) {
                    throw new IllegalArgumentException("Resource not found : " + this._source);
                }
                this._in = new InputStreamReader(input);
            } else {
                this._in = new FileReader(this._source);
            }
            Thread worker = new Thread(this);
            worker.start();
        }
        catch (Exception e) {
            this.kill();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.initLoggingContext();
            CellNucleus nucleus = this.getNucleus();
            this._shell = new CellShell(nucleus);
            this._shell.execute(this._source, this._in, new Args(""));
        }
        catch (CommandExitException e) {
            _log.error(Exceptions.getMessageWithCauses(e));
            if (e.getErrorCode() == 666) {
                System.exit(6);
            }
        }
        catch (IOException e) {
            _log.error("I/O error: " + e.getMessage());
        }
        finally {
            try {
                this._in.close();
            }
            catch (IOException e) {}
            this.kill();
        }
    }
}

