/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CDPDummy;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.ClassDataProvider0;
import dmg.cells.nucleus.ClassLoaderC;
import dmg.util.ClassDataProvider;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLoaderProvider {
    private _TreeNode _root = new _TreeNode(new CDPDummy());

    public String[][] getProviders() {
        Vector v = new Vector();
        this.getProviders(v, "*", this._root);
        String[][] rt = new String[v.size()][];
        v.copyInto((Object[])rt);
        return rt;
    }

    public void getProviders(Vector v, String name, _TreeNode cursor) {
        ClassDataProvider le = cursor.getDefault();
        String[] out = new String[]{name, le == null ? "none" : le.toString()};
        v.addElement(out);
        Enumeration e = cursor.keys();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String nodeName = (String)e.nextElement();
            _TreeNode node = cursor.get(nodeName);
            this.getProviders(v, name + "." + nodeName, node);
        }
    }

    public void setDefault(ClassDataProvider defEntry) {
        this._root.setDefault(defEntry);
    }

    public void addEntry(String selection, ClassDataProvider provider) {
        String token;
        StringTokenizer st = new StringTokenizer(selection, ".");
        _TreeNode cursor = this._root;
        while (st.hasMoreTokens() && !(token = st.nextToken()).equals("*")) {
            _TreeNode rt = cursor.get(token);
            if (rt == null) {
                rt = new _TreeNode();
                cursor.put(token, rt);
            }
            cursor = rt;
        }
        cursor.setDefault(provider);
    }

    public void removeSystemProvider(String selection) {
        this.addEntry(selection, null);
    }

    public void addSystemProvider(String selection) {
        this.addEntry(selection, new CDPDummy());
    }

    public void addFileProvider(String selection, File file) {
        this.addEntry(selection, new ClassDataProvider0(file));
    }

    public void addCellProvider(String selection, CellNucleus nucleus, CellPath cellPath) {
        this.addEntry(selection, new ClassDataProvider0(nucleus, cellPath));
    }

    ClassDataProvider getEntry(String className) {
        StringTokenizer st = new StringTokenizer(className, ".");
        _TreeNode cursor = this._root;
        ClassDataProvider def = this._root.getDefault();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            _TreeNode rt = cursor.get(token);
            if (rt == null) {
                return def;
            }
            ClassDataProvider tmp = rt.getDefault();
            def = tmp == null ? def : tmp;
            cursor = rt;
        }
        return def;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoaderC loader = new ClassLoaderC(this);
        return loader.loadClass(className);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("USAGE : ... <selection> ... ");
            System.exit(43);
        }
        ClassLoaderProvider clp = new ClassLoaderProvider();
        for (int i = 0; i < args.length && !args[i].equals("."); ++i) {
            System.out.println("Loading .... " + args[i]);
            StringTokenizer st = new StringTokenizer(args[i], ":");
            String selection = st.nextToken();
            String provider = st.nextToken();
            ClassDataProvider0 loader = null;
            if (!provider.equals("system")) {
                loader = new ClassDataProvider0(new File(provider));
            }
            clp.addEntry(selection, loader);
        }
        String[][] out = clp.getProviders();
        for (int j = 0; j < out.length; ++j) {
            System.out.println(" " + out[j][0] + " -> " + out[j][1]);
        }
    }

    private class _TreeNode {
        private Hashtable _hash = null;
        private ClassDataProvider _entry = null;

        private _TreeNode(ClassDataProvider entry) {
            this._entry = entry;
        }

        private _TreeNode() {
        }

        private void put(String key, _TreeNode value) {
            if (this._hash == null) {
                this._hash = new Hashtable();
            }
            this._hash.put(key, value);
        }

        private _TreeNode get(String key) {
            return this._hash == null ? null : (_TreeNode)this._hash.get(key);
        }

        private void setDefault(ClassDataProvider entry) {
            this._entry = entry;
        }

        private ClassDataProvider getDefault() {
            return this._entry;
        }

        private Enumeration keys() {
            return this._hash == null ? null : this._hash.keys();
        }
    }
}

