/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellRoute;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CellRoutingTable
implements Serializable {
    static final long serialVersionUID = -1456280129622980563L;
    private final Map<String, CellRoute> _wellknown = new HashMap<String, CellRoute>();
    private final Map<String, CellRoute> _domain = new HashMap<String, CellRoute>();
    private final Map<String, CellRoute> _exact = new HashMap<String, CellRoute>();
    private CellRoute _dumpster = null;
    private CellRoute _default = null;

    public synchronized void add(CellRoute route) throws IllegalArgumentException {
        int type = route.getRouteType();
        switch (type) {
            case 1: 
            case 6: {
                String dest = route.getCellName() + "@" + route.getDomainName();
                if (this._exact.get(dest) != null) {
                    throw new IllegalArgumentException("Duplicated route Entry for : " + dest);
                }
                this._exact.put(dest, route);
                break;
            }
            case 2: {
                String dest = route.getCellName();
                if (this._wellknown.get(dest) != null) {
                    throw new IllegalArgumentException("Duplicated route Entry for : " + dest);
                }
                this._wellknown.put(dest, route);
                break;
            }
            case 3: {
                String dest = route.getDomainName();
                if (this._domain.get(dest) != null) {
                    throw new IllegalArgumentException("Duplicated route Entry for : " + dest);
                }
                this._domain.put(dest, route);
                break;
            }
            case 4: {
                if (this._default != null) {
                    throw new IllegalArgumentException("Duplicated route Entry for default.");
                }
                this._default = route;
                break;
            }
            case 5: {
                if (this._dumpster != null) {
                    throw new IllegalArgumentException("Duplicated route Entry for dumpster");
                }
                this._dumpster = route;
            }
        }
    }

    public synchronized void delete(CellRoute route) throws IllegalArgumentException {
        int type = route.getRouteType();
        switch (type) {
            case 1: 
            case 6: {
                String dest = route.getCellName() + "@" + route.getDomainName();
                if (this._exact.remove(dest) != null) break;
                throw new IllegalArgumentException("Route Entry Not Found for : " + dest);
            }
            case 2: {
                String dest = route.getCellName();
                if (this._wellknown.remove(dest) != null) break;
                throw new IllegalArgumentException("Route Entry Not Found for : " + dest);
            }
            case 3: {
                String dest = route.getDomainName();
                if (this._domain.remove(dest) != null) break;
                throw new IllegalArgumentException("Route Entry Not Found for : " + dest);
            }
            case 4: {
                if (this._default == null) {
                    throw new IllegalArgumentException("Route Entry Not Found for default");
                }
                this._default = null;
                break;
            }
            case 5: {
                if (this._dumpster == null) {
                    throw new IllegalArgumentException("Route Entry Not Found dumpster");
                }
                this._dumpster = null;
            }
        }
    }

    public synchronized CellRoute find(CellAddressCore addr) {
        String cellName = addr.getCellName();
        String domainName = addr.getCellDomainName();
        CellRoute route = null;
        if (domainName.equals("local")) {
            route = this._wellknown.get(cellName);
            if (route != null) {
                return route;
            }
        } else {
            route = this._exact.get(cellName + "@" + domainName);
            if (route != null) {
                return route;
            }
            route = this._domain.get(domainName);
            if (route != null) {
                return route;
            }
        }
        return (route = this._exact.get(cellName + "@" + domainName)) == null ? this._default : route;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(CellRoute.headerToString() + "\n");
        for (CellRoute route : this._exact.values()) {
            sb.append(route.toString() + "\n");
        }
        for (CellRoute route : this._wellknown.values()) {
            sb.append(route.toString() + "\n");
        }
        for (CellRoute route : this._domain.values()) {
            sb.append(route.toString() + "\n");
        }
        if (this._default != null) {
            sb.append(this._default.toString() + "\n");
        }
        if (this._dumpster != null) {
            sb.append(this._dumpster.toString() + "\n");
        }
        return sb.toString();
    }

    public synchronized CellRoute[] getRoutingList() {
        int total = this._exact.size() + this._wellknown.size() + this._domain.size() + (this._default != null ? 1 : 0) + (this._dumpster != null ? 1 : 0);
        CellRoute[] routes = new CellRoute[total];
        int i = 0;
        for (CellRoute route : this._exact.values()) {
            routes[i++] = route;
        }
        for (CellRoute route : this._wellknown.values()) {
            routes[i++] = route;
        }
        for (CellRoute route : this._domain.values()) {
            routes[i++] = route;
        }
        if (this._default != null) {
            routes[i++] = this._default;
        }
        if (this._dumpster != null) {
            routes[i++] = this._dumpster;
        }
        return routes;
    }

    public static void main(String[] argsxx) {
        CellRoutingTable table = new CellRoutingTable();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Args args = new Args(line);
                if (args.argc() < 1) continue;
                String com = args.argv(0);
                args.shift();
                if (com.equals("add")) {
                    CellRoutingTable.c_add(table, args);
                    continue;
                }
                if (com.equals("show")) {
                    System.out.println(table.toString());
                    continue;
                }
                if (com.equals("delete")) {
                    CellRoutingTable.c_delete(table, args);
                    continue;
                }
                if (!com.equals("find")) continue;
                CellRoutingTable.c_find(table, args);
            }
        }
        catch (IOException ioe) {
            System.err.println(" Exception " + ioe);
        }
    }

    public static void c_delete(CellRoutingTable table, Args args) {
        try {
            table.delete(new CellRoute(args));
        }
        catch (Exception e) {
            System.err.println(" Exception " + e);
        }
    }

    public static void c_add(CellRoutingTable table, Args args) {
        try {
            table.add(new CellRoute(args));
        }
        catch (Exception e) {
            System.err.println(" Exception " + e);
        }
    }

    public static void c_find(CellRoutingTable table, Args args) {
        if (args.argc() == 0) {
            System.out.println("Cell Argument missing");
            return;
        }
        try {
            CellAddressCore addr = new CellAddressCore(args.argv(0));
            System.out.println(" Searching : " + addr.toString());
            CellRoute route = table.find(addr);
            if (route != null) {
                System.out.println(" Found route : " + route.toString());
            } else {
                System.out.println("Not found");
            }
        }
        catch (Exception e) {
            System.err.println(" Exception " + e);
        }
    }
}

