/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellAddressCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class CellPath
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4922955783102747577L;
    private List<CellAddressCore> _list = new ArrayList<CellAddressCore>();
    private List<CellAddressCore> _mark = null;
    private int _position = -1;
    private int _storage = -1;

    protected CellPath() {
    }

    protected CellPath(CellPath addr) {
        this._list.addAll(addr._list);
        this._position = addr._position;
        this._storage = addr._storage;
    }

    public CellPath(String path) {
        this.add(path);
    }

    public CellPath(String cellName, String domainName) {
        this.add(new CellAddressCore(cellName, domainName));
    }

    public int hops() {
        return this._list.size();
    }

    synchronized void add(CellAddressCore core) {
        this._list.add(core);
        if (this._position < 0) {
            this._position = 0;
        }
    }

    public synchronized void add(CellPath addr) {
        this._list.addAll(addr._list);
    }

    public void add(String cell, String domain) {
        this.add(new CellAddressCore(cell, domain));
    }

    public synchronized void add(String path) {
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreTokens()) {
            this.add(new CellAddressCore(st.nextToken()));
        }
    }

    public Object clone() {
        CellPath addr = new CellPath();
        addr._list.addAll(this._list);
        addr._position = this._position;
        addr._storage = this._storage;
        return addr;
    }

    synchronized void insert(CellAddressCore core) {
        this._list.add(this._position + 1, core);
        if (this._position < 0) {
            this._position = 0;
        }
    }

    public synchronized void insert(String path) {
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreTokens()) {
            this.insert(new CellAddressCore(st.nextToken()));
        }
    }

    public void mark() {
        this._mark = new ArrayList<CellAddressCore>(this._list);
        this._storage = this._position;
    }

    public void reset() {
        if (this._mark == null) {
            return;
        }
        this._list = this._mark;
        this._position = this._storage;
        this._storage = -1;
        this._mark = null;
    }

    public void insert(String cell, String domain) {
        this.add(new CellAddressCore(cell, domain));
    }

    public synchronized boolean next() {
        if (this._position >= this._list.size() - 1) {
            return false;
        }
        ++this._position;
        return true;
    }

    public synchronized void toFirstDestination() {
        this._position = this._list.size() == 0 ? -1 : 0;
    }

    public synchronized void revert() {
        Collections.reverse(this._list);
        this.toFirstDestination();
    }

    public synchronized boolean isFinalDestination() {
        return this._position >= this._list.size() - 1;
    }

    public synchronized boolean isFirstDestination() {
        return this._position == 0;
    }

    CellAddressCore getCurrent() {
        if (this._list.size() == 0 || this._position < 0 || this._position >= this._list.size()) {
            return null;
        }
        return this._list.get(this._position);
    }

    public CellAddressCore getDestinationAddress() {
        return this._list.get(this._list.size() - 1);
    }

    void replaceCurrent(CellAddressCore core) {
        if (this._list.size() == 0 || this._position < 0 || this._position >= this._list.size()) {
            return;
        }
        this._list.set(this._position, core);
    }

    public String getCellName() {
        CellAddressCore core = this.getCurrent();
        return core == null ? null : core.getCellName();
    }

    public String getCellDomainName() {
        CellAddressCore core = this.getCurrent();
        return core == null ? null : core.getCellDomainName();
    }

    public String toSmallString() {
        int size = this._list.size();
        if (size == 0) {
            return "[empty]";
        }
        if (this._position >= size || this._position < 0) {
            return "[INVALID]";
        }
        CellAddressCore core = this._list.get(this._position);
        if (size == 1) {
            return "[" + core.toString() + "]";
        }
        if (this._position == 0) {
            return "[" + core.toString() + ":...(" + (size - 1) + ")...]";
        }
        if (this._position == size - 1) {
            return "[...(" + (size - 1) + ")...:" + core.toString() + "]";
        }
        return "[...(" + this._position + ")...:" + core.toString() + "...(" + (size - this._position - 1) + ")...]";
    }

    public String toString() {
        return this.toFullString();
    }

    public String toFullString() {
        int size = this._list.size();
        if (size == 0) {
            return "[empty]";
        }
        if (this._position >= size || this._position < 0) {
            return "[INVALID]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this._list.size(); ++i) {
            if (i > 0) {
                sb.append(":");
            }
            if (i == this._position) {
                sb.append(">");
            }
            if (this._storage > -1 && i == this._storage) {
                sb.append("*");
            }
            sb.append(this._list.get(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        CellPath other;
        if (!(obj instanceof CellPath)) {
            return false;
        }
        CellPath cellPath = other = (CellPath)obj;
        synchronized (cellPath) {
            int s = 0;
            s = this._list.size();
            if (s != other._list.size()) {
                return false;
            }
            for (int i = 0; i < s; ++i) {
                if (this._list.get(i).equals(other._list.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public synchronized int hashCode() {
        int sum = 0;
        for (CellAddressCore addr : this._list) {
            sum += addr.hashCode();
        }
        return sum;
    }

    public static void main(String[] args) {
        CellPath addr = new CellPath();
        for (int i = 0; i < args.length; ++i) {
            addr.add(args[i]);
        }
        System.out.println(addr.toFullString());
        System.out.println(addr.toString());
        while (addr.next()) {
            System.out.println(addr.toString());
        }
    }
}

