/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.UOID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CellMessage
implements Cloneable,
Serializable {
    static final long serialVersionUID = -5559658187264201731L;
    private CellPath _source;
    private CellPath _destination;
    private CellPath _markSource = null;
    private CellPath _markDestination = null;
    private Object _message;
    private long _creationTime;
    private long _ttl = Long.MAX_VALUE;
    private int _mode;
    private UOID _umid;
    private UOID _lastUmid;
    private final byte[] _messageStream;
    private boolean _isRouted = false;
    private int _hopCount = 0;
    private boolean _isAcknowledge = false;
    private boolean _isPersistent = false;
    private Object _session;
    private static final int ORIGINAL_MODE = 0;
    private static final int STREAM_MODE = 1;
    private static final int DUMMY_MODE = 2;
    private transient long _receivedAt;

    public CellMessage(CellPath addr, Object msg) {
        this._destination = addr;
        this._message = msg;
        this._source = new CellPath();
        this._receivedAt = this._creationTime = System.currentTimeMillis();
        this._mode = 0;
        this._lastUmid = this._umid = new UOID();
        this._session = CDC.getSession();
        this._messageStream = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<CM: S=").append(this._source.toString()).append(";D=").append(this._destination.toString());
        if (this._markSource != null) {
            sb.append(";MS=").append(this._markSource.toString());
        }
        if (this._markDestination != null) {
            sb.append(";MD=").append(this._markDestination.toString());
        }
        if (this._mode == 0) {
            sb.append(";C=").append(this._message.getClass().getName());
        } else {
            sb.append(";C=Stream");
        }
        sb.append(";O=").append(this._umid).append(";LO=").append(this._lastUmid);
        if (this._session != null) {
            sb.append(";SID=").append(this._session);
        }
        if (this._ttl < Long.MAX_VALUE) {
            sb.append(";TTL=").append(this._ttl);
        }
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        return this._umid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CellMessage) {
            return ((CellMessage)obj)._umid.equals(this._umid);
        }
        if (obj instanceof UOID) {
            return ((UOID)obj).equals(this._umid);
        }
        return false;
    }

    public void setAcknowledge(boolean ack) {
        this._isAcknowledge = ack;
    }

    public boolean isAcknowledge() {
        return this._isAcknowledge;
    }

    public boolean isReply() {
        return this._isPersistent;
    }

    public int getHopCount() {
        return this._hopCount;
    }

    public void incHopCount() {
        ++this._hopCount;
    }

    public UOID getUOID() {
        return this._umid;
    }

    public UOID getLastUOID() {
        return this._lastUmid;
    }

    public void setUOID(UOID umid) {
        this._umid = umid;
    }

    public void setLastUOID(UOID lastUOID) {
        this._lastUmid = lastUOID;
    }

    public Object getSession() {
        return this._session;
    }

    public void setSession(Object session) {
        this._session = session;
    }

    public void setTtl(long ttl) {
        this._ttl = ttl;
    }

    public long getTtl() {
        return this._ttl;
    }

    public CellPath getDestinationAddress() {
        return this._destination;
    }

    public CellPath getSourceAddress() {
        return this._source;
    }

    public CellPath getDestinationPath() {
        return this._destination;
    }

    public CellPath getSourcePath() {
        return this._source;
    }

    public Object getMessageObject() {
        return this._message;
    }

    public void setMessageObject(Object obj) {
        this._message = obj;
    }

    public void revertDirection() {
        this._destination = this._source;
        this._destination.revert();
        this._source = new CellPath();
        this._lastUmid = this._umid;
        this._isPersistent = true;
    }

    public void markLocation() {
        this._markDestination = (CellPath)this._destination.clone();
        this._markSource = (CellPath)this._source.clone();
    }

    public void resetLocation() {
        if (this._markDestination == null || this._markSource == null) {
            return;
        }
        this._destination = this._markDestination;
        this._source = this._markSource;
    }

    public boolean isFinalDestination() {
        return this._destination.isFinalDestination();
    }

    public boolean isFirstDestination() {
        return this._destination.isFirstDestination();
    }

    public boolean nextDestination() {
        return this._destination.next();
    }

    void isRouted(boolean r) {
        this._isRouted = r;
    }

    boolean wasRouted() {
        return this._isRouted;
    }

    boolean isStreamMode() {
        return this._mode == 1;
    }

    void touch() {
        if (this._destination.isFirstDestination()) {
            this._umid = new UOID();
        }
    }

    CellMessage() {
        this._mode = 2;
        this._messageStream = null;
    }

    public CellMessage(CellMessage cm) throws SerializationException {
        if (cm._mode == 0) {
            this._messageStream = this._originalToStream(cm);
        } else {
            this._streamToOriginal(cm);
            this._messageStream = null;
        }
    }

    void addSourceAddress(CellAddressCore source) {
        this._source.add(source);
    }

    private void _copyInternalStuff(CellMessage cm) {
        this._destination = (CellPath)cm._destination.clone();
        this._source = (CellPath)cm._source.clone();
        this._markDestination = cm._markDestination == null ? null : (CellPath)cm._markDestination.clone();
        this._markSource = cm._markSource == null ? null : (CellPath)cm._markSource.clone();
        this._creationTime = cm._creationTime;
        this._receivedAt = cm._receivedAt;
        this._umid = cm._umid;
        this._lastUmid = cm._lastUmid;
        this._hopCount = cm._hopCount;
        this._isPersistent = cm._isPersistent;
        this._isAcknowledge = cm._isAcknowledge;
        this._session = cm._session;
        this._ttl = cm._ttl;
    }

    private byte[] _originalToStream(CellMessage cm) throws SerializationException {
        this._copyInternalStuff(cm);
        this._mode = 1;
        ObjectOutputStream out = null;
        ByteArrayOutputStream array = null;
        try {
            array = new ByteArrayOutputStream();
            out = new ObjectOutputStream(array);
            out.writeObject(cm._message);
        }
        catch (InvalidClassException e) {
            throw new SerializationException("Failed to serialize object: " + e + "(this is usually a bug)", e);
        }
        catch (NotSerializableException e) {
            throw new SerializationException("Failed to serialize object because the object is not serializable (this is usually a bug)", e);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize object: " + e, e);
        }
        return array.toByteArray();
    }

    private void _streamToOriginal(CellMessage cm) throws SerializationException {
        this._copyInternalStuff(cm);
        this._mode = 0;
        ByteArrayInputStream in = null;
        ObjectInputStream stream = null;
        try {
            in = new ByteArrayInputStream(cm._messageStream);
            stream = new ObjectInputStream(in);
            this._message = stream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Failed to deserialize object: The class could not be found. Is there a software version mismatch in your installation?", e);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to deserialize object: " + e, e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._receivedAt = System.currentTimeMillis();
        if (this._ttl == 0L) {
            this._ttl = Long.MAX_VALUE;
        }
    }

    public long getLocalAge() {
        return System.currentTimeMillis() - this._receivedAt;
    }
}

