/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import java.io.Serializable;

public class CellAddressCore
implements Cloneable,
Serializable {
    static final long serialVersionUID = 4072907109959708379L;
    private final String _domain;
    private final String _cell;
    private final int _hashcode;

    public CellAddressCore(String addr) {
        int ind = addr.indexOf(64);
        if (ind < 0) {
            this._cell = addr;
            this._domain = "local";
        } else {
            this._cell = addr.substring(0, ind);
            this._domain = ind == addr.length() - 1 ? "local" : addr.substring(ind + 1);
        }
        this._hashcode = (this._domain + this._cell).hashCode();
    }

    public CellAddressCore(String addr, String domain) {
        this._cell = addr;
        this._domain = domain;
        this._hashcode = (this._domain + this._cell).hashCode();
    }

    public String getCellName() {
        return this._cell;
    }

    public String getCellDomainName() {
        return this._domain;
    }

    public String toString() {
        return (this._cell != null ? this._cell : "UnknownCell") + "@" + (this._domain != null ? this._domain : "UnknownDomain");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CellAddressCore)) {
            return false;
        }
        CellAddressCore other = (CellAddressCore)obj;
        return other._domain.equals(this._domain) && other._cell.equals(this._cell);
    }

    public int hashCode() {
        return this._hashcode;
    }
}

