/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.util.Args;
import dmg.util.Gate;
import dmg.util.StateEngine;
import dmg.util.StateThread;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTunnel
implements Cell,
Runnable,
CellTunnel,
StateEngine {
    private static final Logger _log = LoggerFactory.getLogger(RetryTunnel.class);
    private InetAddress _address = null;
    private int _port = 0;
    private CellNucleus _nucleus = null;
    private Thread _receiverThread = null;
    private final Object _receiverLock = new Object();
    private BlockingQueue<CellMessage> _messageArrivedQueue = new LinkedBlockingQueue<CellMessage>();
    private Gate _finalGate = new Gate(false);
    private ObjectInputStream _input = null;
    private ObjectOutputStream _output = null;
    private Socket _socket;
    private String _mode = "None";
    private CellRoute _route = null;
    private CellDomainInfo _remoteDomainInfo = null;
    private StateThread _engine = null;
    private long _connectionStarted = 0L;
    private int _connectionRetries = 0;
    private int _connectionRequests = 0;
    private int _messagesToTunnel = 0;
    private int _messagesToSystem = 0;
    private static final int CST_CONNECTING = 1;
    private static final int CST_CON_TIMEOUT = 2;
    private static final int CST_CON_FAILED = 3;
    private static final int CST_CONNECTED = 4;
    private static final int CST_PROT_START = 5;
    private static final int CST_PROT_TIMEOUT = 6;
    private static final int CST_PROT_FAILED = 7;
    private static final int CST_PROT_OK = 8;
    private static final int SST_SEND_READY = 9;
    private static final int SST_SENDING = 10;
    private static final int SST_SEND_TIMEOUT = 11;
    private static final int SST_SEND_FAILED = 12;
    private static final int SST_RECV_FAILED = 13;
    private static final int CST_SHUTDOWN = 14;
    private static final String[] _cst_states = new String[]{"<init>", "<connecting>", "<con_timeout>", "<con_failed>", "<connected>", "<prot_start>", "<prot_timeout>", "<prot_failed>", "<prot_ok>", "<send_ready>", "<sending>", "<send_timeout>", "<send_failed>", "<recv_failed>"};

    public RetryTunnel(String cellName, Socket socket) {
        this._mode = "Accepted";
        this._socket = socket;
        this._nucleus = new CellNucleus(this, cellName);
        this._engine = new StateThread(this);
        this._engine.start();
    }

    public RetryTunnel(String cellName, String argString) throws UnknownHostException {
        Args args = new Args(argString);
        if (args.argc() < 2) {
            throw new IllegalArgumentException("Usage : RetryTunnel <host> <port>");
        }
        this._RetryTunnel(cellName, args.argv(0), new Integer(args.argv(1)));
    }

    public RetryTunnel(String cellName, String host, int port) throws UnknownHostException {
        this(cellName, InetAddress.getByName(host), port);
    }

    private void _RetryTunnel(String cellName, String host, int port) throws UnknownHostException {
        this._mode = "Connection";
        this._address = InetAddress.getByName(host);
        this._port = port;
        this._nucleus = new CellNucleus(this, cellName);
        this._engine = new StateThread(this);
        this._engine.start();
    }

    public RetryTunnel(String cellName, InetAddress address, int port) {
        this._mode = "Connection";
        this._address = address;
        this._port = port;
        this._nucleus = new CellNucleus(this, cellName);
        this._engine = new StateThread(this);
        this._engine.start();
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._receiverThread) {
            block4: while (true) {
                try {
                    Object obj;
                    while ((obj = this._input.readObject()) != null && !Thread.interrupted()) {
                        CellMessage msg = (CellMessage)obj;
                        _log.info("receiverThread : Message from tunnel : " + msg);
                        try {
                            this._nucleus.sendMessage(msg);
                            ++this._messagesToSystem;
                            continue block4;
                        }
                        catch (NoRouteToCellException nrtce) {
                            _log.info("receiverThread : Exception in sendMessage : " + nrtce);
                        }
                    }
                    break;
                }
                catch (Exception ioe) {
                    _log.info("receiverThread : Exception in readObject : " + ioe);
                    if (this._mode.equals("Connection")) {
                        this._engine.setState(13);
                        break;
                    }
                    _log.info("receiverThread : Initiating kill sequence... ");
                    this._nucleus.kill();
                    break;
                }
            }
        }
    }

    private String _printState() {
        int state = this._engine.getState();
        if (state < 0 || state >= _cst_states.length) {
            return "<Unknown>";
        }
        return _cst_states[state];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runState(int state) {
        long now = new Date().getTime();
        _log.info(" runState : " + this._printState());
        switch (state) {
            case 0: {
                if (this._mode.equals("Connection")) {
                    return 1;
                }
                if (this._mode.equals("Accepted")) {
                    return 4;
                }
                return -1;
            }
            case 1: {
                this._engine.setState(1, 20, 2);
                this._connectionStarted = now;
                try {
                    ++this._connectionRequests;
                    this._socket = new Socket(this._address, this._port);
                    this._engine.setState(4);
                }
                catch (Exception se) {
                    this._engine.setState(3);
                }
                break;
            }
            case 3: {
                if (this._mode.equals("Accepted")) {
                    return 14;
                }
            }
            case 2: {
                int diff = (int)(now - this._connectionStarted);
                diff = 30 - diff;
                if (diff > 0) {
                    try {
                        Thread.sleep(diff * 1000);
                    }
                    catch (Exception se) {
                        // empty catch block
                    }
                }
                ++this._connectionRetries;
                return 1;
            }
            case 4: {
                this._engine.setState(5, 20, 6);
                try {
                    this._makeStreams();
                    this._engine.setState(8);
                }
                catch (Exception mse) {
                    this._engine.setState(7);
                }
                break;
            }
            case 6: 
            case 7: {
                try {
                    this._socket.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
                return 3;
            }
            case 8: {
                Object ce = this._receiverLock;
                synchronized (ce) {
                    if (this._receiverThread != null) {
                        this._receiverThread.interrupt();
                    }
                    this._receiverThread = new Thread(this);
                    this._receiverThread.start();
                    this._route = new CellRoute(this._remoteDomainInfo.getCellDomainName(), this._nucleus.getCellName(), 3);
                    this._nucleus.routeAdd(this._route);
                    _log.info(" engine : Route added : " + this._route);
                }
                return 9;
            }
            case 9: {
                Object msg = this._messageArrivedQueue.poll();
                this._engine.setState(10, 10, 11);
                try {
                    this._output.writeObject(msg);
                    this._output.flush();
                    this._output.reset();
                    ++this._messagesToTunnel;
                    this._engine.setState(9);
                }
                catch (Exception we) {
                    this._engine.setState(12);
                }
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                try {
                    this._socket.close();
                }
                catch (IOException ce) {
                    // empty catch block
                }
                this.removeRoute();
                return 3;
            }
            case 14: {
                this._nucleus.kill();
                return -1;
            }
        }
        return 0;
    }

    @Override
    public CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this._nucleus.getCellName(), this._nucleus.getCellDomainInfo(), this._remoteDomainInfo);
    }

    private void _makeStreams() throws Exception {
        this._output = new ObjectOutputStream(this._socket.getOutputStream());
        if (this._output == null) {
            throw new IOException("OutputStream == null");
        }
        this._input = new ObjectInputStream(this._socket.getInputStream());
        if (this._input == null) {
            this._output.close();
            throw new IOException("InputStream == null");
        }
        this._output.writeObject(this._nucleus.getCellDomainInfo());
        Object obj = this._input.readObject();
        if (obj == null) {
            throw new IOException("Premature EOS encountered");
        }
        this._remoteDomainInfo = (CellDomainInfo)obj;
    }

    public String toString() {
        if (this._remoteDomainInfo == null) {
            return "M=" + this._mode + ";S=" + this._printState();
        }
        return "M=" + this._mode + ";S=" + this._printState() + ";P=" + this._remoteDomainInfo.getCellDomainName();
    }

    @Override
    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Simple Tunnel : " + this._nucleus.getCellName() + "\n");
        sb.append("Mode          : " + this._mode + "\n");
        sb.append("Status        : " + this._printState() + "\n");
        sb.append("con. Requests : " + this._connectionRequests + "\n");
        sb.append("Msg Queued    : " + this._messageArrivedQueue.size() + "\n");
        sb.append("-> Tunnel     : " + this._messagesToTunnel + "\n");
        sb.append("-> Domain     : " + this._messagesToSystem + "\n");
        if (this._remoteDomainInfo == null) {
            sb.append("Peer          : N.N.\n");
        } else {
            sb.append("Peer          : " + this._remoteDomainInfo.getCellDomainName() + "\n");
        }
        return sb.toString();
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            CellMessage msg = me.getMessage();
            _log.info("messageArrived : queuing " + msg);
            try {
                this._messageArrivedQueue.put(msg);
            }
            catch (InterruptedException interruptedException) {}
        } else if (me instanceof LastMessageEvent) {
            _log.info("messageArrived : opening final gate");
            this._finalGate.open();
        } else {
            _log.info("messageArrived : dumping junk message " + me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoute() {
        Object object = this._receiverLock;
        synchronized (object) {
            if (this._route != null) {
                _log.info("removeRoute : removing route");
                this._nucleus.routeDelete(this._route);
                this._route = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepareRemoval(KillEvent ce) {
        _log.info("prepareRemoval : initiated " + ce);
        _log.info("prepareRemoval : waiting for final Gate to open");
        this._finalGate.check();
        _log.info("prepareRemoval : final gate passed -> closing");
        this._engine.stop();
        Object object = this._receiverLock;
        synchronized (object) {
            if (this._receiverThread != null) {
                this._receiverThread.interrupt();
            }
            this.removeRoute();
        }
        try {
            this._input.close();
            this._output.close();
            this._socket.close();
        }
        catch (Exception nsea) {
            _log.info("prepareRemoval : Problem while closing : " + nsea);
        }
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info("exceptionArrived : " + ce);
    }
}

