/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellExceptionMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.util.Args;
import dmg.util.StreamEngine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMgrTunnel
extends CellAdapter
implements CellTunnel,
Runnable {
    private static final Tunnels _tunnels = new Tunnels();
    private static final Logger _log = LoggerFactory.getLogger(LocationMgrTunnel.class);
    private static final Logger _logMessages = LoggerFactory.getLogger((String)"logger.org.dcache.cells.messages");
    private final CellNucleus _nucleus;
    private CellDomainInfo _remoteDomainInfo;
    private final Socket _socket;
    private final ObjectInputStream _input;
    private final ObjectOutputStream _output;
    private boolean _down = false;
    private int _messagesToTunnel = 0;
    private int _messagesToSystem = 0;

    public LocationMgrTunnel(String cellName, StreamEngine engine, Args args) throws IOException {
        super(cellName, "System", args, false);
        try {
            this._nucleus = this.getNucleus();
            this._socket = engine.getSocket();
            this._socket.setTcpNoDelay(true);
            this._output = new ObjectOutputStream(new BufferedOutputStream(engine.getOutputStream()));
            this._output.flush();
            this._input = new ObjectInputStream(new BufferedInputStream(engine.getInputStream()));
        }
        catch (IOException e) {
            this.start();
            this.kill();
            throw e;
        }
        this.getNucleus().newThread(this, "Tunnel").start();
    }

    private CellDomainInfo negotiateDomainInfo(ObjectOutputStream out, ObjectInputStream in) throws IOException {
        try {
            this.send(this._nucleus.getCellDomainInfo());
            Object obj = in.readObject();
            if (obj == null) {
                throw new IOException("EOS encountered while reading DomainInfo");
            }
            return (CellDomainInfo)obj;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot deserialize object. This is most likely due to a version mismatch.");
        }
    }

    private synchronized void setDown(boolean down) {
        this._down = down;
        this.notifyAll();
    }

    private synchronized boolean isDown() {
        return this._down;
    }

    private void logSend(CellMessage msg) {
        if (_logMessages.isDebugEnabled()) {
            Object object = msg.getMessageObject();
            String messageObject = object == null ? "NULL" : object.getClass().getName();
            _logMessages.debug("tunnelMessageSent src=" + msg.getSourceAddress() + " dest=" + msg.getDestinationAddress() + " [" + messageObject + "] UOID=" + msg.getUOID().toString());
        }
    }

    private void logReceive(CellMessage msg) {
        if (_logMessages.isDebugEnabled()) {
            Object object = msg.getMessageObject();
            String messageObject = object == null ? "NULL" : object.getClass().getName();
            _logMessages.debug("tunnelMessageReceived src=" + msg.getSourceAddress() + " dest=" + msg.getDestinationAddress() + " [" + messageObject + "] UOID=" + msg.getUOID().toString());
        }
    }

    private void returnToSender(CellMessage msg, NoRouteToCellException e) throws SerializationException {
        try {
            if (!(msg instanceof CellExceptionMessage)) {
                CellPath retAddr = (CellPath)msg.getSourcePath().clone();
                retAddr.revert();
                CellExceptionMessage ret = new CellExceptionMessage(retAddr, e);
                ret.setLastUOID(msg.getUOID());
                this._nucleus.sendMessage(ret);
            }
        }
        catch (NoRouteToCellException f) {
            _log.warn("Unable to deliver message and unable to return it to sender: " + msg);
        }
    }

    private void receive() throws InterruptedException, IOException, ClassNotFoundException {
        CellMessage msg;
        while ((msg = (CellMessage)this._input.readObject()) != null) {
            this.logReceive(msg);
            try {
                this.sendMessage(msg);
                ++this._messagesToSystem;
            }
            catch (NoRouteToCellException e) {
                this.returnToSender(msg, e);
            }
        }
    }

    private void send(Object msg) throws IOException {
        if (this.isDown()) {
            throw new IOException("Tunnel has been shut down.");
        }
        this._output.writeObject(msg);
        this._output.reset();
        this._output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isDown()) {
            throw new IllegalStateException("Tunnel has already been closed");
        }
        try {
            this._remoteDomainInfo = this.negotiateDomainInfo(this._output, this._input);
            _log.info("Established tunnel to " + this.getRemoteDomainName());
            this.start();
            _tunnels.add(this);
            try {
                this.receive();
            }
            finally {
                _tunnels.remove(this);
            }
        }
        catch (EOFException e) {
        }
        catch (ClassNotFoundException e) {
            _log.warn("Cannot deserialize object. This is most likely due to a version mismatch.");
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            _log.warn("Error while reading from tunnel: " + e.getMessage());
        }
        finally {
            this.start();
            this.kill();
        }
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            CellMessage msg = me.getMessage();
            try {
                this.logSend(msg);
                ++this._messagesToTunnel;
                this.send(msg);
            }
            catch (IOException e) {
                _log.warn("Error while sending message: " + e.getMessage());
                this.returnToSender(msg, new NoRouteToCellException("Communication failure. Message could not be delivered."));
                this.kill();
            }
        } else {
            super.messageArrived(me);
        }
    }

    @Override
    public CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this.getCellName(), this._nucleus.getCellDomainInfo(), this._remoteDomainInfo);
    }

    protected String getRemoteDomainName() {
        return this._remoteDomainInfo == null ? "" : this._remoteDomainInfo.getCellDomainName();
    }

    @Override
    public String toString() {
        return "Connected to " + this.getRemoteDomainName();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Location Mgr Tunnel : " + this.getCellName());
        pw.println("-> Tunnel     : " + this._messagesToTunnel);
        pw.println("-> Domain     : " + this._messagesToSystem);
        pw.println("Peer          : " + this.getRemoteDomainName());
    }

    @Override
    public void cleanUp() {
        _log.info("Closing tunnel to " + this.getRemoteDomainName());
        this.setDown(true);
        try {
            this._socket.shutdownInput();
            this._socket.close();
        }
        catch (IOException e) {
            _log.warn("Failed to close socket: " + e.getMessage());
        }
    }

    public synchronized void join() throws InterruptedException {
        while (!this.isDown()) {
            this.wait();
        }
    }

    static class Tunnels {
        private Map<String, LocationMgrTunnel> _tunnels = new HashMap<String, LocationMgrTunnel>();

        Tunnels() {
        }

        public synchronized void add(LocationMgrTunnel tunnel) throws InterruptedException {
            LocationMgrTunnel old;
            CellNucleus nucleus = tunnel.getNucleus();
            if (this._tunnels.containsValue(tunnel)) {
                throw new IllegalArgumentException("Cannot register the same tunnel twice");
            }
            String domain = tunnel.getRemoteDomainName();
            while ((old = this._tunnels.get(domain)) != null) {
                old.kill();
                this.wait();
            }
            CellRoute route = new CellRoute(domain, tunnel.getCellName(), 3);
            try {
                nucleus.routeAdd(route);
            }
            catch (IllegalArgumentException e) {
                nucleus.routeDelete(route);
                nucleus.routeAdd(route);
            }
            this._tunnels.put(domain, tunnel);
            this.notifyAll();
        }

        public synchronized void remove(LocationMgrTunnel tunnel) {
            CellNucleus nucleus = tunnel.getNucleus();
            String domain = tunnel.getRemoteDomainName();
            if (this._tunnels.get(domain) == tunnel) {
                this._tunnels.remove(domain);
                nucleus.routeDelete(new CellRoute(domain, tunnel.getCellName(), 3));
                this.notifyAll();
            }
        }
    }
}

