/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.BorderPanel;
import dmg.cells.applets.spy.ContextPanel;
import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.DomainPanel;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.applets.spy.RoutingPanel;
import dmg.cells.applets.spy.SpyList;
import dmg.cells.applets.spy.TopologyPanel;
import dmg.cells.network.CellDomainNode;
import dmg.cells.services.MessageObjectFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.TreeSet;

class DomainListPanel
extends Panel
implements ActionListener,
FrameArrivable,
ItemListener {
    private DomainConnection _connection;
    private Button _updateButton;
    private Button _topoButton;
    private Button _detailButton;
    private Button _contextButton;
    private Button _routingButton;
    private SpyList _list;
    private DomainPanel _domainPanel;
    private ContextPanel _contextPanel;
    private RoutingPanel _routingPanel;
    private CardLayout _cards = new CardLayout();
    private Panel _cardPanel;
    private TopologyPanel _topoPanel;
    private String _domainMode = "domain";
    private boolean _useColor = false;
    private CellDomainNode[] _nodes = new CellDomainNode[0];

    DomainListPanel(DomainConnection connection) {
        this._useColor = System.getProperty("bw") == null;
        this._connection = connection;
        this.setLayout(new BorderLayout());
        if (this._useColor) {
            this.setBackground(Color.blue);
        }
        LeftPanel leftPanel = new LeftPanel();
        this.add((Component)new BorderPanel(leftPanel), "West");
        this._domainPanel = new DomainPanel(this._connection);
        this._topoPanel = new TopologyPanel();
        this._contextPanel = new ContextPanel(this._connection);
        this._routingPanel = new RoutingPanel(this._connection);
        this._cardPanel = new Panel(this._cards);
        this._cardPanel.add((Component)new BorderPanel(this._domainPanel), "domain");
        this._cardPanel.add((Component)new BorderPanel(this._topoPanel), "topo");
        this._cardPanel.add((Component)new BorderPanel(this._contextPanel), "context");
        this._cardPanel.add((Component)new BorderPanel(this._routingPanel), "routing");
        this._cards.show(this._cardPanel, "topo");
        this.add((Component)this._cardPanel, "Center");
        this._list.addItemListener(this);
        this._updateButton.addActionListener(this);
        this._topoButton.addActionListener(this);
        this._detailButton.addActionListener(this);
        this._contextButton.addActionListener(this);
        this._routingButton.addActionListener(this);
        this._topoPanel.addActionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Color base = Color.red;
        for (int i = 0; i < 4; ++i) {
            g.setColor(base);
            g.drawRect(i, i, d.width - 2 * i - 1, d.height - 2 * i - 1);
            base = base.darker();
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this._updateButton) {
            this._connection.send("topo", "gettopomap", this);
            this._domainPanel.clear();
            this._routingPanel.clear();
            this._contextPanel.clear();
            this._detailButton.setEnabled(false);
            this._routingButton.setEnabled(false);
            this._contextButton.setEnabled(false);
        } else if (o == this._detailButton) {
            this._domainMode = "domain";
            this._cards.show(this._cardPanel, this._domainMode);
        } else if (o == this._topoPanel) {
            this._list.select(event.getActionCommand());
            this.displayDomain(event.getActionCommand());
        } else if (o == this._contextButton) {
            this._domainMode = "context";
            this._cards.show(this._cardPanel, this._domainMode);
        } else if (o == this._routingButton) {
            this._domainMode = "routing";
            this._cards.show(this._cardPanel, this._domainMode);
        } else if (o == this._topoButton) {
            this._cards.show(this._cardPanel, "topo");
        }
    }

    @Override
    public void frameArrived(MessageObjectFrame frame) {
        Object obj = frame.getObject();
        this._list.removeAll();
        if (!(obj instanceof CellDomainNode[])) {
            return;
        }
        this._nodes = (CellDomainNode[])obj;
        TreeSet<String> sorted = new TreeSet<String>();
        for (int i = 0; i < this._nodes.length; ++i) {
            sorted.add(this._nodes[i].getName());
        }
        Iterator i = sorted.iterator();
        while (i.hasNext()) {
            this._list.add((String)i.next());
        }
        this._topoPanel.setTopology(this._nodes);
        this._cards.show(this._cardPanel, "topo");
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ItemSelectable sel = event.getItemSelectable();
        Object[] obj = sel.getSelectedObjects();
        if (obj == null || obj.length == 0) {
            return;
        }
        this.displayDomain(obj[0].toString());
    }

    private void displayDomain(String domainName) {
        int i;
        for (i = 0; i < this._nodes.length && !this._nodes[i].getName().equals(domainName); ++i) {
        }
        if (i == this._nodes.length) {
            System.out.println("No more in list : " + domainName);
            return;
        }
        this._domainPanel.showDomain(this._nodes[i]);
        this._contextPanel.showDomain(this._nodes[i]);
        this._routingPanel.showDomain(this._nodes[i]);
        this._cards.show(this._cardPanel, this._domainMode);
        this._detailButton.setEnabled(true);
        this._routingButton.setEnabled(true);
        this._contextButton.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable) {
            this._connection.send("topo", "gettopomap", this);
        } else {
            this._topoPanel.setTopology(new CellDomainNode[0]);
            this._cards.show(this._cardPanel, "topo");
            this._list.removeAll();
        }
        this._detailButton.setEnabled(false);
        this._routingButton.setEnabled(false);
        this._contextButton.setEnabled(false);
        this._updateButton.setEnabled(enable);
        this._topoButton.setEnabled(enable);
    }

    private class LeftPanel
    extends Panel {
        private LeftPanel() {
            super(new BorderLayout());
            Label label = new Label("Domain List", 1);
            label.setFont(new Font("fixed", 2, 18));
            DomainListPanel.this._list = new SpyList();
            DomainListPanel.this._updateButton = new Button("Update Domain List");
            DomainListPanel.this._topoButton = new Button("Topology");
            DomainListPanel.this._detailButton = new Button("Domain Detail");
            DomainListPanel.this._contextButton = new Button("Domain Contex");
            DomainListPanel.this._routingButton = new Button("Domain Routing");
            this.add((Component)label, "North");
            this.add((Component)DomainListPanel.this._list, "Center");
            Panel buttonPanel = new Panel(new GridLayout(0, 1));
            buttonPanel.add(DomainListPanel.this._updateButton);
            buttonPanel.add(DomainListPanel.this._topoButton);
            buttonPanel.add(DomainListPanel.this._detailButton);
            buttonPanel.add(DomainListPanel.this._contextButton);
            buttonPanel.add(DomainListPanel.this._routingButton);
            this.add((Component)buttonPanel, "South");
            if (DomainListPanel.this._useColor) {
                this.setBackground(Color.yellow);
            }
        }

        @Override
        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }
    }
}

