/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.LinkPair;
import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellTunnelInfo;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class CanonTopo {
    private String[] _domainNames;
    private LinkPair[] _linkPairs;

    public CanonTopo() {
    }

    public CanonTopo(CellDomainNode[] in) {
        this._domainNames = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            this._domainNames[i] = in[i].getName();
        }
        this._sort(this._domainNames);
        Hashtable<String, Integer> nameHash = new Hashtable<String, Integer>();
        for (int i = 0; i < in.length; ++i) {
            nameHash.put(this._domainNames[i], i);
        }
        Hashtable<LinkPair, LinkPair> linkHash = new Hashtable<LinkPair, LinkPair>();
        for (int i = 0; i < in.length; ++i) {
            String thisDomain = in[i].getName();
            int thisPosition = (Integer)nameHash.get(thisDomain);
            CellTunnelInfo[] links = in[i].getLinks();
            if (links == null) continue;
            for (int j = 0; j < links.length; ++j) {
                CellDomainInfo info = links[j].getRemoteCellDomainInfo();
                if (info == null) continue;
                String thatDomain = info.getCellDomainName();
                int thatPosition = (Integer)nameHash.get(thatDomain);
                LinkPair pair = new LinkPair(thisPosition, thatPosition);
                linkHash.put(pair, pair);
            }
        }
        this._linkPairs = new LinkPair[linkHash.size()];
        Enumeration e = linkHash.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this._linkPairs[i] = (LinkPair)e.nextElement();
            ++i;
        }
        this._sort(this._linkPairs);
    }

    public int links() {
        return this._linkPairs.length;
    }

    public int domains() {
        return this._domainNames.length;
    }

    public String getDomain(int i) {
        return this._domainNames[i];
    }

    public LinkPair getLinkPair(int i) {
        return this._linkPairs[i];
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CanonTopo)) {
            return false;
        }
        CanonTopo topo = (CanonTopo)other;
        return Arrays.equals(this._domainNames, topo._domainNames) && Arrays.equals(this._linkPairs, topo._linkPairs);
    }

    public int hashCode() {
        return Arrays.hashCode(this._domainNames) ^ Arrays.hashCode(this._linkPairs);
    }

    private void _sort(LinkPair[] x) {
        if (x.length < 2) {
            return;
        }
        for (int j = 1; j < x.length; ++j) {
            for (int i = 0; i < x.length - 1; ++i) {
                if (x[i].compareTo(x[i + 1]) <= 0) continue;
                LinkPair y = x[i];
                x[i] = x[i + 1];
                x[i + 1] = y;
            }
        }
    }

    private void _sort(String[] x) {
        if (x.length < 2) {
            return;
        }
        for (int j = 1; j < x.length; ++j) {
            for (int i = 0; i < x.length - 1; ++i) {
                if (x[i].compareTo(x[i + 1]) <= 0) continue;
                String y = x[i];
                x[i] = x[i + 1];
                x[i + 1] = y;
            }
        }
    }

    public static void main(String[] args) {
        LinkPair[] linkPairs = new LinkPair[4];
        CanonTopo x = new CanonTopo();
        int pos = 0;
        linkPairs[pos++] = new LinkPair(1, 10);
        linkPairs[pos++] = new LinkPair(4, 5);
        linkPairs[pos++] = new LinkPair(7, 10);
        linkPairs[pos++] = new LinkPair(1, 10);
        x._sort(linkPairs);
        Hashtable<LinkPair, LinkPair> hash = new Hashtable<LinkPair, LinkPair>();
        for (int i = 0; i < linkPairs.length; ++i) {
            System.out.println(" " + i + " " + linkPairs[i]);
            hash.put(linkPairs[i], linkPairs[i]);
        }
        System.out.println(" hash entries : " + hash.size());
    }

    public static void main2(String[] args) {
        CanonTopo x = new CanonTopo();
        x._sort(args);
        for (int i = 0; i < args.length; ++i) {
            System.out.println(" --> " + args[i]);
        }
    }
}

