/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.login;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.applets.login.DomainEventListener;
import dmg.cells.applets.login.DomainObjectFrame;
import dmg.cells.applets.login.HelloPanel;
import dmg.cells.applets.login.SshActionPanel;
import dmg.cells.applets.login.SshLoginFPPanel;
import dmg.cells.applets.login.SshLoginOKPanel;
import dmg.protocols.ssh.SshAuthMethod;
import dmg.protocols.ssh.SshAuthPassword;
import dmg.protocols.ssh.SshClientAuthentication;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshSharedKey;
import dmg.protocols.ssh.SshStreamEngine;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SshLoginPanel
extends SshActionPanel
implements ActionListener,
Runnable,
SshClientAuthentication,
DomainConnection {
    private CardLayout _cardsLayout;
    private SshLoginFPPanel _fpPanel;
    private HelloPanel _lgPanel;
    private SshLoginOKPanel _okPanel;
    private Thread _connectionThread = null;
    private Thread _timeoutThread = null;
    private Thread _receiverThread = null;
    private boolean _hostKeyOk = true;
    private String _remoteHost = null;
    private String _remotePort = null;
    private String _remoteUser = null;
    private String _remotePassword = null;
    private int _b = 10;
    private int _requestCounter = 0;
    private long _timeout = 20000L;
    private ObjectInputStream _objIn = null;
    private ObjectOutputStream _objOut = null;
    private final Object _threadLock = new Object();
    private Socket _socket = null;
    private static final String[] __panels = new String[]{"login", "fp", "ok"};
    private static final int ST_IDLE = 0;
    private static final int ST_ACCEPT = 1;
    private static final int ST_REJECT = 2;
    private static final int ST_WAITING_FOR_OK = 3;
    private static final int ST_OK = 4;
    private static final int ST_TIMEOUT = 6;
    private int _status = 0;
    private Hashtable _packetHash = new Hashtable();
    private final Object _ioLock = new Object();
    private int _ioCounter = 100;
    private Vector _listener = new Vector();
    private boolean _connected = false;

    public SshLoginPanel() {
        this._cardsLayout = new CardLayout();
        this.setLayout(this._cardsLayout);
        this.setBackground(Color.white);
        this._lgPanel = new HelloPanel("Welcome to EuroStore");
        this.add((Component)this._lgPanel, "login");
        this._fpPanel = new SshLoginFPPanel();
        this.add((Component)this._fpPanel, "fp");
        this._okPanel = new SshLoginOKPanel();
        this.add((Component)this._okPanel, "ok");
        this._lgPanel.addActionListener(this);
        this._fpPanel.addActionListener(this);
        this._okPanel.addActionListener(this);
        this._cardsLayout.show(this, "login");
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread current = Thread.currentThread();
        if (current == this._connectionThread) {
            try {
                this.runConnectionProtocol();
                Object object = this._threadLock;
                synchronized (object) {
                    System.out.println("ST_OK -> notify");
                    this._status = 4;
                    this._threadLock.notifyAll();
                }
                this._receiverThread = new Thread(this);
                this._receiverThread.start();
                this.informActionListeners("connected");
                this.informListenersOpened();
            }
            catch (Exception rcpe) {
                System.out.println("Trying to close socket");
                try {
                    this._socket.close();
                }
                catch (Exception eeee) {
                    System.out.println("Socket close : " + eeee);
                }
                rcpe.printStackTrace();
                System.err.println("runConnectionProtocol failed : " + rcpe);
                this._cardsLayout.show(this, "login");
                this._lgPanel.setEnabled(true);
                this._lgPanel.setText("Not connected : Login Failed");
                Object eeee = this._threadLock;
                synchronized (eeee) {
                    System.out.println("ST_IDLE -> notify");
                    this._status = 0;
                    this._threadLock.notifyAll();
                }
            }
            System.out.println("!!! Connection Thread finished");
        } else if (current == this._timeoutThread) {
            Object object = this._threadLock;
            synchronized (object) {
                this._connectionThread.start();
                long start = System.currentTimeMillis();
                long rest = this._timeout;
                while (rest > 0L && this._status != 4) {
                    try {
                        this._threadLock.wait(rest);
                    }
                    catch (InterruptedException ie) {
                        System.out.println("isHostKey was interrupted");
                        break;
                    }
                    rest = this._timeout - (System.currentTimeMillis() - start);
                }
                if (this._status != 4) {
                    this._connectionThread.interrupt();
                    this._cardsLayout.show(this, "login");
                    this._lgPanel.setEnabled(true);
                    this._status = 0;
                    this._threadLock.notifyAll();
                    System.out.println("ST_TIMEOUT -> notify");
                }
                this._timeoutThread = null;
            }
            System.out.println("!!! Timeout Thread finished");
        } else if (current == this._receiverThread) {
            this.runReceiver();
            System.out.println("!!! Receiver Thread finished");
            this._cardsLayout.show(this, "login");
            this._lgPanel.setEnabled(true);
        }
    }

    private void runConnectionProtocol() throws Exception {
        int port = Integer.parseInt(this._remotePort);
        this._socket = new Socket(this._remoteHost, port);
        SshStreamEngine engine = new SshStreamEngine(this._socket, this);
        PrintWriter writer = new PrintWriter(engine.getWriter());
        BufferedReader reader = new BufferedReader(engine.getReader());
        System.out.println("sending binary");
        writer.println("$BINARY$");
        writer.flush();
        String check = null;
        while (!(check = reader.readLine()).equals("$BINARY$")) {
        }
        System.out.println("Binary ack.");
        this._objOut = new ObjectOutputStream(engine.getOutputStream());
        this._objIn = new ObjectInputStream(engine.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        System.out.println("Action x : " + command);
        Object obj = event.getSource();
        if (obj == this._lgPanel) {
            if (command.equals("go")) {
                this._lgPanel.setEnabled(false);
                this._remoteUser = this._lgPanel.getUser();
                this._remotePassword = this._lgPanel.getPassword();
                this._remoteHost = this._lgPanel.getHost();
                this._remotePort = this._lgPanel.getPort();
                Object object = this._threadLock;
                synchronized (object) {
                    this._connectionThread = new Thread(this);
                    this._timeoutThread = new Thread(this);
                    this._timeoutThread.start();
                }
            } else if (command.equals("exit")) {
                System.exit(4);
            }
        } else if (obj == this._okPanel) {
            try {
                this._socket.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            this._cardsLayout.show(this, "login");
            this._lgPanel.setEnabled(true);
        } else if (obj == this._fpPanel) {
            if (command.equals("accept")) {
                this._cardsLayout.show(this, "ok");
                Object object = this._threadLock;
                synchronized (object) {
                    System.out.println("ST_ACCEPT -> notify");
                    this._status = 1;
                    this._threadLock.notifyAll();
                }
            }
            if (command.equals("reject")) {
                this._cardsLayout.show(this, "login");
                Object object = this._threadLock;
                synchronized (object) {
                    System.out.println("ST_REJECT -> notify");
                    this._status = 2;
                    this._threadLock.notifyAll();
                }
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.getMinimumSize();
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = this.getMinimumSize();
        return d;
    }

    public void ok() {
        this._lgPanel.ok();
    }

    public void logout() {
        try {
            this._objOut.write(4);
            this._objOut.flush();
        }
        catch (IOException e) {
            System.err.println("_objOut.write( 4 ) : " + e);
            e.printStackTrace();
        }
        try {
            if (this._timeoutThread != null) {
                this._timeoutThread.interrupt();
            }
        }
        catch (Exception e) {
            System.err.println("_timeoutThread : " + e);
            e.printStackTrace();
        }
        try {
            if (this._receiverThread != null) {
                this._receiverThread.interrupt();
            }
        }
        catch (Exception e) {
            System.err.println("_receiverThread : " + e);
            e.printStackTrace();
        }
        try {
            if (this._connectionThread != null) {
                this._connectionThread.interrupt();
            }
        }
        catch (Exception e) {
            System.err.println("_connectionThread : " + e);
            e.printStackTrace();
        }
        this._lgPanel.setEnabled(true);
        System.out.println("Logout requested");
    }

    public void setHost(String host, boolean visible, boolean changable) {
        this._lgPanel.setHost(host, visible, changable);
    }

    public void setPort(String port, boolean visible, boolean changable) {
        this._lgPanel.setPort(port, visible, changable);
    }

    public void setUser(String user, boolean visible, boolean changable) {
        this._lgPanel.setUser(user, visible, changable);
    }

    public void setTitle(String title) {
        this._lgPanel.setTitle(title);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this._b, this._b, this._b, this._b);
    }

    @Override
    public String getAuthenticatedUser() {
        return this._remoteUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendObject(Object obj, DomainConnectionListener listener, int id) throws IOException {
        Object object = this._ioLock;
        synchronized (object) {
            DomainObjectFrame frame = new DomainObjectFrame(obj, ++this._ioCounter, id);
            this._objOut.writeObject(frame);
            this._objOut.reset();
            this._packetHash.put(frame, listener);
            return this._ioCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendObject(String destination, Object obj, DomainConnectionListener listener, int id) throws IOException {
        Object object = this._ioLock;
        synchronized (object) {
            DomainObjectFrame frame = new DomainObjectFrame(destination, obj, ++this._ioCounter, id);
            this._objOut.writeObject(frame);
            this._objOut.reset();
            this._packetHash.put(frame, listener);
            return this._ioCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDomainEventListener(DomainEventListener listener) {
        Object object = this._ioLock;
        synchronized (object) {
            this._listener.addElement(listener);
            if (this._connected) {
                try {
                    listener.connectionOpened(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDomainEventListener(DomainEventListener listener) {
        Object object = this._ioLock;
        synchronized (object) {
            this._listener.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListenersOpened() {
        Object object = this._ioLock;
        synchronized (object) {
            this._connected = true;
            Vector v = (Vector)this._listener.clone();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                DomainEventListener listener = (DomainEventListener)e.nextElement();
                try {
                    listener.connectionOpened(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListenersClosed() {
        Object object = this._ioLock;
        synchronized (object) {
            this._connected = false;
            Vector v = (Vector)this._listener.clone();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                DomainEventListener listener = (DomainEventListener)e.nextElement();
                try {
                    listener.connectionClosed(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private void runReceiver() {
        Object obj = null;
        DomainObjectFrame frame = null;
        DomainConnectionListener listener = null;
        while (true) {
            block8: {
                try {
                    obj = this._objIn.readObject();
                    if (obj == null) {
                    }
                    break block8;
                }
                catch (Exception ioe) {
                    System.err.println("readObject failed : " + ioe);
                }
                break;
            }
            if (!(obj instanceof DomainObjectFrame) || (listener = (DomainConnectionListener)this._packetHash.remove(frame = (DomainObjectFrame)obj)) == null) continue;
            try {
                listener.domainAnswerArrived(frame.getPayload(), frame.getSubId());
            }
            catch (Exception eee) {
                System.out.println("Problem in domainAnswerArrived : " + eee);
            }
        }
        this.informActionListeners("disconnected");
        this.informListenersClosed();
        try {
            System.out.println("Closing connection");
            this._socket.close();
        }
        catch (Exception ce) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHostKey(InetAddress host, SshRsaKey keyModulus) {
        if (!this._hostKeyOk) {
            this._fpPanel.setFingerPrint(host.getHostName(), keyModulus.getFingerPrint());
            Object object = this._threadLock;
            synchronized (object) {
                this._cardsLayout.show(this, "fp");
                this._status = 3;
                while (this._status == 3) {
                    try {
                        this._threadLock.wait();
                    }
                    catch (InterruptedException ie) {
                        System.out.println("isHostKey was interrupted(will continue)");
                    }
                }
            }
        } else {
            this._status = 1;
        }
        return this._status == 1;
    }

    @Override
    public String getUser() {
        this._requestCounter = 0;
        System.out.println("getUser : " + this._remoteUser);
        return this._remoteUser;
    }

    @Override
    public SshSharedKey getSharedKey(InetAddress host) {
        return null;
    }

    @Override
    public SshAuthMethod getAuthMethod() {
        return this._requestCounter++ > 2 ? null : new SshAuthPassword(this._remotePassword);
    }
}

