/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.login;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.applets.login.SshActionPanel;
import dmg.cells.applets.spy.HistoryTextField;
import dmg.util.Args;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CommanderPanel
extends SshActionPanel
implements ActionListener,
DomainConnectionListener {
    private DomainConnection _dc = null;
    private TextArea _display = null;
    private TextField _input = null;
    private Button _backButton = null;
    private Button _clearButton = null;
    private Panel _optionPanel = null;
    private int _b = 20;
    private Font _font = new Font("TimesRoman", 0, 24);
    private Font _mFont = new Font("Courier", 0, 14);
    CheckboxGroup _checkGroup = null;
    Checkbox _checkString = null;
    Checkbox _checkArgs = null;
    Checkbox _checkArray = null;

    @Override
    public Insets getInsets() {
        return new Insets(this._b, this._b, this._b, this._b);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int h = this._b / 2;
        g.setColor(new Color(0, 0, 0));
        int[] xs = new int[4];
        int[] ys = new int[4];
        xs[0] = h;
        ys[0] = h;
        xs[1] = d.width - h - 1;
        ys[1] = h;
        xs[2] = d.width - h - 1;
        ys[2] = d.height - h - 1;
        xs[3] = h;
        ys[3] = d.height - h - 1;
        g.drawPolygon(xs, ys, xs.length);
    }

    public CommanderPanel(DomainConnection dc) {
        BorderLayout bl = new BorderLayout();
        bl.setHgap(15);
        bl.setVgap(15);
        this.setLayout(bl);
        this.setBackground(new Color(210, 210, 210));
        this._dc = dc;
        this._display = new TextArea();
        this._display.setFont(this._mFont);
        this._input = new HistoryTextField();
        this._optionPanel = new Panel(new FlowLayout(1));
        Panel topPanel = new Panel(new GridLayout(0, 1));
        Label header = new Label("Commander", 1);
        header.setFont(this._font);
        topPanel.add(header);
        Panel buttonPanel = new Panel(new GridLayout(1, 0));
        this._backButton = new Button("Back");
        buttonPanel.add(this._backButton);
        this._clearButton = new Button("Clear Screen");
        buttonPanel.add(this._clearButton);
        this._optionPanel.add(buttonPanel);
        this._optionPanel.add(new Label("Send Command as : "));
        this._checkGroup = new CheckboxGroup();
        this._checkString = new Checkbox("String", this._checkGroup, true);
        this._checkArgs = new Checkbox("Args", this._checkGroup, false);
        this._checkArray = new Checkbox("Array", this._checkGroup, false);
        Panel checkPanel = new Panel(new GridLayout(1, 0));
        checkPanel.add(this._checkString);
        checkPanel.add(this._checkArgs);
        checkPanel.add(this._checkArray);
        this._optionPanel.add(checkPanel);
        this._backButton.addActionListener(this);
        this._clearButton.addActionListener(this);
        this._input.addActionListener(this);
        topPanel.add(this._optionPanel);
        this.add((Component)topPanel, "North");
        this.add((Component)this._display, "Center");
        this.add((Component)this._input, "South");
    }

    @Override
    public synchronized void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        System.out.println("Action CommanderPanel : " + command);
        Object obj = event.getSource();
        if (obj == this._backButton) {
            this.informActionListeners("exit");
        } else if (obj == this._clearButton) {
            this._display.setText("");
        } else if (obj == this._input) {
            String in = this._input.getText();
            if (in.length() == 0) {
                return;
            }
            this._input.setText("");
            System.out.println("Got : " + in);
            this.sendCommand(in);
        }
    }

    private void sendCommand(String in) {
        Checkbox box = this._checkGroup.getSelectedCheckbox();
        Object[] toBeSent = null;
        if (box == this._checkString) {
            toBeSent = in;
        } else if (box == this._checkArgs) {
            toBeSent = new Args(in);
        } else if (box == this._checkArray) {
            Args args = new Args(in);
            Object[] array = new Object[args.argc()];
            for (int i = 0; i < args.argc(); ++i) {
                array[i] = args.argv(i);
            }
            toBeSent = array;
        } else {
            return;
        }
        try {
            this._dc.sendObject(toBeSent, this, 0);
        }
        catch (Exception e) {
            this._display.append("Problem in sendObject : " + e + "\n");
        }
    }

    @Override
    public void domainAnswerArrived(Object obj, int id) {
        this.pp(0, obj);
    }

    private void pp(int p, Object obj) {
        if (obj instanceof Object[]) {
            Object[] ar = (Object[])obj;
            for (int i = 0; i < ar.length; ++i) {
                for (int j = 0; j < p; ++j) {
                    this._display.append("     ");
                }
                this._display.append("[" + i + "]=");
                this.pp(p + 1, ar[i]);
            }
        } else {
            this._display.append(obj.toString() + "\n");
        }
    }
}

