/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdMemoryBackendFactory;
import org.rrd4j.core.RrdNioBackendFactory;
import org.rrd4j.core.RrdSafeFileBackendFactory;

public abstract class RrdBackendFactory {
    private static final Map<String, RrdBackendFactory> factories = new ConcurrentHashMap<String, RrdBackendFactory>();
    private static RrdBackendFactory defaultFactory;

    private static void selectDefaultFactory() {
        RrdBackendFactory.setDefaultFactory("NIO");
    }

    public static RrdBackendFactory getFactory(String name) {
        RrdBackendFactory factory = factories.get(name);
        if (factory != null) {
            return factory;
        }
        throw new IllegalArgumentException("No backend factory found with the name specified [" + name + "]");
    }

    public static void registerFactory(RrdBackendFactory factory) {
        String name = factory.getName();
        if (factories.containsKey(name)) {
            throw new IllegalArgumentException("Backend factory '" + name + "' cannot be registered twice");
        }
        factories.put(name, factory);
    }

    public static void registerAndSetAsDefaultFactory(RrdBackendFactory factory) {
        RrdBackendFactory.registerFactory(factory);
        RrdBackendFactory.setDefaultFactory(factory.getName());
    }

    public static RrdBackendFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(String factoryName) {
        if (RrdBackend.isInstanceCreated()) {
            throw new IllegalStateException("Could not change the default backend factory. This method must be called before the first RRD gets created");
        }
        defaultFactory = RrdBackendFactory.getFactory(factoryName);
    }

    protected abstract RrdBackend open(String var1, boolean var2) throws IOException;

    protected abstract boolean exists(String var1) throws IOException;

    protected abstract boolean shouldValidateHeader(String var1) throws IOException;

    public abstract String getName();

    static {
        RrdFileBackendFactory fileFactory = new RrdFileBackendFactory();
        RrdBackendFactory.registerFactory(fileFactory);
        RrdMemoryBackendFactory memoryFactory = new RrdMemoryBackendFactory();
        RrdBackendFactory.registerFactory(memoryFactory);
        RrdNioBackendFactory nioFactory = new RrdNioBackendFactory();
        RrdBackendFactory.registerFactory(nioFactory);
        RrdSafeFileBackendFactory safeFactory = new RrdSafeFileBackendFactory();
        RrdBackendFactory.registerFactory(safeFactory);
        RrdBackendFactory.selectDefaultFactory();
    }
}

