/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ArrayOfTGroupPermission;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmSetPermissionRequest;
import org.dcache.srm.v2_2.SrmSetPermissionResponse;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TPermissionMode;
import org.dcache.srm.v2_2.TPermissionType;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMSetPermissionClientV2
extends SRMClient {
    private static final String DEFAULT_DUMMY_GROUP_ID = "-";
    private GSSCredential cred = null;
    private GlobusURL surl;
    private String surl_string;
    private ISRM isrm;

    public SRMSetPermissionClientV2(Configuration configuration, GlobusURL surl, String surl_string) {
        super(configuration);
        this.surl = surl;
        this.surl_string = surl_string;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surl;
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        URI uri = new URI(this.surl_string);
        SrmSetPermissionRequest req = new SrmSetPermissionRequest();
        req.setSURL(uri);
        TPermissionType type = TPermissionType.fromString((String)this.configuration.getSetPermissionType());
        req.setPermissionType(type);
        TPermissionMode mode = null;
        if (this.configuration.getSetOwnerPermissionMode() != null) {
            mode = TPermissionMode.fromString((String)this.configuration.getSetOwnerPermissionMode());
        }
        req.setOwnerPermission(mode);
        ArrayOfTGroupPermission arrayOfGroupPermissions = new ArrayOfTGroupPermission();
        TGroupPermission[] grouppermissions = null;
        if (this.configuration.getSetGroupPermissionMode() != null) {
            grouppermissions = new TGroupPermission[]{new TGroupPermission()};
            grouppermissions[0].setMode(TPermissionMode.fromString((String)this.configuration.getSetGroupPermissionMode()));
            grouppermissions[0].setGroupID(DEFAULT_DUMMY_GROUP_ID);
        }
        arrayOfGroupPermissions.setGroupPermissionArray(grouppermissions);
        req.setArrayOfGroupPermissions(arrayOfGroupPermissions);
        TPermissionMode other = null;
        if (this.configuration.getSetOtherPermissionMode() != null) {
            other = TPermissionMode.fromString((String)this.configuration.getSetOtherPermissionMode());
        }
        req.setOtherPermission(other);
        SrmSetPermissionResponse resp = this.isrm.srmSetPermission(req);
        TReturnStatus rs = resp.getReturnStatus();
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            TStatusCode rc = rs.getStatusCode();
            StringBuffer sb = new StringBuffer();
            sb.append("Return code: " + rc.toString() + "\n");
            sb.append("Explanation: " + rs.getExplanation() + "\n");
            System.out.println(sb.toString());
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

