/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmRmRequest;
import org.dcache.srm.v2_2.SrmRmResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMRmClientV2
extends SRMClient {
    private GSSCredential cred = null;
    private GlobusURL[] surls;
    private String[] surl_strings;
    private ISRM isrm;

    public SRMRmClientV2(Configuration configuration, GlobusURL[] surls, String[] surl_strings) {
        super(configuration);
        this.surls = surls;
        this.surl_strings = surl_strings;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surls[0];
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        SrmRmRequest req = new SrmRmRequest();
        URI[] uris = new URI[this.surls.length];
        for (int i = 0; i < this.surls.length; ++i) {
            uris[i] = new URI(this.surl_strings[i]);
        }
        req.setArrayOfSURLs(new ArrayOfAnyURI(uris));
        SrmRmResponse resp = this.isrm.srmRm(req);
        TReturnStatus rs = resp.getReturnStatus();
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            TSURLReturnStatus[] arrayOfStatuses;
            TStatusCode rc = rs.getStatusCode();
            StringBuffer sb = new StringBuffer();
            sb.append("Return code: " + rc.toString() + "\n");
            sb.append("Explanation: " + rs.getExplanation() + "\n");
            if (resp.getArrayOfFileStatuses() != null && (arrayOfStatuses = resp.getArrayOfFileStatuses().getStatusArray()) != null) {
                for (int i = 0; i < arrayOfStatuses.length; ++i) {
                    if (arrayOfStatuses[i] == null) continue;
                    sb.append("file#").append(i).append(" : ");
                    if (arrayOfStatuses[i].getSurl() != null) {
                        sb.append(arrayOfStatuses[i].getSurl());
                    }
                    if (arrayOfStatuses[i].getStatus() != null) {
                        sb.append(", ");
                        sb.append(arrayOfStatuses[i].getStatus().getStatusCode());
                        sb.append(", \"");
                        sb.append(arrayOfStatuses[i].getStatus().getExplanation());
                        sb.append("\"");
                    }
                    sb.append('\n');
                }
            }
            System.out.println(sb.toString());
            System.exit(1);
        }
    }
}

