/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Copier;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import gov.fnal.srm.util.SRMDispatcher;
import gov.fnal.srm.util.SRMV1CopyJob;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.globus.util.GlobusURL;

public class SRMPutClientV1
extends SRMClient
implements Runnable {
    private GlobusURL[] from;
    private GlobusURL[] to;
    private String[] protocols;
    private HashSet<Integer> fileIDs = new HashSet();
    private HashMap<Integer, RequestFileStatus> fileIDsMap = new HashMap();
    private Copier copier;
    private int requestID;
    private Thread hook;

    public SRMPutClientV1(Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
        this.to = to;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    @Override
    public void connect() throws Exception {
        this.connect(this.to[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            this.copier = new Copier(this.urlcopy, this.configuration);
            this.copier.setDebug(this.debug);
            new Thread(this.copier).start();
            int len = this.from.length;
            String[] sources = new String[len];
            long[] sizes = new long[len];
            boolean[] wantperm = new boolean[len];
            Arrays.fill(wantperm, true);
            String[] dests = new String[len];
            for (int i = 0; i < this.from.length; ++i) {
                GlobusURL filesource = this.from[i];
                GlobusURL srmdest = this.to[i];
                int filetype = SRMDispatcher.getUrlType(filesource);
                if ((filetype & 8) == 0) {
                    throw new IOException(" source is not file " + filesource.getURL());
                }
                if ((filetype & 0x80) == 128) {
                    throw new IOException(" source is directory " + filesource.getURL());
                }
                if ((filetype & 0x20) == 0) {
                    throw new IOException(" source is not readable " + filesource.getURL());
                }
                sources[i] = filesource.getPath();
                this.dsay("source file#" + i + " : " + sources[i]);
                File f = new File(sources[i]);
                sizes[i] = f.length();
                dests[i] = srmdest.getURL();
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            RequestStatus rs = this.srm.put(dests, dests, sizes, wantperm, this.protocols);
            if (rs == null) {
                throw new IOException(" null requests status");
            }
            this.requestID = rs.requestId;
            this.dsay(" srm returned requestId = " + rs.requestId);
            try {
                if (rs.state.equals("Failed")) {
                    this.esay("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                    for (int i = 0; i < rs.fileStatuses.length; ++i) {
                        this.edsay("      ====> fileStatus state ==" + rs.fileStatuses[i].state);
                    }
                    throw new IOException("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                }
                if (rs.fileStatuses.length != len) {
                    this.esay("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                    throw new IOException("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                }
                for (int i = 0; i < len; ++i) {
                    Integer fileId = new Integer(rs.fileStatuses[i].fileId);
                    this.fileIDs.add(fileId);
                    this.fileIDsMap.put(fileId, rs.fileStatuses[i]);
                }
                while (!this.fileIDs.isEmpty()) {
                    int i;
                    Iterator<Integer> iter = this.fileIDs.iterator();
                    HashSet<Integer> removeIDs = new HashSet<Integer>();
                    while (iter.hasNext()) {
                        GlobusURL filesource;
                        Integer nextID = iter.next();
                        RequestFileStatus frs = SRMPutClientV1.getFileRequest(rs, nextID);
                        if (frs == null) {
                            throw new IOException("request status does not haveRequestFileStatus fileID = " + nextID);
                        }
                        if (frs.state.equals("Failed")) {
                            removeIDs.add(nextID);
                            GlobusURL surl = new GlobusURL(frs.SURL);
                            filesource = null;
                            if (len == 1) {
                                filesource = this.from[0];
                            } else {
                                for (int i2 = 0; i2 < len; ++i2) {
                                    if (!surl.equals((Object)this.to[i2])) continue;
                                    filesource = this.from[i2];
                                    break;
                                }
                            }
                            this.setReportFailed(filesource, surl, rs.errorMessage);
                            this.esay("copying from  file file " + filesource.getURL() + " to SURL " + frs.SURL + " failed: File Status is \"Failed\"");
                            continue;
                        }
                        if (!frs.state.equals("Ready")) continue;
                        if (frs.TURL == null) {
                            throw new IOException("  TURL not found (check root path in kpwd), fileStatus state ==" + frs.state);
                        }
                        this.say("FileRequestStatus with SURL=" + frs.SURL + " is Ready");
                        this.say("       received TURL=" + frs.TURL);
                        GlobusURL globusTURL = new GlobusURL(frs.TURL);
                        filesource = null;
                        GlobusURL surl = new GlobusURL(frs.SURL);
                        if (len == 1) {
                            filesource = this.from[0];
                        } else {
                            for (int i3 = 0; i3 < len; ++i3) {
                                if (!surl.equals((Object)this.to[i3])) continue;
                                filesource = this.from[i3];
                                break;
                            }
                        }
                        this.setReportFailed(filesource, surl, "received TURL, but did not complete transfer");
                        if (filesource == null) {
                            this.esay("could not find file source for destination SURL " + surl.getURL());
                            throw new IOException("could not find source for destination SURL " + surl);
                        }
                        SRMV1CopyJob job = new SRMV1CopyJob(filesource, globusTURL, this.srm, this.requestID, nextID, this.logger, surl, false, this);
                        this.copier.addCopyJob(job);
                        removeIDs.add(nextID);
                    }
                    this.fileIDs.removeAll(removeIDs);
                    removeIDs = null;
                    if (this.fileIDs.isEmpty()) {
                        Runtime.getRuntime().removeShutdownHook(this.hook);
                        break;
                    }
                    try {
                        int retrytime = rs.retryDeltaTime;
                        if (retrytime <= 0) {
                            retrytime = 1;
                        }
                        this.say("sleeping " + retrytime + " seconds ...");
                        Thread.sleep(retrytime * 1000);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    rs = this.srm.getRequestStatus(this.requestID);
                    if (rs == null) {
                        throw new IOException(" null requests status");
                    }
                    if (rs.fileStatuses.length != len) {
                        this.esay("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                        throw new IOException("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                    }
                    for (i = 0; i < len; ++i) {
                        Integer fileId = new Integer(rs.fileStatuses[i].fileId);
                        this.fileIDsMap.put(fileId, rs.fileStatuses[i]);
                    }
                    if (!rs.state.equals("Failed")) continue;
                    this.esay("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                    for (i = 0; i < rs.fileStatuses.length; ++i) {
                        this.edsay("      ====> fileStatus state ==" + rs.fileStatuses[i].state);
                    }
                    throw new IOException("rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                }
            }
            catch (IOException ioe) {
                if (this.configuration.isDebug()) {
                    ioe.printStackTrace();
                } else {
                    this.esay(ioe.toString());
                }
                this.done(rs, this.srm);
                throw ioe;
            }
        }
        finally {
            if (this.copier != null) {
                this.copier.doneAddingJobs();
                this.copier.waitCompletion();
            }
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm copy of at least one file failed or not completed");
                System.exit(1);
            }
        }
    }

    @Override
    public void run() {
        this.say("setting all remaining file statuses to \"Done\"");
        this.copier.stop();
        while (!this.fileIDs.isEmpty()) {
            Integer fileId = this.fileIDs.iterator().next();
            this.fileIDs.remove(fileId);
            this.say("setting file request " + fileId + " status to Done");
            RequestFileStatus rfs = this.fileIDsMap.get(fileId);
            this.srm.setFileStatus(this.requestID, rfs.fileId, "Done");
        }
        this.say("set all file statuses to \"Done\"");
    }
}

