/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import java.util.Calendar;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfTRequestTokenReturn;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmGetRequestTokensRequest;
import org.dcache.srm.v2_2.SrmGetRequestTokensResponse;
import org.dcache.srm.v2_2.TRequestTokenReturn;
import org.dcache.srm.v2_2.TReturnStatus;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMGetRequestTokensClientV2
extends SRMClient {
    private GlobusURL srmURL;
    private GSSCredential credential = null;
    private ISRM srmv2;

    public SRMGetRequestTokensClientV2(Configuration configuration, GlobusURL url) {
        super(configuration);
        this.srmURL = url;
        try {
            this.credential = this.getGssCredential();
        }
        catch (Exception e) {
            this.credential = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        this.srmv2 = new SRMClientV2(this.srmURL, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        try {
            SrmGetRequestTokensRequest request = new SrmGetRequestTokensRequest();
            request.setUserRequestDescription(this.configuration.getUserRequestDescription());
            SrmGetRequestTokensResponse response = this.srmv2.srmGetRequestTokens(request);
            if (response == null) {
                throw new IOException(" null SrmGetRequestTokensResponse ");
            }
            TReturnStatus rs = response.getReturnStatus();
            if (rs == null) {
                throw new IOException(" null TReturnStatus ");
            }
            if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)rs)) {
                throw new IOException("srmGetRequestTokens failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
            }
            if (response.getArrayOfRequestTokens() != null) {
                ArrayOfTRequestTokenReturn tokens = response.getArrayOfRequestTokens();
                if (tokens.getTokenArray() != null) {
                    TRequestTokenReturn[] tokenArray = tokens.getTokenArray();
                    for (int i = 0; i < tokenArray.length; ++i) {
                        String token = tokenArray[i].getRequestToken();
                        Calendar date = tokenArray[i].getCreatedAtTime();
                        System.out.println("Request token=" + (token != null ? token : "null") + " Created=" + (date != null ? date : "null"));
                    }
                } else {
                    System.err.println("Couldn't get list of request tokens");
                }
            } else {
                System.err.println("No request tokens found");
            }
        }
        catch (Exception e) {
            this.say(e.toString());
        }
    }
}

