/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTRequestSummary;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmGetRequestSummaryRequest;
import org.dcache.srm.v2_2.SrmGetRequestSummaryResponse;
import org.dcache.srm.v2_2.TRequestSummary;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TReturnStatus;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMGetRequestSummaryClientV2
extends SRMClient {
    private GlobusURL srmURL;
    private GSSCredential credential = null;
    private ISRM srmv2;

    public SRMGetRequestSummaryClientV2(Configuration configuration, GlobusURL url) {
        super(configuration);
        this.srmURL = url;
        try {
            this.credential = this.getGssCredential();
        }
        catch (Exception e) {
            this.credential = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        this.srmv2 = new SRMClientV2(this.srmURL, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        ArrayOfTRequestSummary summaries;
        if (this.credential.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        String[] tokens = this.configuration.getArrayOfRequestTokens();
        SrmGetRequestSummaryRequest request = new SrmGetRequestSummaryRequest();
        request.setArrayOfRequestTokens(new ArrayOfString(tokens));
        SrmGetRequestSummaryResponse response = this.srmv2.srmGetRequestSummary(request);
        if (response == null) {
            throw new IOException(" null SrmGetRequestSummaryResponse ");
        }
        TReturnStatus rs = response.getReturnStatus();
        if (rs == null) {
            throw new IOException(" null TReturnStatus ");
        }
        if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)rs)) {
            throw new IOException("srmGetRequestSummary failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
        }
        if (response.getArrayOfRequestSummaries() != null && (summaries = response.getArrayOfRequestSummaries()).getSummaryArray() != null) {
            for (int i = 0; i < summaries.getSummaryArray().length; ++i) {
                TRequestSummary summary = summaries.getSummaryArray(i);
                if (summary == null) continue;
                TReturnStatus st = summary.getStatus();
                TRequestType type = summary.getRequestType();
                System.out.println("\tRequest number  : " + summary.getRequestToken());
                System.out.println("\t  Request type  : " + (type != null ? type.getValue() : "UNKNOWN"));
                System.out.println("\t Return status");
                System.out.println("\t\t Status code  : " + (st != null ? st.getStatusCode() : "null"));
                System.out.println("\t\t Explanation  : " + (st != null ? st.getExplanation() : "null"));
                System.out.println("\tTotal # of files: " + summary.getTotalNumFilesInRequest());
                System.out.println("\t completed files: " + summary.getNumOfCompletedFiles());
                System.out.println("\t   waiting files: " + summary.getNumOfWaitingFiles());
                System.out.println("\t    failed files: " + summary.getNumOfFailedFiles());
            }
        }
    }
}

