/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.CopyJobFileReader;
import gov.fnal.srm.util.SRMAbortFilesClientV2;
import gov.fnal.srm.util.SRMAbortRequestClientV2;
import gov.fnal.srm.util.SRMAdvisoryDeleteClientV1;
import gov.fnal.srm.util.SRMBringOnlineClientV2;
import gov.fnal.srm.util.SRMCheckPermissionClientV2;
import gov.fnal.srm.util.SRMClient;
import gov.fnal.srm.util.SRMCopyClientV1;
import gov.fnal.srm.util.SRMCopyClientV2;
import gov.fnal.srm.util.SRMExtendFileLifeTimeClientV2;
import gov.fnal.srm.util.SRMGetClientV1;
import gov.fnal.srm.util.SRMGetClientV2;
import gov.fnal.srm.util.SRMGetFileMetaDataClientV1;
import gov.fnal.srm.util.SRMGetPermissionClientV2;
import gov.fnal.srm.util.SRMGetRequestStatusClientV1;
import gov.fnal.srm.util.SRMGetRequestSummaryClientV2;
import gov.fnal.srm.util.SRMGetRequestTokensClientV2;
import gov.fnal.srm.util.SRMGetSpaceMetaDataClientV2;
import gov.fnal.srm.util.SRMGetSpaceTokensClientV2;
import gov.fnal.srm.util.SRMLsClientV2;
import gov.fnal.srm.util.SRMMkDirClientV2;
import gov.fnal.srm.util.SRMMvClientV2;
import gov.fnal.srm.util.SRMPingClientV1;
import gov.fnal.srm.util.SRMPingClientV2;
import gov.fnal.srm.util.SRMPutClientV1;
import gov.fnal.srm.util.SRMPutClientV2;
import gov.fnal.srm.util.SRMReleaseFilesClientV2;
import gov.fnal.srm.util.SRMReleaseSpaceClientV2;
import gov.fnal.srm.util.SRMReserveSpaceClientV2;
import gov.fnal.srm.util.SRMRmClientV2;
import gov.fnal.srm.util.SRMRmdirClientV2;
import gov.fnal.srm.util.SRMSetPermissionClientV2;
import gov.fnal.srm.util.SRMSimpleCopyClient;
import gov.fnal.srm.util.SRMStageClientV1;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.dcache.srm.Logger;
import org.dcache.srm.util.SrmUrl;
import org.globus.util.GlobusURL;

public class SRMDispatcher {
    public static final int ERROR_TYPE = -1;
    public static final int SRM_URL = 1;
    public static final int HTTP_URL = 2;
    public static final int SUPPORTED_PROTOCOL_URL = 4;
    public static final int FILE_URL = 8;
    public static final int EXISTS_FILE_URL = 16;
    public static final int CAN_READ_FILE_URL = 32;
    public static final int CAN_WRITE_FILE_URL = 64;
    public static final int DIRECTORY_URL = 128;
    public static final int UNKNOWN_URL = 256;
    private SRMClient srmclient;
    private Configuration configuration;
    private Logger logger;

    private SRMDispatcher(Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.logger = configuration.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) throws Exception {
        long endTime;
        Configuration conf = new Configuration();
        try {
            String trusted_ca_certs;
            conf.parseArguments(args);
            SRMCopyLogger logger = new SRMCopyLogger(conf.isDebug());
            conf.setLogger(logger);
            logger.log(conf.toString());
            String globus_tcp_port_range = conf.getGlobus_tcp_port_range();
            if (globus_tcp_port_range != null) {
                System.setProperty("org.globus.tcp.port.range", globus_tcp_port_range);
            }
            if ((trusted_ca_certs = conf.getX509_user_trusted_certificates()) != null) {
                System.setProperty("X509_CERT_DIR", trusted_ca_certs);
            }
            if (conf.getSave_config_file() != null) {
                logger.log(" saving configuration in " + conf.getSave_config_file());
                conf.write(conf.getSave_config_file());
                System.exit(0);
            }
            if (conf.isHelp()) {
                logger.elog(conf.usage());
                System.exit(1);
            }
            if (conf.isGetFileMetaData()) {
                if (conf.getGetFileMetaDataSurls() == null || conf.getGetFileMetaDataSurls().length == 0) {
                    System.err.println("cannot get metadata - surls not specified");
                    System.exit(1);
                }
            } else if (conf.isGetPermission()) {
                if (conf.getGetPermissionSurls() == null || conf.getGetPermissionSurls().length == 0) {
                    System.err.println("cannot get permission - surls not specified");
                    System.exit(1);
                }
            } else if (conf.isCheckPermission()) {
                if (conf.getCheckPermissionSurls() == null || conf.getCheckPermissionSurls().length == 0) {
                    System.err.println("cannot check permission - surls not specified");
                    System.exit(1);
                }
            } else if (conf.isExtendFileLifetime()) {
                if (conf.getExtendFileLifetimeSurls() == null || conf.getExtendFileLifetimeSurls().length == 0) {
                    System.err.println("cannot extend file lifetime - surls not specified");
                    System.exit(1);
                }
            } else if (conf.isSetPermission()) {
                String m;
                if (conf.getSetPermissionSurl() == null) {
                    System.err.println("cannot set permission - surls not specified");
                    System.exit(1);
                }
                if (conf.getSetPermissionType() == null) {
                    System.err.println("permission type is not specified");
                    System.exit(1);
                }
                String[] types = new String[]{"ADD", "REMOVE", "CHANGE"};
                boolean ok = false;
                for (int i = 0; i < types.length; ++i) {
                    String p = types[i];
                    if (!conf.getSetPermissionType().equalsIgnoreCase(p)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Incorrect permission type specified " + conf.getSetPermissionType() + "\n");
                    sb.append("supported permission types :\n");
                    sb.append("\t");
                    for (int i = 0; i < types.length; ++i) {
                        String p = types[i];
                        sb.append(p + " ");
                    }
                    sb.append("\n");
                    System.err.println(sb.toString());
                    System.exit(1);
                }
                String[] modes = new String[]{"NONE", "X", "W", "WR", "R", "RX", "RW", "RWX"};
                ok = false;
                if (conf.getSetOwnerPermissionMode() != null) {
                    for (int i = 0; i < modes.length; ++i) {
                        String m2 = modes[i];
                        if (!conf.getSetOwnerPermissionMode().equalsIgnoreCase(m2)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Incorrect owner permission mode specified " + conf.getSetOwnerPermissionMode() + "\n");
                        sb.append("supported owner permission modes :\n");
                        sb.append("\t");
                        for (int i = 0; i < modes.length; ++i) {
                            m = modes[i];
                            sb.append(m + " ");
                        }
                        sb.append("\n");
                        System.err.println(sb.toString());
                        System.exit(1);
                    }
                }
                ok = false;
                if (conf.getSetGroupPermissionMode() != null) {
                    for (int i = 0; i < modes.length; ++i) {
                        String m3 = modes[i];
                        if (!conf.getSetGroupPermissionMode().equalsIgnoreCase(m3)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Incorrect group permission mode specified " + conf.getSetGroupPermissionMode() + "\n");
                        sb.append("supported group permission modes :\n");
                        sb.append("\t");
                        for (int i = 0; i < modes.length; ++i) {
                            m = modes[i];
                            sb.append(m + " ");
                        }
                        sb.append("\n");
                        System.err.println(sb.toString());
                        System.exit(1);
                    }
                }
                ok = false;
                if (conf.getSetOtherPermissionMode() != null) {
                    for (int i = 0; i < modes.length; ++i) {
                        String m4 = modes[i];
                        if (!conf.getSetOtherPermissionMode().equalsIgnoreCase(m4)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Incorrect other permission mode specified " + conf.getSetOtherPermissionMode() + "\n");
                        sb.append("supported other permission modes :\n");
                        sb.append("\t");
                        for (int i = 0; i < modes.length; ++i) {
                            m = modes[i];
                            sb.append(m + " ");
                        }
                        sb.append("\n");
                        System.err.println(sb.toString());
                        System.exit(1);
                    }
                }
            } else if (conf.isAdvisoryDelete()) {
                if (conf.getAdvisoryDeleteSurls() == null || conf.getAdvisoryDeleteSurls().length == 0) {
                    System.err.println("cannot perform advisory delete - surls not specified");
                    System.exit(1);
                }
            } else if (conf.isGetRequestStatus()) {
                if (conf.getGetRequestStatusSurl() == null) {
                    System.err.println("surl, to be used for location of srm, is not specified");
                    System.exit(1);
                }
            } else if (conf.isGetRequestSummary()) {
                if (conf.getGetRequestStatusSurl() == null) {
                    System.err.println("surl, to be used for location of srm, is not specified");
                    System.exit(1);
                }
            } else if (conf.isGetRequestTokens()) {
                if (conf.getGetRequestStatusSurl() == null) {
                    System.err.println("surl, to be used for location of srm, is not specified");
                    System.exit(1);
                }
            } else if (conf.isCopy() || conf.isMove()) {
                if ((conf.getFrom() == null || conf.getTo() == null) && conf.getCopyjobfile() == null) {
                    logger.elog("source(s) and/or destination are not specified in either argument or file");
                    System.exit(1);
                }
            } else if (conf.isReserveSpace()) {
                if (conf.getGuaranteedReserveSpaceSize() <= 0L) {
                    logger.elog("guaranteed size of space reservation must be greater than 0");
                    logger.elog(conf.usage());
                    System.exit(1);
                }
            } else if (conf.isReleaseSpace()) {
                if (conf.getSpaceToken() == null || conf.getSpaceToken().trim().equals("")) {
                    logger.elog("space token has to be specified to release explicit space reservation");
                    System.exit(1);
                }
            } else if (conf.isGetSpaceMetaData()) {
                if (conf.getSrmUrl() == null) {
                    logger.elog("srm url identifying srm system must be specified");
                    System.exit(1);
                }
                if (conf.getSpaceTokensList() == null || conf.getSpaceTokensList().length < 1) {
                    logger.elog("at least one space token must be specified");
                    System.exit(1);
                }
            } else if (conf.isGetSpaceTokens() && conf.getSrmUrl() == null) {
                logger.elog("srm url identifying srm system must be specified");
                System.exit(1);
            }
        }
        catch (Exception e) {
            if (conf.isDebug()) {
                throw e;
            }
            System.err.println("srm client error: \n" + e.toString());
            System.exit(1);
        }
        int repeatCount = conf.getRepeatCount();
        long startTime = endTime = System.currentTimeMillis();
        Exception exception = null;
        String clientName = null;
        if (conf.isPrintPerfomance()) {
            System.out.format("%25s, %19s, %19s, %5s, %s, %s\n", "<String(performace info)>", "<StartMillis>", "<EndMillis>", "<RunNumber>", "<Status(success|failure)", "<performanceTestName>");
        }
        for (int i = 0; i < repeatCount; ++i) {
            String success;
            String perfomanceTestName;
            exception = null;
            try {
                SRMDispatcher dispatcher = new SRMDispatcher(conf);
                dispatcher.work();
                clientName = dispatcher.getClientName();
                if (!conf.isPrintPerfomance()) continue;
                perfomanceTestName = conf.getPerformanceTestName();
                if (perfomanceTestName == null) {
                    perfomanceTestName = clientName;
                }
                success = exception == null ? "success" : "failure";
            }
            catch (Exception e) {
                try {
                    exception = e;
                    if (conf.isDebug()) {
                        e.printStackTrace();
                    } else {
                        System.err.println("srm client error: \n" + e.toString());
                    }
                    if (!conf.isPrintPerfomance()) continue;
                    perfomanceTestName = conf.getPerformanceTestName();
                    if (perfomanceTestName == null) {
                        perfomanceTestName = clientName;
                    }
                    success = exception == null ? "success" : "failure";
                }
                catch (Throwable throwable) {
                    if (conf.isPrintPerfomance()) {
                        String perfomanceTestName2 = conf.getPerformanceTestName();
                        if (perfomanceTestName2 == null) {
                            perfomanceTestName2 = clientName;
                        }
                        String success2 = exception == null ? "success" : "failure";
                        endTime = System.currentTimeMillis();
                        System.out.format("%25s, %19d, %19d, %5d, %s, %s\n", "performace info", startTime, endTime, i, success2, perfomanceTestName2);
                        startTime = endTime;
                    }
                    throw throwable;
                }
                endTime = System.currentTimeMillis();
                System.out.format("%25s, %19d, %19d, %5d, %s, %s\n", "performace info", startTime, endTime, i, success, perfomanceTestName);
                startTime = endTime;
                continue;
            }
            endTime = System.currentTimeMillis();
            System.out.format("%25s, %19d, %19d, %5d, %s, %s\n", "performace info", startTime, endTime, i, success, perfomanceTestName);
            startTime = endTime;
            continue;
        }
        if (exception != null) {
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void work() throws Exception {
        block71: {
            block91: {
                int toType;
                int fromType;
                GlobusURL[] to_urls;
                GlobusURL[] from_urls;
                block95: {
                    block96: {
                        block92: {
                            block94: {
                                block93: {
                                    block90: {
                                        String to;
                                        String from;
                                        block89: {
                                            block88: {
                                                block87: {
                                                    block86: {
                                                        block85: {
                                                            block84: {
                                                                block83: {
                                                                    block82: {
                                                                        block81: {
                                                                            block80: {
                                                                                block79: {
                                                                                    block78: {
                                                                                        block77: {
                                                                                            block76: {
                                                                                                block75: {
                                                                                                    block74: {
                                                                                                        block73: {
                                                                                                            block72: {
                                                                                                                if (!this.configuration.isGetFileMetaData()) break block72;
                                                                                                                String[] surl_strings = this.configuration.getGetFileMetaDataSurls();
                                                                                                                int number_of_surls = surl_strings.length;
                                                                                                                GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                                                for (int i = 0; i < number_of_surls; ++i) {
                                                                                                                    surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                                                }
                                                                                                                this.checkURLSUniformity(1, surls, false);
                                                                                                                this.srmclient = new SRMGetFileMetaDataClientV1(this.configuration, surls, surl_strings);
                                                                                                                break block71;
                                                                                                            }
                                                                                                            if (!this.configuration.isGetPermission()) break block73;
                                                                                                            String[] surl_strings = this.configuration.getGetPermissionSurls();
                                                                                                            int number_of_surls = surl_strings.length;
                                                                                                            GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                                            for (int i = 0; i < number_of_surls; ++i) {
                                                                                                                surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                                            }
                                                                                                            this.checkURLSUniformity(1, surls, false);
                                                                                                            this.srmclient = new SRMGetPermissionClientV2(this.configuration, surls, surl_strings);
                                                                                                            break block71;
                                                                                                        }
                                                                                                        if (!this.configuration.isCheckPermission()) break block74;
                                                                                                        String[] surl_strings = this.configuration.getCheckPermissionSurls();
                                                                                                        int number_of_surls = surl_strings.length;
                                                                                                        GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                                        for (int i = 0; i < number_of_surls; ++i) {
                                                                                                            surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                                        }
                                                                                                        this.checkURLSUniformity(1, surls, false);
                                                                                                        this.srmclient = new SRMCheckPermissionClientV2(this.configuration, surls, surl_strings);
                                                                                                        break block71;
                                                                                                    }
                                                                                                    if (!this.configuration.isExtendFileLifetime()) break block75;
                                                                                                    String[] surl_strings = this.configuration.getExtendFileLifetimeSurls();
                                                                                                    int number_of_surls = surl_strings.length;
                                                                                                    GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                                    for (int i = 0; i < number_of_surls; ++i) {
                                                                                                        surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                                    }
                                                                                                    this.checkURLSUniformity(1, surls, false);
                                                                                                    this.srmclient = new SRMExtendFileLifeTimeClientV2(this.configuration, surls, surl_strings);
                                                                                                    break block71;
                                                                                                }
                                                                                                if (!this.configuration.isSetPermission()) break block76;
                                                                                                String surl_string = this.configuration.getSetPermissionSurl();
                                                                                                SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                                                                                                this.srmclient = new SRMSetPermissionClientV2(this.configuration, (GlobusURL)surl, surl_string);
                                                                                                break block71;
                                                                                            }
                                                                                            if (!this.configuration.isls()) break block77;
                                                                                            String[] surl_strings = this.configuration.getLsURLs();
                                                                                            int number_of_surls = surl_strings.length;
                                                                                            GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                            for (int i = 0; i < number_of_surls; ++i) {
                                                                                                surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                            }
                                                                                            this.checkURLSUniformity(1, surls, false);
                                                                                            this.srmclient = new SRMLsClientV2(this.configuration, surls, surl_strings);
                                                                                            break block71;
                                                                                        }
                                                                                        if (!this.configuration.isReserveSpace()) break block78;
                                                                                        String[] surl_strings = this.configuration.getReserveSpaceURLs();
                                                                                        if (surl_strings == null) {
                                                                                            throw new IllegalArgumentException("Must specify SRM URL");
                                                                                        }
                                                                                        int number_of_surls = surl_strings.length;
                                                                                        if (number_of_surls > 1) {
                                                                                            throw new IllegalArgumentException("Only one SRM SURL is  supported ");
                                                                                        }
                                                                                        if (number_of_surls == 0) {
                                                                                            throw new IllegalArgumentException("No URL specified ");
                                                                                        }
                                                                                        GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                        for (int i = 0; i < number_of_surls; ++i) {
                                                                                            surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                        }
                                                                                        this.checkURLSUniformity(1, surls, false);
                                                                                        this.srmclient = new SRMReserveSpaceClientV2(this.configuration, surls[0]);
                                                                                        break block71;
                                                                                    }
                                                                                    if (!this.configuration.isReleaseSpace()) break block79;
                                                                                    String[] surl_strings = this.configuration.getReserveSpaceURLs();
                                                                                    if (surl_strings == null) {
                                                                                        throw new IllegalArgumentException("Must specify SRM URL");
                                                                                    }
                                                                                    int number_of_surls = surl_strings.length;
                                                                                    if (number_of_surls > 1) {
                                                                                        throw new IllegalArgumentException("Only one SRM SURL is  supported ");
                                                                                    }
                                                                                    if (number_of_surls == 0) {
                                                                                        throw new IllegalArgumentException("No URL specified ");
                                                                                    }
                                                                                    GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                                    for (int i = 0; i < number_of_surls; ++i) {
                                                                                        surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                                    }
                                                                                    this.checkURLSUniformity(1, surls, false);
                                                                                    this.srmclient = new SRMReleaseSpaceClientV2(this.configuration, surls[0]);
                                                                                    break block71;
                                                                                }
                                                                                if (!this.configuration.isGetSpaceMetaData()) break block80;
                                                                                String surl_string = this.configuration.getSrmUrl();
                                                                                if (surl_string == null) {
                                                                                    throw new IllegalArgumentException("Must specify SRM URL");
                                                                                }
                                                                                SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                                                                                this.srmclient = new SRMGetSpaceMetaDataClientV2(this.configuration, (GlobusURL)surl);
                                                                                break block71;
                                                                            }
                                                                            if (!this.configuration.isGetSpaceTokens()) break block81;
                                                                            String surl_string = this.configuration.getSrmUrl();
                                                                            if (surl_string == null) {
                                                                                throw new IllegalArgumentException("Must specify SRM URL");
                                                                            }
                                                                            SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                                                                            this.srmclient = new SRMGetSpaceTokensClientV2(this.configuration, (GlobusURL)surl);
                                                                            break block71;
                                                                        }
                                                                        if (!this.configuration.isStage()) break block82;
                                                                        String[] surl_strings = this.configuration.getLsURLs();
                                                                        int number_of_surls = surl_strings.length;
                                                                        GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                        for (int i = 0; i < number_of_surls; ++i) {
                                                                            surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                        }
                                                                        this.checkURLSUniformity(1, surls, false);
                                                                        this.srmclient = new SRMStageClientV1(this.configuration, surls);
                                                                        break block71;
                                                                    }
                                                                    if (!this.configuration.isRmdir()) break block83;
                                                                    String[] surl_strings = this.configuration.getRmURLs();
                                                                    int number_of_surls = surl_strings.length;
                                                                    if (number_of_surls > 1) {
                                                                        throw new IllegalArgumentException("Only single directory tree removal is suported ");
                                                                    }
                                                                    if (number_of_surls == 0) {
                                                                        throw new IllegalArgumentException("No URL specified");
                                                                    }
                                                                    GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                    for (int i = 0; i < number_of_surls; ++i) {
                                                                        surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                    }
                                                                    this.checkURLSUniformity(1, surls, false);
                                                                    this.srmclient = new SRMRmdirClientV2(this.configuration, surls[0], surl_strings[0]);
                                                                    break block71;
                                                                }
                                                                if (!this.configuration.isMkdir()) break block84;
                                                                String[] surl_strings = this.configuration.getMkDirURLs();
                                                                int number_of_surls = surl_strings.length;
                                                                if (number_of_surls > 1) {
                                                                    throw new IllegalArgumentException("Only one directory at a time supported ");
                                                                }
                                                                if (number_of_surls == 0) {
                                                                    throw new IllegalArgumentException("No URL specified ");
                                                                }
                                                                GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                                for (int i = 0; i < number_of_surls; ++i) {
                                                                    surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                                }
                                                                this.checkURLSUniformity(1, surls, false);
                                                                this.srmclient = new SRMMkDirClientV2(this.configuration, surls[0], surl_strings[0]);
                                                                break block71;
                                                            }
                                                            if (!this.configuration.isRm()) break block85;
                                                            String[] surl_strings = this.configuration.getRmURLs();
                                                            int number_of_surls = surl_strings.length;
                                                            GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                            for (int i = 0; i < number_of_surls; ++i) {
                                                                surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                            }
                                                            this.checkURLSUniformity(1, surls, false);
                                                            this.srmclient = new SRMRmClientV2(this.configuration, surls, surl_strings);
                                                            break block71;
                                                        }
                                                        if (!this.configuration.isAdvisoryDelete()) break block86;
                                                        String[] surl_strings = this.configuration.getAdvisoryDeleteSurls();
                                                        int number_of_surls = surl_strings.length;
                                                        GlobusURL[] surls = new GlobusURL[number_of_surls];
                                                        for (int i = 0; i < number_of_surls; ++i) {
                                                            surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                                                        }
                                                        this.checkURLSUniformity(1, surls, false);
                                                        this.srmclient = new SRMAdvisoryDeleteClientV1(this.configuration, surls, surl_strings);
                                                        break block71;
                                                    }
                                                    if (!this.configuration.isGetRequestStatus()) break block87;
                                                    String surl_string = this.configuration.getGetRequestStatusSurl();
                                                    int requestId = this.configuration.getGetRequestStatusId();
                                                    SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                                                    this.srmclient = new SRMGetRequestStatusClientV1(this.configuration, (GlobusURL)surl, requestId);
                                                    break block71;
                                                }
                                                if (!this.configuration.isGetRequestSummary()) break block88;
                                                String surl_string = this.configuration.getGetRequestStatusSurl();
                                                SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                                                this.srmclient = new SRMGetRequestSummaryClientV2(this.configuration, (GlobusURL)surl);
                                                break block71;
                                            }
                                            if (!this.configuration.isGetRequestTokens()) break block89;
                                            String surl_string = this.configuration.getGetRequestStatusSurl();
                                            SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                                            this.srmclient = new SRMGetRequestTokensClientV2(this.configuration, (GlobusURL)surl);
                                            break block71;
                                        }
                                        if (!this.configuration.isMove()) break block90;
                                        String[] surl_strings = new String[2];
                                        if (this.configuration.getCopyjobfile() != null) {
                                            CopyJobFileReader reader = new CopyJobFileReader(this.configuration.getCopyjobfile());
                                            if (reader.getSources().length > 1 || reader.getDestinations().length > 1) {
                                                throw new IllegalArgumentException("only signle source and single destination supported");
                                            }
                                            from = reader.getSources()[0];
                                            to = reader.getDestinations()[0];
                                        } else {
                                            if (this.configuration.getFrom().length > 1) {
                                                throw new IllegalArgumentException("only signle source and single destination supported");
                                            }
                                            from = this.configuration.getFrom()[0];
                                            to = this.configuration.getTo();
                                        }
                                        SrmUrl from_url = new SrmUrl(from, this.configuration.getDefaultSrmPortNumber());
                                        SrmUrl to_url = new SrmUrl(to, this.configuration.getDefaultSrmPortNumber());
                                        GlobusURL[] surls = new GlobusURL[]{from_url, to_url};
                                        surl_strings[0] = from;
                                        surl_strings[1] = to;
                                        int fromType2 = SRMDispatcher.getUrlType((GlobusURL)from_url);
                                        int toType2 = SRMDispatcher.getUrlType((GlobusURL)to_url);
                                        if (fromType2 != toType2) {
                                            throw new IllegalArgumentException("source and destination have to have same URL type");
                                        }
                                        if (fromType2 != 1) {
                                            throw new IllegalArgumentException("source and destination have to be SRM URLs");
                                        }
                                        this.checkURLSUniformity(fromType2, surls, true);
                                        this.srmclient = new SRMMvClientV2(this.configuration, surls, surl_strings);
                                        break block71;
                                    }
                                    if (!this.configuration.isCopy()) break block91;
                                    if (this.configuration.getCopyjobfile() != null) {
                                        CopyJobFileReader reader = new CopyJobFileReader(this.configuration.getCopyjobfile());
                                        String[] from = reader.getSources();
                                        String[] to = reader.getDestinations();
                                        int number_of_sources = from.length;
                                        from_urls = new GlobusURL[number_of_sources];
                                        to_urls = new GlobusURL[number_of_sources];
                                        for (int i = 0; i < number_of_sources; ++i) {
                                            from_urls[i] = new SrmUrl(from[i], this.configuration.getDefaultSrmPortNumber());
                                            to_urls[i] = new SrmUrl(to[i], this.configuration.getDefaultSrmPortNumber());
                                        }
                                    } else {
                                        int i;
                                        String[] from = this.configuration.getFrom();
                                        int number_of_sources = from.length;
                                        String to = this.configuration.getTo();
                                        from_urls = new GlobusURL[number_of_sources];
                                        for (i = 0; i < number_of_sources; ++i) {
                                            from_urls[i] = new SrmUrl(from[i], this.configuration.getDefaultSrmPortNumber());
                                        }
                                        to_urls = new GlobusURL[number_of_sources];
                                        if (number_of_sources > 1) {
                                            for (i = 0; i < number_of_sources; ++i) {
                                                String file = from_urls[i].getPath();
                                                int lastSlash = file.lastIndexOf(47);
                                                if (lastSlash != -1) {
                                                    file = file.substring(lastSlash);
                                                }
                                                to_urls[i] = new SrmUrl(to + "/" + file, this.configuration.getDefaultSrmPortNumber());
                                            }
                                        } else {
                                            to_urls[0] = new SrmUrl(to, this.configuration.getDefaultSrmPortNumber());
                                        }
                                    }
                                    fromType = SRMDispatcher.getUrlType(from_urls[0]);
                                    this.checkURLSUniformity(fromType, from_urls, true);
                                    toType = SRMDispatcher.getUrlType(to_urls[0]);
                                    this.checkURLSUniformity(toType, to_urls, false);
                                    if (fromType != 1) break block92;
                                    if ((toType & 8) != 8) break block93;
                                    this.dsay("starting SRMGetClient");
                                    if (this.configuration.getSrmProtocolVersion() == 1) {
                                        this.srmclient = new SRMGetClientV1(this.configuration, from_urls, to_urls);
                                        break block71;
                                    } else if (this.configuration.getSrmProtocolVersion() == 2) {
                                        this.srmclient = new SRMGetClientV2(this.configuration, from_urls, to_urls);
                                    }
                                    break block71;
                                }
                                if (toType != 1) break block94;
                                if (this.configuration.getSrmProtocolVersion() == 1) {
                                    this.srmclient = new SRMCopyClientV1(this.configuration, from_urls, to_urls);
                                    break block71;
                                } else if (this.configuration.getSrmProtocolVersion() == 2) {
                                    this.srmclient = new SRMCopyClientV2(this.configuration, from_urls, to_urls);
                                }
                                break block71;
                            }
                            if (!this.configuration.isPushmode()) {
                                this.configuration.setPushmode(true);
                            }
                            if (this.configuration.getSrmProtocolVersion() == 1) {
                                this.srmclient = new SRMCopyClientV1(this.configuration, from_urls, to_urls);
                                break block71;
                            } else if (this.configuration.getSrmProtocolVersion() == 2) {
                                this.srmclient = new SRMCopyClientV2(this.configuration, from_urls, to_urls);
                            }
                            break block71;
                        }
                        if (toType != 1) break block95;
                        if ((fromType & 8) != 8) break block96;
                        if (this.configuration.getSrmProtocolVersion() == 1) {
                            this.srmclient = new SRMPutClientV1(this.configuration, from_urls, to_urls);
                            break block71;
                        } else if (this.configuration.getSrmProtocolVersion() == 2) {
                            this.srmclient = new SRMPutClientV2(this.configuration, from_urls, to_urls);
                        }
                        break block71;
                    }
                    if (this.configuration.isPushmode()) {
                        this.configuration.setPushmode(false);
                    }
                    if (this.configuration.getSrmProtocolVersion() == 1) {
                        this.srmclient = new SRMCopyClientV1(this.configuration, from_urls, to_urls);
                        break block71;
                    } else if (this.configuration.getSrmProtocolVersion() == 2) {
                        this.srmclient = new SRMCopyClientV2(this.configuration, from_urls, to_urls);
                    }
                    break block71;
                }
                if (!((fromType & 8) != 8 && (fromType & 4) != 4 || (toType & 8) != 8 && (toType & 4) != 4)) {
                    this.srmclient = new SRMSimpleCopyClient(this.configuration, from_urls, to_urls);
                    break block71;
                } else {
                    this.esay("neither source nor destination are SRM URLs :" + from_urls[0].getURL() + " " + from_urls[0].getURL());
                    throw new IllegalArgumentException("neither source nor destination are SRM URLs :" + from_urls[0].getURL() + " " + from_urls[0].getURL());
                }
            }
            if (this.configuration.isBringOnline()) {
                String[] surl_strings = this.configuration.getBringOnlineSurls();
                int number_of_surls = surl_strings.length;
                GlobusURL[] surls = new GlobusURL[number_of_surls];
                for (int i = 0; i < number_of_surls; ++i) {
                    surls[i] = new SrmUrl(surl_strings[i], this.configuration.getDefaultSrmPortNumber());
                }
                this.checkURLSUniformity(1, surls, false);
                this.srmclient = new SRMBringOnlineClientV2(this.configuration, surls);
            } else if (this.configuration.isPing()) {
                String surl_string = this.configuration.getSrmUrl();
                SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                if (this.configuration.getSrmProtocolVersion() == 1) {
                    this.srmclient = new SRMPingClientV1(this.configuration, (GlobusURL)surl);
                }
                if (this.configuration.getSrmProtocolVersion() == 2) {
                    this.srmclient = new SRMPingClientV2(this.configuration, (GlobusURL)surl);
                }
            } else if (this.configuration.isAbortRequest()) {
                String surl_string = this.configuration.getSrmUrl();
                if (surl_string == null) {
                    throw new IllegalArgumentException("Must specify SRM URL");
                }
                SrmUrl surl = new SrmUrl(surl_string, this.configuration.getDefaultSrmPortNumber());
                this.srmclient = new SRMAbortRequestClientV2(this.configuration, (GlobusURL)surl);
            } else if (this.configuration.isAbortFiles()) {
                this.srmclient = new SRMAbortFilesClientV2(this.configuration);
            } else if (this.configuration.isReleaseFiles()) {
                this.srmclient = new SRMReleaseFilesClientV2(this.configuration);
            } else {
                System.err.println(" unknown action requested");
                System.exit(1);
            }
        }
        this.srmclient.connect();
        this.srmclient.start();
    }

    public void checkURLSUniformity(int type, GlobusURL[] urls, boolean areSources) throws Exception {
        int i;
        int number_of_sources = urls.length;
        if (number_of_sources == 0) {
            throw new IllegalArgumentException("No URL(s) specified ");
        }
        String host = urls[0].getHost();
        int port = urls[0].getPort();
        if (type == 1 || (type & 4) == 4) {
            if (host == null || host.equals("") || port < 0) {
                String error = "illegal source url for multiple sources mode" + urls[0].getURL();
                this.esay(error);
                throw new IllegalArgumentException(error);
            }
            for (i = 0; i < number_of_sources; ++i) {
                if (type != SRMDispatcher.getUrlType(urls[i])) {
                    String error = "if specifying multiple sources/destinations, sources/destinations must be of the same type, incorrect url: " + urls[i];
                    this.esay(error);
                    throw new IllegalArgumentException(error);
                }
                if (!host.equals(urls[i].getHost())) {
                    String error = "if specifying multiple  sources, all sources must have same host" + urls[i].getURL();
                    this.esay(error);
                    throw new IllegalArgumentException(error);
                }
                if (port == urls[i].getPort()) continue;
                String error = "if specifying multiple  sources, all sources must have same port" + urls[i];
                this.esay(error);
                throw new IllegalArgumentException(error);
            }
        } else if ((type & 8) == 8) {
            for (i = 1; i < number_of_sources; ++i) {
                int thisTypeI;
                int n = thisTypeI = i == 0 ? type : SRMDispatcher.getUrlType(urls[i]);
                if ((thisTypeI & 8) != 8) {
                    String error = "If specifying multiple sources, sources must be of the same type.  Incorrect source: " + urls[i];
                    this.esay(error);
                    throw new IllegalArgumentException(error);
                }
                if ((thisTypeI & 0x80) == 128) {
                    String error = "source/destination file is directory" + urls[i].getURL();
                    this.esay(error);
                    throw new IllegalArgumentException(error);
                }
                if (areSources && (thisTypeI & 0x10) == 0) {
                    String error = "source file does not exist" + urls[i].getURL();
                    this.esay(error);
                    throw new IllegalArgumentException(error);
                }
                if (!areSources || (thisTypeI & 0x20) != 0) continue;
                String error = "source file is not readable" + urls[i].getURL();
                this.esay(error);
                throw new IllegalArgumentException(error);
            }
        } else {
            String error = "Unknown type of source(s) or destination(s)";
            this.esay(error);
            throw new IllegalArgumentException(error);
        }
        if (this.configuration.getCopyjobfile() == null) {
            for (i = 0; i < number_of_sources; ++i) {
                for (int j = 0; j < number_of_sources; ++j) {
                    if (i == j || !urls[i].getPath().equals(urls[j].getPath())) continue;
                    String error = "list of sources contains the same url twice url#" + i + " is " + urls[i].getURL() + " and url#" + j + " is " + urls[j].getURL();
                    this.esay(error);
                    throw new IllegalArgumentException(error);
                }
            }
        }
    }

    public final void say(String msg) {
        this.logger.log(new Date().toString() + ": " + msg);
    }

    public final void dsay(String msg) {
        if (this.configuration.isDebug()) {
            this.logger.log(new Date().toString() + ": " + msg);
        }
    }

    public final void esay(String err) {
        this.logger.elog(new Date().toString() + ": " + err);
    }

    public final void edsay(String err) {
        if (this.configuration.isDebug()) {
            this.logger.elog(new Date().toString() + ": " + err);
        }
    }

    public static int getUrlType(GlobusURL url) throws IOException {
        String prot = url.getProtocol();
        if (prot != null) {
            if (prot.equals("srm")) {
                return 1;
            }
            if (prot.equals("http") || prot.equals("ftp") || prot.equals("gsiftp") || prot.equals("gridftp") || prot.equals("https") || prot.equals("ldap") || prot.equals("ldaps") || prot.equals("dcap") || prot.equals("rfio")) {
                return 4;
            }
            if (!prot.equals("file")) {
                return 256;
            }
        }
        File f = new File(url.getPath());
        f = f.getCanonicalFile();
        int rc = 8;
        if (f.exists()) {
            rc |= 0x10;
        }
        if (f.canRead()) {
            rc |= 0x20;
        }
        if (f.canWrite()) {
            rc |= 0x40;
        }
        if (f.isDirectory()) {
            rc |= 0x80;
        }
        return rc;
    }

    public String getClientName() {
        if (this.srmclient == null) {
            return "unknown";
        }
        return this.srmclient.getClass().getSimpleName();
    }

    private static class SRMCopyLogger
    implements Logger {
        private boolean debug;

        public SRMCopyLogger(boolean debug) {
            this.debug = debug;
        }

        public void elog(String s) {
            System.err.println(s);
        }

        public void elog(Throwable t) {
            t.printStackTrace(System.err);
        }

        public void log(String s) {
            if (this.debug) {
                System.out.println(s);
            }
        }
    }
}

