/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.request.AccessLatency;
import org.dcache.srm.request.FileStorageType;
import org.dcache.srm.request.OverwriteMode;
import org.dcache.srm.request.RetentionPolicy;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfTCopyFileRequest;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmCopyRequest;
import org.dcache.srm.v2_2.SrmCopyResponse;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TCopyFileRequest;
import org.dcache.srm.v2_2.TCopyRequestFileStatus;
import org.dcache.srm.v2_2.TDirOption;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class SRMCopyClientV2
extends SRMClient
implements Runnable {
    private GlobusURL[] from;
    private GlobusURL[] to;
    private SrmCopyRequest req = new SrmCopyRequest();
    private GSSCredential cred = null;
    private ISRM srmv2;
    private Thread hook;
    private HashMap<String, Integer> pendingSurlsMap = new HashMap();
    private String requestToken;

    public SRMCopyClientV2(Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.from = from;
        this.to = to;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            System.err.println("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = null;
        srmUrl = this.configuration.isPushmode() ? this.from[0] : this.to[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        try {
            SrmCopyResponse resp;
            TAccessLatency accessLatency;
            int len = this.from.length;
            TCopyFileRequest[] copyFileRequests = new TCopyFileRequest[len];
            for (int i = 0; i < this.from.length; ++i) {
                GlobusURL source = this.from[i];
                GlobusURL dest = this.to[i];
                TCopyFileRequest copyFileRequest = new TCopyFileRequest();
                copyFileRequest.setSourceSURL(new URI(source.getURL()));
                copyFileRequest.setTargetSURL(new URI(dest.getURL()));
                TDirOption dirOption = new TDirOption();
                dirOption.setIsSourceADirectory(false);
                dirOption.setAllLevelRecursive(Boolean.TRUE);
                copyFileRequest.setDirOption(dirOption);
                copyFileRequests[i] = copyFileRequest;
                this.pendingSurlsMap.put(this.from[i].getURL(), new Integer(i));
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            String storagetype = this.configuration.getStorageType();
            if (storagetype != null) {
                this.req.setTargetFileStorageType(FileStorageType.fromString((String)storagetype.toUpperCase()).toTFileStorageType());
            }
            this.req.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
            TRetentionPolicy retentionPolicy = this.configuration.getRetentionPolicy() != null ? RetentionPolicy.fromString((String)this.configuration.getRetentionPolicy()).toTRetentionPolicy() : null;
            TAccessLatency tAccessLatency = accessLatency = this.configuration.getAccessLatency() != null ? AccessLatency.fromString((String)this.configuration.getAccessLatency()).toTAccessLatency() : null;
            if (accessLatency != null && retentionPolicy == null) {
                throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
            }
            if (retentionPolicy != null) {
                TRetentionPolicyInfo retentionPolicyInfo = new TRetentionPolicyInfo(retentionPolicy, accessLatency);
                this.req.setTargetFileRetentionPolicyInfo(retentionPolicyInfo);
            }
            if (this.configuration.getOverwriteMode() != null) {
                this.req.setOverwriteOption(OverwriteMode.fromString((String)this.configuration.getOverwriteMode()).toTOverwriteMode());
            }
            this.req.setArrayOfFileRequests(new ArrayOfTCopyFileRequest(copyFileRequests));
            this.req.setUserRequestDescription("This is User request description");
            if (this.configuration.getSpaceToken() != null) {
                this.req.setTargetSpaceToken(this.configuration.getSpaceToken());
            }
            if (this.configuration.getExtraParameters().size() > 0) {
                TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                int counter = 0;
                Map<String, String> extraParameters = this.configuration.getExtraParameters();
                for (String key : extraParameters.keySet()) {
                    String value = extraParameters.get(key);
                    extraInfoArray[counter++] = new TExtraInfo(key, value);
                }
                ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                this.req.setSourceStorageSystemInfo(arrayOfExtraInfo);
            }
            if ((resp = this.srmv2.srmCopy(this.req)) == null) {
                throw new IOException(" null SrmCopyResponse");
            }
            TReturnStatus rs = resp.getReturnStatus();
            this.requestToken = resp.getRequestToken();
            this.dsay(" srm returned requestToken = " + this.requestToken);
            if (rs == null) {
                throw new IOException(" null TReturnStatus ");
            }
            if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)rs)) {
                throw new IOException("srmCopy submission failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
            }
            if (resp.getArrayOfFileStatuses() == null) {
                throw new IOException("srmCopy submission failed, arrayOfFileStatuses is null, status code :" + rs.getStatusCode() + " explanation=" + rs.getExplanation());
            }
            TCopyRequestFileStatus[] arrayOfStatuses = resp.getArrayOfFileStatuses().getStatusArray();
            if (arrayOfStatuses.length != len) {
                throw new IOException("number of SrmCopyRequestFileStatuses is SrmRequestStatus is different from exopected " + len + " received " + arrayOfStatuses.length);
            }
            while (!this.pendingSurlsMap.isEmpty()) {
                TReturnStatus status;
                String error;
                long estimatedWaitInSeconds = 5L;
                for (int i = 0; i < arrayOfStatuses.length; ++i) {
                    TCopyRequestFileStatus copyRequestFileStatus = arrayOfStatuses[i];
                    if (copyRequestFileStatus == null) {
                        throw new IOException(" null file status code");
                    }
                    TReturnStatus fileStatus = copyRequestFileStatus.getStatus();
                    if (fileStatus == null) {
                        throw new IOException(" null file return status");
                    }
                    TStatusCode fileStatusCode = fileStatus.getStatusCode();
                    if (fileStatusCode == null) {
                        throw new IOException(" null file status code");
                    }
                    URI from_surl = copyRequestFileStatus.getSourceSURL();
                    URI to_surl = copyRequestFileStatus.getTargetSURL();
                    if (from_surl == null) {
                        throw new IOException("null from_surl");
                    }
                    if (to_surl == null) {
                        throw new IOException("null to_surl");
                    }
                    String from_surl_string = from_surl.toString();
                    String to_surl_string = to_surl.toString();
                    if (RequestStatusTool.isFailedFileRequestStatus((TReturnStatus)fileStatus)) {
                        error = "copy of " + from_surl_string + " into " + to_surl + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                        this.esay(error);
                        int indx = this.pendingSurlsMap.remove(from_surl_string);
                        this.setReportFailed(this.from[indx], this.to[indx], error);
                    } else if (fileStatusCode == TStatusCode.SRM_SUCCESS || fileStatusCode == TStatusCode.SRM_DONE) {
                        int indx = this.pendingSurlsMap.remove(from_surl_string);
                        this.say(" copying of " + from_surl_string + " to " + to_surl_string + " succeeded");
                        this.setReportSucceeded(this.from[indx], this.to[indx]);
                    }
                    if (copyRequestFileStatus.getEstimatedWaitTime() == null || (long)copyRequestFileStatus.getEstimatedWaitTime().intValue() >= estimatedWaitInSeconds || copyRequestFileStatus.getEstimatedWaitTime() < 1) continue;
                    estimatedWaitInSeconds = copyRequestFileStatus.getEstimatedWaitTime().intValue();
                }
                if (this.pendingSurlsMap.isEmpty()) {
                    this.dsay("no more pending transfers, breaking the loop");
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    break;
                }
                if (estimatedWaitInSeconds > 60L) {
                    estimatedWaitInSeconds = 60L;
                }
                try {
                    this.say("sleeping " + estimatedWaitInSeconds + " seconds ...");
                    Thread.sleep(estimatedWaitInSeconds * 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                SrmStatusOfCopyRequestRequest request = new SrmStatusOfCopyRequestRequest();
                request.setRequestToken(this.requestToken);
                request.setAuthorizationID(this.req.getAuthorizationID());
                int expectedResponseLength = this.pendingSurlsMap.size();
                URI[] surlArrayOfFromSURLs = new URI[expectedResponseLength];
                URI[] surlArrayOfToSURLs = new URI[expectedResponseLength];
                Iterator<Integer> it = this.pendingSurlsMap.values().iterator();
                int i = 0;
                while (it.hasNext()) {
                    int indx = it.next();
                    TCopyFileRequest copyFileRequest = copyFileRequests[indx];
                    surlArrayOfFromSURLs[i] = copyFileRequest.getSourceSURL();
                    surlArrayOfToSURLs[i] = copyFileRequest.getTargetSURL();
                    ++i;
                }
                request.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArrayOfFromSURLs));
                request.setArrayOfTargetSURLs(new ArrayOfAnyURI(surlArrayOfToSURLs));
                SrmStatusOfCopyRequestResponse copyStatusRequestResponse = this.srmv2.srmStatusOfCopyRequest(request);
                if (copyStatusRequestResponse == null) {
                    throw new IOException(" null copyStatusRequestResponse");
                }
                if (copyStatusRequestResponse.getArrayOfFileStatuses() == null) {
                    throw new IOException("null SrmStatusOfCopyRequestResponse.getArrayOfFileStatuses()");
                }
                arrayOfStatuses = copyStatusRequestResponse.getArrayOfFileStatuses().getStatusArray();
                if (arrayOfStatuses.length != this.pendingSurlsMap.size()) {
                    this.esay("incorrect number of arrayOfStatuses in SrmStatusOfCopyRequestResponse expected " + expectedResponseLength + " received " + arrayOfStatuses.length);
                }
                if ((status = copyStatusRequestResponse.getReturnStatus()) == null) {
                    throw new IOException(" null return status");
                }
                TStatusCode statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (!RequestStatusTool.isFailedRequestStatus((TReturnStatus)status)) continue;
                error = "srmCopy update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                this.esay(error);
                for (int i2 = 0; i2 < expectedResponseLength; ++i2) {
                    TReturnStatus frstatus = arrayOfStatuses[i2].getStatus();
                    if (frstatus == null) continue;
                    this.esay("copyFileRequest[" + arrayOfStatuses[i2].getSourceSURL() + " , " + arrayOfStatuses[i2].getTargetSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                    if (RequestStatusTool.isTransientStateStatus((TReturnStatus)frstatus)) continue;
                    this.pendingSurlsMap.remove(arrayOfStatuses[i2].getSourceSURL().toString());
                }
                throw new IOException(error);
            }
        }
        catch (Exception e) {
            try {
                this.abortAllPendingFiles();
            }
            catch (Exception e1) {
                this.edsay(e1.toString());
            }
            throw e;
        }
        finally {
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm copy of at least one file failed or not completed");
            }
        }
    }

    @Override
    public void run() {
        try {
            this.dsay("stopping ");
            this.abortAllPendingFiles();
        }
        catch (Exception e) {
            this.logger.elog(e.toString());
        }
    }

    private void abortAllPendingFiles() throws Exception {
        if (this.pendingSurlsMap.isEmpty()) {
            return;
        }
        if (this.requestToken == null) {
            return;
        }
        String[] surl_strings = this.pendingSurlsMap.keySet().toArray(new String[0]);
        int len = surl_strings.length;
        this.say("Releasing all remaining file requests");
        URI[] surlArray = new URI[len];
        for (int i = 0; i < len; ++i) {
            URI uri;
            surlArray[i] = uri = new URI(surl_strings[i]);
        }
        SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
        srmAbortFilesRequest.setRequestToken(this.requestToken);
        srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
        SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
        if (srmAbortFilesResponse == null) {
            this.logger.elog(" srmAbortFilesResponse is null");
        } else {
            TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
            if (returnStatus == null) {
                this.esay("srmAbortFiles return status is null");
                return;
            }
            this.say("srmAbortFiles status code=" + returnStatus.getStatusCode());
        }
    }
}

