/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.globus.util.GlobusURL;

public class SRMCopyClientV1
extends SRMClient
implements Runnable {
    private GlobusURL[] from;
    private GlobusURL[] to;
    private HashSet<Integer> fileIDs = new HashSet();
    private HashMap<Integer, RequestFileStatus> fileIDsMap = new HashMap();
    private int requestID;
    private Thread hook;

    public SRMCopyClientV1(Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.from = from;
        this.to = to;
    }

    @Override
    public void connect() throws Exception {
        if (this.configuration.isPushmode()) {
            this.dsay("starting transfer in push mode");
            this.connect(this.from[0]);
        } else {
            this.dsay("starting transfer in pull mode");
            this.connect(this.to[0]);
        }
    }

    @Override
    public void start() throws Exception {
        int len = this.from.length;
        String[] srcSURLs = new String[len];
        String[] dstSURLs = new String[len];
        boolean[] wantPerm = new boolean[len];
        Arrays.fill(wantPerm, false);
        for (int i = 0; i < this.from.length; ++i) {
            GlobusURL source = this.from[i];
            GlobusURL dest = this.to[i];
            srcSURLs[i] = source.getURL();
            dstSURLs[i] = dest.getURL();
            this.dsay("copying " + srcSURLs[i] + " into " + dstSURLs[i]);
        }
        this.hook = new Thread(this);
        Runtime.getRuntime().addShutdownHook(this.hook);
        RequestStatus rs = this.srm.copy(srcSURLs, dstSURLs, wantPerm);
        if (rs == null) {
            throw new IOException(" null requests status");
        }
        this.requestID = rs.requestId;
        this.dsay(" srm returned requestId = " + rs.requestId);
        try {
            if (rs.state.equals("Failed")) {
                this.esay("Request with requestId =" + rs.requestId + " rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                for (int i = 0; i < rs.fileStatuses.length; ++i) {
                    this.edsay("      ====> fileStatus with fileId=" + rs.fileStatuses[i].fileId + " state ==" + rs.fileStatuses[i].state);
                }
                throw new IOException("Request with requestId =" + rs.requestId + " rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
            }
            if (rs.fileStatuses.length != len) {
                this.esay("incorrect number of RequestFileStatusesin RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                throw new IOException("incorrect number of RequestFileStatuses in RequestStatus expected " + len + " received " + rs.fileStatuses.length);
            }
            for (int i = 0; i < len; ++i) {
                Integer fileId = new Integer(rs.fileStatuses[i].fileId);
                this.fileIDs.add(fileId);
                this.fileIDsMap.put(fileId, rs.fileStatuses[i]);
            }
            while (!this.fileIDs.isEmpty()) {
                Iterator<Integer> iter = this.fileIDs.iterator();
                HashSet<Integer> removeIDs = new HashSet<Integer>();
                while (iter.hasNext()) {
                    Integer nextID = iter.next();
                    RequestFileStatus frs = SRMCopyClientV1.getFileRequest(rs, nextID);
                    if (frs == null) {
                        throw new IOException("request status does not haveRequestFileStatus fileID = " + nextID);
                    }
                    if (frs.state.equals("Failed")) {
                        this.say("FileRequestStatus is Failed => copying of " + frs.SURL + " has failed");
                        this.setReportFailed(new GlobusURL(frs.SURL), new GlobusURL(frs.TURL), "copy failed" + rs.errorMessage);
                        removeIDs.add(nextID);
                    }
                    if (frs.state.equals("Ready")) {
                        this.say("FileRequestStatus is Ready => copying of " + frs.SURL + " is complete");
                        this.setReportSucceeded(new GlobusURL(frs.SURL), new GlobusURL(frs.TURL));
                        removeIDs.add(nextID);
                        this.srm.setFileStatus(this.requestID, nextID.intValue(), "Done");
                    }
                    if (!frs.state.equals("Done")) continue;
                    this.say("FileRequestStatus fileID = " + nextID + " is Done => copying of " + frs.SURL + " is complete");
                    this.setReportSucceeded(new GlobusURL(frs.SURL), new GlobusURL(frs.TURL));
                    removeIDs.add(nextID);
                }
                this.fileIDs.removeAll(removeIDs);
                removeIDs = null;
                if (this.fileIDs.isEmpty()) {
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    break;
                }
                try {
                    int retrytime = rs.retryDeltaTime;
                    if (retrytime <= 0) {
                        retrytime = 1;
                    }
                    this.say("sleeping " + retrytime + " seconds ...");
                    Thread.sleep(retrytime * 1000);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                rs = this.srm.getRequestStatus(this.requestID);
                if (rs == null) {
                    throw new IOException(" null requests status");
                }
                if (rs.state.equals("Failed")) {
                    for (Integer nextID1 : this.fileIDs) {
                        RequestFileStatus frs = SRMCopyClientV1.getFileRequest(rs, nextID1);
                        if (frs.state.equals("Failed")) {
                            this.say("FileRequestStatus is Failed => copying of " + frs.SURL + " has failed");
                            this.setReportFailed(new GlobusURL(frs.SURL), new GlobusURL(frs.TURL), "copy failed" + rs.errorMessage);
                        }
                        if (frs.state.equals("Ready")) {
                            this.say("FileRequestStatus fileID = " + nextID1 + " is Ready => copying of " + frs.SURL + " is complete");
                            this.setReportSucceeded(new GlobusURL(frs.SURL), new GlobusURL(frs.TURL));
                        }
                        if (!frs.state.equals("Done")) continue;
                        this.say("FileRequestStatus fileID = " + nextID1 + " is Done => copying of " + frs.SURL + " is complete");
                        this.setReportSucceeded(new GlobusURL(frs.SURL), new GlobusURL(frs.TURL));
                    }
                    throw new IOException("Request with requestId =" + rs.requestId + " rs.state = " + rs.state + " rs.error = " + rs.errorMessage);
                }
                if (rs.fileStatuses.length == len) continue;
                this.esay("incorrect number of RequestFileStatuses in RequestStatus expected " + len + " received " + rs.fileStatuses.length);
                throw new IOException("incorrect number of RequestFileStatuses in RequestStatus expected " + len + " received " + rs.fileStatuses.length);
            }
        }
        catch (IOException ioe) {
            if (this.configuration.isDebug()) {
                ioe.printStackTrace();
            } else {
                this.esay(ioe.toString());
            }
            this.done(rs, this.srm);
            throw ioe;
        }
        finally {
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm copy of at least one file failed or not completed");
                System.exit(1);
            }
        }
    }

    @Override
    public void run() {
        this.say("setting all remaining file statuses of request requestId=" + this.requestID + " to \"Done\"");
        while (!this.fileIDs.isEmpty()) {
            Integer fileId = this.fileIDs.iterator().next();
            this.fileIDs.remove(fileId);
            this.say("setting file request " + fileId + " status to Done");
            RequestFileStatus rfs = this.fileIDsMap.get(fileId);
            this.srm.setFileStatus(this.requestID, rfs.fileId, "Done");
        }
        this.say("set all file statuses to \"Done\"");
    }
}

