/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import diskCacheV111.srm.ISRM;
import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Report;
import java.io.IOException;
import java.util.Date;
import org.dcache.srm.Logger;
import org.dcache.srm.client.SRMClientV1;
import org.dcache.srm.client.Transport;
import org.dcache.srm.client.TransportUtil;
import org.dcache.srm.security.SslGsiSocketFactory;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public abstract class SRMClient {
    private String gluepath;
    protected boolean debug;
    protected ISRM srm;
    protected String urlcopy;
    protected Configuration configuration;
    protected Logger logger;
    protected boolean doDelegation = false;
    protected boolean fullDelegation = false;
    protected String gss_expected_name = "host";
    protected long retrytimeout = 1000L;
    protected int retries = 10;
    protected Report report;

    public SRMClient(Configuration configuration) {
        this.configuration = configuration;
        this.logger = configuration.getLogger();
        this.gluepath = configuration.getWebservice_path();
        this.debug = configuration.isDebug();
        this.urlcopy = configuration.getUrlcopy();
        this.doDelegation = configuration.isDelegate();
        this.fullDelegation = configuration.isFull_delegation();
        this.gss_expected_name = configuration.getGss_expected_name();
        Transport transport = configuration.getTransport();
        this.dsay("In SRMClient ExpectedName: " + this.gss_expected_name);
        this.dsay("SRMClient(" + TransportUtil.uriSchemaFor((Transport)transport) + "," + this.gluepath + "," + transport.toString() + ")");
    }

    public void setUrlcopy(String urlcopy) {
        this.urlcopy = urlcopy;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static RequestFileStatus getFileRequest(RequestStatus rs, Integer nextID) {
        RequestFileStatus[] frs = rs.fileStatuses;
        if (frs == null) {
            return null;
        }
        for (int i = 0; i < frs.length; ++i) {
            if (frs[i].fileId != nextID) continue;
            return frs[i];
        }
        return null;
    }

    public final void say(String msg) {
        this.logger.log(new Date().toString() + ": " + msg);
    }

    public final void dsay(String msg) {
        if (this.debug) {
            this.logger.log(new Date().toString() + ": " + msg);
        }
    }

    public final void esay(String err) {
        this.logger.elog(new Date().toString() + ": " + err);
    }

    public final void edsay(String err) {
        if (this.debug) {
            this.logger.elog(new Date().toString() + ": " + err);
        }
    }

    public abstract void connect() throws Exception;

    public abstract void start() throws Exception;

    protected void connect(GlobusURL srmUrl) throws Exception {
        try {
            SRMClientV1 client = new SRMClientV1(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
            this.dsay("connected to server, obtaining proxy");
            this.srm = client;
            this.dsay("got proxy of type " + this.srm.getClass());
        }
        catch (Exception srme) {
            throw new IOException(srme.toString());
        }
        if (this.srm == null) {
            throw new IOException("can not get manager connection");
        }
    }

    public GSSCredential getGssCredential() throws Exception {
        if (this.configuration.isUseproxy()) {
            return SslGsiSocketFactory.createUserCredential((String)this.configuration.getX509_user_proxy(), null, null);
        }
        return SslGsiSocketFactory.createUserCredential(null, (String)this.configuration.getX509_user_cert(), (String)this.configuration.getX509_user_key());
    }

    public void done(RequestStatus rs, ISRM srm) {
        if (rs.fileStatuses != null) {
            for (int i = 0; i < rs.fileStatuses.length; ++i) {
                RequestFileStatus rfs = rs.fileStatuses[i];
                if (rfs.state.equals("Done") || rfs.state.equals("Failed")) continue;
                this.say("rfs.state is " + rfs.state + " calling setFileStatus(" + rs.requestId + "," + rfs.fileId + ",\"Done\")");
                srm.setFileStatus(rs.requestId, rfs.fileId, "Done");
            }
        }
    }

    private void setReportSuccessStatusBySource(GlobusURL url) {
        if (this.report == null) {
            return;
        }
        this.report.setStatusBySourceUrl(url, 0, null);
    }

    private void setReportSuccessStatusByDest(GlobusURL url) {
        if (this.report == null) {
            return;
        }
        this.report.setStatusByDestinationUrl(url, 0, null);
    }

    private void setReportSuccessStatusBySrcAndDest(GlobusURL srcurl, GlobusURL dsturl) {
        if (srcurl == null) {
            this.setReportSuccessStatusByDest(dsturl);
            return;
        }
        if (dsturl == null) {
            this.setReportSuccessStatusBySource(srcurl);
            return;
        }
        if (this.report == null) {
            return;
        }
        this.report.setStatusBySourceDestinationUrl(srcurl, dsturl, 0, null);
    }

    private void setReportFailedStatusBySource(GlobusURL url, String error) {
        if (this.report == null) {
            return;
        }
        if (error == null) {
            this.report.setStatusBySourceUrl(url, 1, "unknown error");
            return;
        }
        if ((error = error.replace('\n', ' ')).toLowerCase().indexOf("file exists") != -1) {
            this.report.setStatusBySourceUrl(url, 2, error);
            return;
        }
        if (error.toLowerCase().indexOf("permission") != -1) {
            this.report.setStatusBySourceUrl(url, 3, error);
            return;
        }
        this.report.setStatusBySourceUrl(url, 1, error);
    }

    private void setReportFailedStatusByDest(GlobusURL url, String error) {
        if (this.report == null) {
            return;
        }
        if (error == null) {
            this.report.setStatusByDestinationUrl(url, 1, "unknown error");
            return;
        }
        if ((error = error.replace('\n', ' ')).toLowerCase().indexOf("file exists") != -1) {
            this.report.setStatusByDestinationUrl(url, 2, error);
            return;
        }
        if (error.toLowerCase().indexOf("permission") != -1) {
            this.report.setStatusByDestinationUrl(url, 3, error);
            return;
        }
        this.report.setStatusByDestinationUrl(url, 1, error);
    }

    private void setReportFailedStatusBySrcAndDest(GlobusURL srcurl, GlobusURL dsturl, String error) {
        if (srcurl == null) {
            this.setReportFailedStatusByDest(dsturl, error);
            return;
        }
        if (dsturl == null) {
            this.setReportFailedStatusBySource(srcurl, error);
            return;
        }
        if (this.report == null) {
            return;
        }
        if (error == null) {
            this.report.setStatusBySourceDestinationUrl(srcurl, dsturl, 1, "unknown error");
            return;
        }
        if ((error = error.replace('\n', ' ')).toLowerCase().indexOf("file exists") != -1) {
            this.report.setStatusBySourceDestinationUrl(srcurl, dsturl, 2, error);
            return;
        }
        if (error.toLowerCase().indexOf("permission") != -1) {
            this.report.setStatusBySourceDestinationUrl(srcurl, dsturl, 3, error);
            return;
        }
        this.report.setStatusBySourceDestinationUrl(srcurl, dsturl, 1, error);
    }

    protected void setReportFailed(GlobusURL srcurl, GlobusURL dsturl, String error) {
        try {
            this.setReportFailedStatusBySrcAndDest(srcurl, dsturl, error);
        }
        catch (Exception e) {
            try {
                this.setReportFailedStatusByDest(dsturl, error);
            }
            catch (Exception e1) {
                this.setReportFailedStatusBySource(srcurl, error);
            }
        }
    }

    protected void setReportSucceeded(GlobusURL srcurl, GlobusURL dsturl) {
        try {
            this.setReportSuccessStatusBySrcAndDest(srcurl, dsturl);
        }
        catch (Exception e) {
            try {
                this.setReportSuccessStatusByDest(dsturl);
            }
            catch (Exception e1) {
                this.setReportSuccessStatusBySource(srcurl);
            }
        }
    }
}

