/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.request.AccessLatency;
import org.dcache.srm.request.RetentionPolicy;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ArrayOfTGetFileRequest;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmBringOnlineRequest;
import org.dcache.srm.v2_2.SrmBringOnlineResponse;
import org.dcache.srm.v2_2.SrmStatusOfBringOnlineRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfBringOnlineRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TBringOnlineRequestFileStatus;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TGetFileRequest;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.globus.util.GlobusURL;

public class SRMBringOnlineClientV2
extends SRMClient
implements Runnable {
    private String[] protocols;
    GlobusURL[] from;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    private String requestToken;
    private Thread hook;
    private ISRM srmv2;

    public SRMBringOnlineClientV2(Configuration configuration, GlobusURL[] from) {
        super(configuration);
        this.report = new Report(from, from, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.from[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            TAccessLatency al;
            int len = this.from.length;
            String[] SURLS = new String[len];
            TGetFileRequest[] fileRequests = new TGetFileRequest[len];
            for (int i = 0; i < len; ++i) {
                SURLS[i] = this.from[i].getURL();
                URI uri = new URI(SURLS[i]);
                fileRequests[i] = new TGetFileRequest();
                fileRequests[i].setSourceSURL(uri);
                this.pendingSurlsToIndex.put(SURLS[i], new Integer(i));
            }
            this.hook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.hook);
            SrmBringOnlineRequest srmBringOnlineRequest = new SrmBringOnlineRequest();
            srmBringOnlineRequest.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
            if (this.configuration.getDesiredLifetime() != null) {
                srmBringOnlineRequest.setDesiredLifeTime(new Integer(this.configuration.getDesiredLifetime().intValue()));
            }
            TRetentionPolicy rp = this.configuration.getRetentionPolicy() != null ? RetentionPolicy.fromString((String)this.configuration.getRetentionPolicy()).toTRetentionPolicy() : null;
            TAccessLatency tAccessLatency = al = this.configuration.getAccessLatency() != null ? AccessLatency.fromString((String)this.configuration.getAccessLatency()).toTAccessLatency() : null;
            if (al != null && rp == null) {
                throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
            }
            if (rp != null) {
                srmBringOnlineRequest.setTargetFileRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
            }
            srmBringOnlineRequest.setArrayOfFileRequests(new ArrayOfTGetFileRequest(fileRequests));
            TAccessPattern ap = null;
            if (this.configuration.getAccessPattern() != null) {
                ap = TAccessPattern.fromString((String)this.configuration.getAccessPattern());
            }
            TConnectionType ct = null;
            if (this.configuration.getConnectionType() != null) {
                ct = TConnectionType.fromString((String)this.configuration.getConnectionType());
            }
            ArrayOfString protocolArray = null;
            if (this.protocols != null) {
                protocolArray = new ArrayOfString(this.protocols);
            }
            ArrayOfString arrayOfClientNetworks = null;
            if (this.configuration.getArrayOfClientNetworks() != null) {
                arrayOfClientNetworks = new ArrayOfString(this.configuration.getArrayOfClientNetworks());
            }
            if (ap != null || ct != null || arrayOfClientNetworks != null || protocolArray != null) {
                srmBringOnlineRequest.setTransferParameters(new TTransferParameters(ap, ct, arrayOfClientNetworks, protocolArray));
            }
            if (this.configuration.getExtraParameters().size() > 0) {
                TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                int counter = 0;
                Map<String, String> extraParameters = this.configuration.getExtraParameters();
                for (String key : extraParameters.keySet()) {
                    String value = extraParameters.get(key);
                    extraInfoArray[counter++] = new TExtraInfo(key, value);
                }
                ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                srmBringOnlineRequest.setStorageSystemInfo(arrayOfExtraInfo);
            }
            this.say("calling srmBringOnline");
            SrmBringOnlineResponse response = this.srmv2.srmBringOnline(srmBringOnlineRequest);
            this.say("received response");
            if (response == null) {
                throw new IOException(" null response");
            }
            TReturnStatus status = response.getReturnStatus();
            if (status == null) {
                throw new IOException(" null return status");
            }
            TStatusCode statusCode = status.getStatusCode();
            if (statusCode == null) {
                throw new IOException(" null status code");
            }
            if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)status)) {
                throw new IOException("srmBringOnline submission failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
            }
            this.requestToken = response.getRequestToken();
            this.dsay(" srm returned requestToken = " + this.requestToken);
            if (response.getArrayOfFileStatuses() == null) {
                throw new IOException("returned bringOnlineRequestFileStatuses is an empty array");
            }
            TBringOnlineRequestFileStatus[] bringOnlineRequestFileStatuses = response.getArrayOfFileStatuses().getStatusArray();
            if (bringOnlineRequestFileStatuses.length != len) {
                throw new IOException("incorrect number of TBringOnlineRequestFileStatusin RequestStatus expected " + len + " received " + bringOnlineRequestFileStatuses.length);
            }
            while (!this.pendingSurlsToIndex.isEmpty()) {
                long estimatedWaitInSeconds = 5L;
                for (int i = 0; i < len; ++i) {
                    TBringOnlineRequestFileStatus bringOnlineRequestFileStatus = bringOnlineRequestFileStatuses[i];
                    URI surl = bringOnlineRequestFileStatus.getSourceSURL();
                    if (surl == null) {
                        this.esay("invalid bringOnlineRequestFileStatus, surl is null");
                        continue;
                    }
                    String surl_string = surl.toString();
                    if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                        this.esay("invalid bringOnlineRequestFileStatus, surl = " + surl_string + " not found");
                        continue;
                    }
                    TReturnStatus fileStatus = bringOnlineRequestFileStatus.getStatus();
                    if (fileStatus == null) {
                        throw new IOException(" null file return status");
                    }
                    TStatusCode fileStatusCode = fileStatus.getStatusCode();
                    if (fileStatusCode == null) {
                        throw new IOException(" null file status code");
                    }
                    if (RequestStatusTool.isFailedFileRequestStatus((TReturnStatus)fileStatus)) {
                        String error = "retrieval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                        this.esay(error);
                        int indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.setReportFailed(this.from[indx], this.from[indx], error);
                        continue;
                    }
                    if (fileStatus.getStatusCode() == TStatusCode.SRM_SUCCESS) {
                        int indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.setReportSucceeded(this.from[indx], this.from[indx]);
                        System.out.println(this.from[indx].getURL() + " brought online, use request id " + this.requestToken + " to release");
                        continue;
                    }
                    if (bringOnlineRequestFileStatus.getEstimatedWaitTime() == null || (long)bringOnlineRequestFileStatus.getEstimatedWaitTime().intValue() >= estimatedWaitInSeconds || bringOnlineRequestFileStatus.getEstimatedWaitTime() < 1) continue;
                    estimatedWaitInSeconds = bringOnlineRequestFileStatus.getEstimatedWaitTime().intValue();
                }
                if (this.pendingSurlsToIndex.isEmpty()) {
                    this.dsay("no more pending transfers, breaking the loop");
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    break;
                }
                if (estimatedWaitInSeconds > 60L) {
                    estimatedWaitInSeconds = 60L;
                }
                try {
                    this.say("sleeping " + estimatedWaitInSeconds + " seconds ...");
                    Thread.sleep(estimatedWaitInSeconds * 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                SrmStatusOfBringOnlineRequestRequest srmStatusOfBringOnlineRequestRequest = new SrmStatusOfBringOnlineRequestRequest();
                srmStatusOfBringOnlineRequestRequest.setRequestToken(this.requestToken);
                String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                int expectedResponseLength = pendingSurlStrings.length;
                URI[] surlArray = new URI[expectedResponseLength];
                for (int i = 0; i < expectedResponseLength; ++i) {
                    surlArray[i] = new URI(pendingSurlStrings[i]);
                }
                srmStatusOfBringOnlineRequestRequest.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArray));
                SrmStatusOfBringOnlineRequestResponse srmStatusOfBringOnlineRequestResponse = this.srmv2.srmStatusOfBringOnlineRequest(srmStatusOfBringOnlineRequestRequest);
                if (srmStatusOfBringOnlineRequestResponse == null) {
                    throw new IOException(" null srmStatusOfBringOnlineRequestResponse");
                }
                if (srmStatusOfBringOnlineRequestResponse.getArrayOfFileStatuses() == null) {
                    this.esay("incorrect number of RequestFileStatuses");
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                bringOnlineRequestFileStatuses = srmStatusOfBringOnlineRequestResponse.getArrayOfFileStatuses().getStatusArray();
                if (bringOnlineRequestFileStatuses == null || bringOnlineRequestFileStatuses.length != expectedResponseLength) {
                    this.esay("incorrect number of RequestFileStatuses");
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                status = srmStatusOfBringOnlineRequestResponse.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (!RequestStatusTool.isFailedRequestStatus((TReturnStatus)status)) continue;
                String error = "srmBringOnline update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                this.esay(error);
                for (int i = 0; i < expectedResponseLength; ++i) {
                    TReturnStatus frstatus = bringOnlineRequestFileStatuses[i].getStatus();
                    if (frstatus == null) continue;
                    if (!RequestStatusTool.isTransientStateStatus((TReturnStatus)frstatus)) {
                        int indx = this.pendingSurlsToIndex.remove(bringOnlineRequestFileStatuses[i].getSourceSURL().toString());
                        this.setReportFailed(this.from[indx], this.from[indx], error);
                    }
                    this.esay("BringOnlineFileRequest[" + bringOnlineRequestFileStatuses[i].getSourceSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                }
                throw new IOException(error);
            }
        }
        catch (Exception e) {
            this.say(e.toString());
        }
        finally {
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                System.err.println("srm bring online of at least one file failed or not completed");
                System.exit(1);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.abortAllPendingFiles();
        }
        catch (Exception e) {
            this.logger.elog(e.toString());
        }
    }

    private void abortAllPendingFiles() throws Exception {
        if (this.pendingSurlsToIndex.isEmpty()) {
            return;
        }
        if (this.requestToken != null) {
            String[] surl_strings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
            int len = surl_strings.length;
            this.say("Releasing all remaining file requests");
            URI[] surlArray = new URI[len];
            for (int i = 0; i < len; ++i) {
                surlArray[i] = new URI(surl_strings[i]);
            }
            SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
            srmAbortFilesRequest.setRequestToken(this.requestToken);
            srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
            SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
            if (srmAbortFilesResponse == null) {
                this.logger.elog(" srmAbortFilesResponse is null");
            } else {
                TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                if (returnStatus == null) {
                    this.esay("srmAbortFiles return status is null");
                    return;
                }
                this.say("srmAbortFiles status code=" + returnStatus.getStatusCode());
            }
        }
    }
}

